/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.FigureEvent;
import com.rameses.rcp.draw.FigureListener;
import com.rameses.rcp.draw.figures.TextFigure;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.support.AttributeKey;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.tools.CreationTool;
import com.rameses.rcp.draw.utils.DataUtil;
import com.rameses.rcp.draw.utils.DrawUtil;
import com.rameses.rcp.draw.utils.Geom;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFigure
implements Figure {
    private String id = this.hashCode() + "";
    private String type;
    private String name;
    private String caption;
    private String tooltip;
    private Rectangle displayBox = new Rectangle(0, 0);
    private List<Handle> handles = new ArrayList<Handle>();
    private boolean selected;
    private int index = 0;
    private boolean showIndex = false;
    private boolean system = false;
    private boolean allowResize = true;
    private boolean showHandle = true;
    private boolean connectionAllowed;
    private boolean startConnectionAllowed = this.connectionAllowed = true;
    private boolean endConnectionAllowed = this.connectionAllowed;
    private List<Connector> connectors = new ArrayList<Connector>();
    private TextFigure innerText;
    private Map info = new HashMap();
    private List<FigureListener> listeners = new ArrayList<FigureListener>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getCategory() {
        return "drawing";
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(String caption) {
        String oldCaption = this.caption;
        this.caption = caption;
        if (caption != null) {
            if (this.innerText == null) {
                this.innerText = new TextFigure(this.getCaption(), 0, 0);
                this.innerText.setParentFigure(this);
            } else {
                this.innerText.setText(this.getCaption());
            }
            this.centerInnerText();
        } else {
            this.innerText = null;
        }
        this.firePropertyChanged("caption", String.class, oldCaption, caption);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    @Override
    public void setSystem(boolean system) {
        this.system = system;
    }

    @Override
    public boolean getSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public int getToolIndex() {
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Tool getTool() {
        return new CreationTool();
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public void showHandles(boolean showHandle) {
        this.showHandle = showHandle;
    }

    @Override
    public void toggleShowIndex() {
        this.showIndex = !this.showIndex;
    }

    @Override
    public boolean isShowIndex() {
        return this.showIndex;
    }

    @Override
    public boolean isAllowResize() {
        return this.allowResize;
    }

    @Override
    public void setAllowResize(boolean allowResize) {
        this.allowResize = allowResize;
    }

    @Override
    public Rectangle getDisplayBox() {
        return this.displayBox;
    }

    @Override
    public Rectangle getBounds() {
        return this.displayBox;
    }

    @Override
    public Figure getInnerText() {
        return this.innerText;
    }

    @Override
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void setDisplayBox(Rectangle displayBox) {
        this.displayBox = displayBox;
        this.updateConnectors();
        this.centerInnerText();
    }

    @Override
    public void setDisplayBox(int x1, int y1, int x2, int y2) {
        Rectangle rect = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        this.setDisplayBox(rect);
        this.updateConnectors();
        this.centerInnerText();
    }

    @Override
    public int getX() {
        return this.getDisplayBox().x;
    }

    @Override
    public int getY() {
        return this.getDisplayBox().y;
    }

    @Override
    public Point getCenter() {
        Rectangle r = this.getDisplayBox();
        int x = r.x + r.width / 2;
        int y = r.y + r.height / 2;
        return new Point(x, y);
    }

    @Override
    public void center(Point pt) {
        Rectangle r = this.getDisplayBox();
        int dx = r.width / 2;
        int dy = r.height / 2;
        r.x = pt.x - dx;
        r.y = pt.y - dy;
    }

    @Override
    public boolean hitTest(int x, int y) {
        return this.getDisplayBox().contains(x, y);
    }

    @Override
    public void setLocation(Point pt) {
        Rectangle r = this.getDisplayBox();
        r.x = pt.x;
        r.y = pt.y;
    }

    @Override
    public final void moveBy(int dx, int dy, MouseEvent e) {
        this.move(dx, dy, e);
        this.moveInnerText(dx, dy, e);
    }

    protected void move(int dx, int dy, MouseEvent e) {
        int x = this.displayBox.x + dx;
        int y = this.displayBox.y + dy;
        this.displayBox.setLocation(x, y);
        for (Connector c : this.connectors) {
            c.moveBy(dx, dy, e, this);
        }
    }

    @Override
    public List<Handle> getHandles() {
        if (this.showHandle) {
            return this.handles;
        }
        return new ArrayList<Handle>();
    }

    @Override
    public void clearHandles() {
        this.handles.clear();
    }

    @Override
    public void addHandle(Handle handle) {
        if (!this.handles.contains(handle)) {
            this.handles.add(handle);
        }
    }

    @Override
    public void drawHandles(Graphics2D g) {
        for (Handle h : this.getHandles()) {
            h.draw(g);
        }
    }

    @Override
    public void drawConnectors(Graphics2D g) {
        for (Connector c : this.connectors) {
            c.draw(g);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        Font oldFont = g.getFont();
        this.drawFigure(g);
        this.drawCaption(g);
        if (this.showIndex) {
            this.drawIndex(g);
        }
        g.setFont(oldFont);
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    @Override
    public final Map getInfo() {
        return this.info;
    }

    protected abstract void drawFigure(Graphics2D var1);

    protected void drawCaption(Graphics2D g) {
        if (this.innerText != null) {
            this.innerText.drawFigure(g);
        }
    }

    protected void drawIndex(Graphics2D g) {
        if (this.showIndex) {
            Rectangle r = this.getDisplayBox();
            Dimension ts = DrawUtil.getTextSize(g, this.getIndex() + "");
            int x = r.x + (r.width - ts.width) / 2;
            int y = r.y + r.height + ts.height;
            g.setColor(Color.RED);
            g.drawString(this.getIndex() + "", x, y);
        }
    }

    @Override
    public void setRotation(int degree) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Figure)) {
            return false;
        }
        Figure other = (Figure)obj;
        return this.hashCode() == other.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getDisplayBox().getWidth() < (double)this.get(AttributeKeys.FIGURE_MINIMUM_WIDTH).intValue() || this.getDisplayBox().getHeight() <= (double)this.get(AttributeKeys.FIGURE_MINIMUM_HEIGHT).intValue();
    }

    @Override
    public boolean isConnectionAllowed() {
        return this.connectionAllowed;
    }

    @Override
    public void setConnectionAllowed(boolean allowed) {
        this.connectionAllowed = allowed;
    }

    @Override
    public boolean isStartConnectionAllowed() {
        return this.startConnectionAllowed;
    }

    @Override
    public void setStartConnectionAllowed(boolean allowed) {
        this.startConnectionAllowed = allowed;
    }

    @Override
    public boolean isEndConnectionAllowed() {
        return this.endConnectionAllowed;
    }

    @Override
    public void setEndConnectionAllowed(boolean allowed) {
        this.endConnectionAllowed = allowed;
    }

    @Override
    public List<Connector> getConnectors() {
        return this.connectors;
    }

    @Override
    public void addConnector(Connector connector) {
        if (connector != null && !this.connectors.contains(connector)) {
            this.connectors.add(connector);
        }
    }

    @Override
    public void removeConnector(Connector connector) {
        if (connector != null && this.connectors.contains(connector)) {
            this.connectors.remove(connector);
        }
    }

    @Override
    public Point intersect(Point p) {
        Rectangle r = this.getDisplayBox();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(Geom.northWest(r));
        points.add(Geom.northEast(r));
        points.add(Geom.southEast(r));
        points.add(Geom.southWest(r));
        points.add(Geom.northWest(r));
        Point center = this.getCenter();
        Point p1 = (Point)points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Point p2 = (Point)points.get(i);
            Point intersect = Geom.intersect(p1.x, p1.y, p2.x, p2.y, p.x, p.y, center.x, center.y);
            if (intersect != null) {
                return intersect;
            }
            p1 = p2;
        }
        return null;
    }

    @Override
    public void readAttributes(Map prop) {
        this.setId(DataUtil.decodeString("id", prop));
        this.setName(DataUtil.decodeString("name", prop));
        this.setIndex(DataUtil.decodeInt("index", prop));
        this.setTooltip(DataUtil.decodeString("tooltip", prop));
        Object o = prop.get("info");
        if (o != null && o instanceof Map) {
            this.info = (Map)o;
        }
        Map ui = (Map)prop.get("ui");
        Point pos = DataUtil.decodePoint("pos", ui);
        Dimension size = DataUtil.decodeSize("size", ui);
        this.setDisplayBox(pos.x, pos.y, pos.x + size.width, pos.y + size.height);
        this.setCaption(DataUtil.decodeString("caption", prop));
        Map inner = (Map)prop.get("inner");
        if (inner != null && this.innerText != null) {
            this.innerText.readAttributes(inner);
        }
    }

    @Override
    public Map toMap() {
        HashMap<String, Map> map = new HashMap<String, Map>();
        DataUtil.putValue(map, "id", this.getId());
        DataUtil.putValue(map, "name", this.getName());
        DataUtil.putValue(map, "index", this.getIndex());
        DataUtil.putValue(map, "caption", this.getCaption());
        DataUtil.putValue(map, "tooltip", this.getTooltip());
        map.put("info", this.getInfo());
        Rectangle r = this.getDisplayBox();
        HashMap ui = new HashMap();
        DataUtil.putValue(ui, "type", this.getType());
        DataUtil.putValue(ui, "pos", DataUtil.encodePos(r));
        DataUtil.putValue(ui, "size", DataUtil.encodeSize(r));
        if (this.innerText != null) {
            map.put("inner", this.innerText.toMap());
        }
        map.put("ui", ui);
        return map;
    }

    private void updateConnectors() {
        if (this.getConnectors().isEmpty()) {
            return;
        }
        for (Connector connector : this.getConnectors()) {
            Point pt;
            Figure figure;
            if (connector.getStartFigure() == this) {
                figure = connector.getStartFigure();
                pt = figure.intersect(connector.getPoints().get(1));
                this.updatePoint(connector.getPoints().get(0), pt);
                continue;
            }
            if (connector.getEndFigure() != this) continue;
            int idx = connector.getPoints().size() - 2;
            figure = connector.getEndFigure();
            pt = figure.intersect(connector.getPoints().get(idx));
            this.updatePoint(connector.getPoints().get(idx + 1), pt);
        }
    }

    protected void moveInnerText(int dx, int dy, MouseEvent e) {
        if (this.innerText != null) {
            this.innerText.moveInner(dx, dy);
        }
    }

    protected void centerInnerText() {
        if (this.innerText != null && this.get(AttributeKeys.CENTER_TEXT).booleanValue()) {
            Rectangle pr = this.getDisplayBox();
            Rectangle ir = this.innerText.getDisplayBox();
            int dx = (pr.width - ir.width) / 2;
            int dy = (pr.height - ir.height) / 2;
            ir.x = pr.x + dx;
            ir.y = pr.y + dy;
            this.innerText.updateRotatedRect();
        }
    }

    private void updatePoint(Point pt, Point newPt) {
        pt.x = newPt.x;
        pt.y = newPt.y;
    }

    @Override
    public void addFigureListener(FigureListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeFigureListener(FigureListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    protected void fireAttributedChanged(AttributeKey key, Object oldValue, Object newValue) {
        if (!(this.listeners.isEmpty() || oldValue != null && newValue != null && oldValue.equals(newValue))) {
            FigureEvent event = new FigureEvent(this, key, oldValue, newValue);
            for (FigureListener listener : this.listeners) {
                listener.attributeChanged(event);
            }
        }
    }

    private void firePropertyChanged(String propertyName, Class type, String oldValue, String newValue) {
        if (!(this.listeners.isEmpty() || oldValue != null && newValue != null && oldValue.equals(newValue))) {
            FigureEvent event = new FigureEvent(this, propertyName, type, oldValue, newValue);
            for (FigureListener listener : this.listeners) {
                listener.propertyChanged(event);
            }
        }
    }
}

