/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.AbstractFigure;
import com.rameses.rcp.draw.support.AttributeKey;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.utils.DataUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAttributedFigure
extends AbstractFigure {
    private HashMap<AttributeKey, Object> attributes = new HashMap();

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    @Override
    public void setAttributes(Map<AttributeKey, Object> map) {
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        T oldValue = this.get(key);
        key.put(this.attributes, newValue);
        this.fireAttributedChanged(key, oldValue, newValue);
    }

    @Override
    public <T> T get(AttributeKey<T> key) {
        return key.get(this.attributes);
    }

    @Override
    public void readAttributes(Map prop) {
        super.readAttributes(prop);
        Map ui = (Map)prop.get("ui");
        for (Map.Entry entry : ui.entrySet()) {
            AttributeKey key = AttributeKeys.findByKey((String)entry.getKey());
            if (key == null) continue;
            this.set(key, DataUtil.decode(entry.getValue(), key.getAttributeClass()));
        }
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        Map ui = (Map)map.get("ui");
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            ui.put(entry.getKey().getKey(), DataUtil.encode(entry.getValue()));
        }
        return map;
    }
}

