/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.decorators;

import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.LineDecoration;
import com.rameses.rcp.draw.support.AttributeKeys;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public abstract class AbstractLineDecoration
implements LineDecoration {
    private boolean filled;
    private boolean stroked;
    private boolean solid;

    public AbstractLineDecoration() {
        this(true, true, true);
    }

    public AbstractLineDecoration(boolean filled, boolean stroked, boolean solid) {
        this.filled = filled;
        this.stroked = stroked;
        this.solid = solid;
    }

    protected abstract Path2D.Double getDecoratorPath(Figure var1);

    protected abstract double getDecoratorPathRadius(Figure var1);

    @Override
    public void draw(Graphics2D g, Figure f, Point2D.Double p1, Point2D.Double p2) {
        Color color;
        Path2D.Double path = this.getTransformedDecoratorPath(f, p1, p2);
        if (this.isFilled() && (color = this.isSolid() ? f.get(AttributeKeys.STROKE_COLOR) : f.get(AttributeKeys.FILL_COLOR)) != null) {
            g.setColor(color);
            g.fill(path);
        }
        if (this.isStroked() && (color = f.get(AttributeKeys.STROKE_COLOR)) != null) {
            g.setColor(color);
            g.setStroke(AttributeKeys.getStroke(f));
            g.draw(path);
        }
    }

    protected boolean isFilled() {
        return this.filled;
    }

    protected void setFilled(boolean filled) {
        this.filled = filled;
    }

    protected boolean isStroked() {
        return this.stroked;
    }

    protected void setStroked(boolean stroked) {
        this.stroked = stroked;
    }

    protected boolean isSolid() {
        return this.solid;
    }

    protected void setSolid(boolean solid) {
        this.solid = solid;
    }

    private Path2D.Double getTransformedDecoratorPath(Figure f, Point2D.Double p1, Point2D.Double p2) {
        Path2D.Double path = this.getDecoratorPath(f);
        double strokeWidth = 1.0;
        AffineTransform transform = new AffineTransform();
        transform.translate(p1.x, p1.y);
        transform.rotate(Math.atan2(p1.x - p2.x, p2.y - p1.y));
        if (strokeWidth > 1.0) {
            transform.scale(1.0 + (strokeWidth - 1.0) / 2.0, 1.0 + (strokeWidth - 1.0) / 2.0);
        }
        path.transform(transform);
        return path;
    }
}

