/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.components;

import com.rameses.rcp.common.ComponentBean;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.control.XComboBox;
import com.rameses.rcp.control.XComponentPanel;
import com.rameses.rcp.control.XFormPanel;
import com.rameses.rcp.draw.components.AttributePickerModel;
import com.rameses.rcp.draw.components.ColorButton;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.utils.DataUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

@com.rameses.rcp.ui.annotations.ComponentBean(value="com.rameses.rcp.draw.components.FontPickerComponentModel")
public class FontPickerComponent
extends XComponentPanel
implements AdjustmentListener {
    protected AttributePickerModel model;
    protected ComponentBean bean;
    private String handler;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel pnlColor;
    private JScrollBar rotationBar;
    private XButton xButton1;
    private XButton xButton2;
    private XButton xButton3;
    private XButton xButton4;
    private XComboBox xComboBox1;
    private XComboBox xComboBox2;
    private XFormPanel xFormPanel1;
    private XFormPanel xFormPanel2;

    public FontPickerComponent() {
        this.initComponents();
    }

    public String getHandler() {
        if (this.handler == null) {
            System.out.println("handler must be specified in component.");
        }
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    protected void initComponentBean(ComponentBean bean) {
        this.bean = bean;
        this.model = (AttributePickerModel)this.getProperty(this.getHandler());
        bean.setProperty("model", (Object)this.model);
        this.setupRotationBar();
        this.setupColorPanel();
    }

    private void initComponents() {
        this.xFormPanel1 = new XFormPanel();
        this.xComboBox1 = new XComboBox();
        this.jPanel2 = new JPanel();
        this.xFormPanel2 = new XFormPanel();
        this.xButton1 = new XButton();
        this.xButton2 = new XButton();
        this.xButton3 = new XButton();
        this.xComboBox2 = new XComboBox();
        this.jPanel1 = new JPanel();
        this.pnlColor = new JPanel();
        this.xButton4 = new XButton();
        this.rotationBar = new JScrollBar();
        this.setPreferredSize(new Dimension(199, 185));
        this.setLayout(new BorderLayout());
        this.xFormPanel1.setOrientation("HORIZONTAL");
        this.xComboBox1.setImmediate(true);
        this.xComboBox1.setItems("fontFamilies");
        this.xComboBox1.setName("entity.family");
        this.xComboBox1.setPreferredSize(new Dimension(56, 24));
        this.xComboBox1.setShowCaption(false);
        this.xComboBox1.setStretchWidth(80);
        this.xFormPanel1.add((Component)this.xComboBox1);
        this.add((Component)this.xFormPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.xFormPanel2.setOrientation("HORIZONTAL");
        this.xButton1.setFocusable(false);
        this.xButton1.setFont(new Font("Tahoma", 1, 14));
        this.xButton1.setHorizontalTextPosition(0);
        this.xButton1.setName("bold");
        this.xButton1.setShowCaption(false);
        this.xButton1.setStretchWidth(20);
        this.xButton1.setText("B");
        this.xButton1.setVerticalTextPosition(3);
        this.xFormPanel2.add((Component)this.xButton1);
        this.xButton2.setFocusable(false);
        this.xButton2.setFont(new Font("Tahoma", 3, 14));
        this.xButton2.setHorizontalTextPosition(0);
        this.xButton2.setName("italic");
        this.xButton2.setShowCaption(false);
        this.xButton2.setStretchWidth(20);
        this.xButton2.setText("I");
        this.xButton2.setVerticalTextPosition(3);
        this.xFormPanel2.add((Component)this.xButton2);
        this.xButton3.setFocusable(false);
        this.xButton3.setFont(new Font("Tahoma", 0, 14));
        this.xButton3.setHorizontalTextPosition(0);
        this.xButton3.setName("underline");
        this.xButton3.setShowCaption(false);
        this.xButton3.setStretchWidth(20);
        this.xButton3.setText("U");
        this.xButton3.setVerticalTextPosition(3);
        this.xFormPanel2.add((Component)this.xButton3);
        this.xComboBox2.setImmediate(true);
        this.xComboBox2.setItems("fontSizes");
        this.xComboBox2.setName("entity.size");
        this.xComboBox2.setPreferredSize(new Dimension(56, 23));
        this.xComboBox2.setShowCaption(false);
        this.xComboBox2.setStretchWidth(25);
        this.xFormPanel2.add((Component)this.xComboBox2);
        this.jPanel2.add((Component)this.xFormPanel2, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this.pnlColor.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.pnlColor.setPreferredSize(new Dimension(117, 80));
        this.pnlColor.setLayout(new GridLayout(3, 0));
        this.jPanel1.add((Component)this.pnlColor, "Center");
        this.xButton4.setMargin(new Insets(5, 5, 5, 5));
        this.xButton4.setName("showColorChoosers");
        this.xButton4.setText("More Font Colors...");
        this.jPanel1.add((Component)this.xButton4, "South");
        this.jPanel2.add((Component)this.jPanel1, "Center");
        this.rotationBar.setOrientation(0);
        this.rotationBar.setToolTipText("Rotation");
        this.rotationBar.setVisibleAmount(20);
        this.rotationBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.rotationBar.setPreferredSize(new Dimension(48, 20));
        this.jPanel2.add((Component)this.rotationBar, "South");
        this.add(this.jPanel2, "South");
    }

    private void setupRotationBar() {
        int visibleValue = 20;
        this.rotationBar.setMaximum(360 + visibleValue);
        Object r = this.bean.getProperty("rotation");
        if (r == null) {
            this.rotationBar.setValue(0);
        } else {
            this.rotationBar.setValue(DataUtil.toInt(r, 0));
        }
        this.rotationBar.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        double rotation = e.getValue();
        this.model.getEditor().attributeChanged(AttributeKeys.ROTATION_ANGLE, rotation);
    }

    private void setupColorPanel() {
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.BLACK));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.BLUE));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.CYAN));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.GRAY));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.GREEN));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.LIGHT_GRAY));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.MAGENTA));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.ORANGE));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.PINK));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.RED));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.WHITE));
        this.pnlColor.add(new ColorButton(this.model, AttributeKeys.TEXT_COLOR, Color.YELLOW));
    }
}

