/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.components;

import com.rameses.osiris2.client.Inv;
import com.rameses.osiris2.client.InvokerAction;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.ComponentBean;
import com.rameses.rcp.common.DrawModel;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.draw.DrawingEditor;
import com.rameses.rcp.draw.StdDrawing;
import com.rameses.rcp.draw.actions.AttributePickerAction;
import com.rameses.rcp.draw.actions.CenterCaptionAction;
import com.rameses.rcp.draw.actions.DrawAction;
import com.rameses.rcp.draw.actions.FigureAction;
import com.rameses.rcp.draw.actions.FontSelectionAction;
import com.rameses.rcp.draw.actions.ReIndexAction;
import com.rameses.rcp.draw.actions.SelectionAction;
import com.rameses.rcp.draw.actions.ShowIndexAction;
import com.rameses.rcp.draw.figures.FigureCache;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Drawing;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.EditorListener;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.support.AttributeKeys;
import java.util.ArrayList;
import java.util.List;

public class DrawComponentModel
extends ComponentBean
implements EditorListener {
    private String category;
    private Editor editor = new DrawingEditor();
    private Drawing drawing;
    private DrawModel handler;

    public DrawComponentModel() {
        this.editor.setDrawing(this.createDrawing());
        this.editor.addListener(this);
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    public DrawModel getHandler() {
        return this.handler;
    }

    public void setHandler(DrawModel handler) {
        this.handler = handler;
        if (handler != null) {
            this.handler.setComponentModel(this);
            this.handler.setEditor(this.editor);
            this.handler.reload();
        }
    }

    public List getDrawTools() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.category != null) {
            for (Figure f : FigureCache.getInstance().getFigures(this.category)) {
                actions.add(this.createFigureAction(f));
            }
        }
        return actions;
    }

    public List getEditTools() {
        ArrayList<DrawAction> actions = new ArrayList<DrawAction>();
        actions.add(new SelectionAction(this.editor));
        actions.add(new FontSelectionAction(this.editor));
        actions.add(new AttributePickerAction(this.editor, AttributeKeys.FILL_COLOR, "Fill Color", "images/draw/shapefill16.png"));
        actions.add(new AttributePickerAction(this.editor, AttributeKeys.STROKE_COLOR, "Stroke Color", "images/draw/strokecolor16.png"));
        actions.add(new ShowIndexAction(this.editor));
        actions.add(new ReIndexAction(this.editor));
        actions.add(new CenterCaptionAction(this.editor));
        return actions;
    }

    public List getCategories() {
        List<Object> list = new ArrayList();
        if (this.handler != null) {
            Object o = this.handler.fetchCategories();
            if (o instanceof List) {
                list = (List)o;
            } else if (o instanceof String) {
                String regex = o.toString();
                list = FigureCache.getInstance().getCategories(regex);
            }
        }
        if (list == null || list.isEmpty()) {
            list = FigureCache.getInstance().getCategories();
        }
        return list;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isShowcategories() {
        boolean show = true;
        if (this.handler != null) {
            show = this.handler.showCategories();
        } else if (this.getCategories().size() == 1) {
            show = false;
        }
        return show;
    }

    private Drawing createDrawing() {
        return new StdDrawing();
    }

    private Action createFigureAction(Figure figure) {
        FigureAction action = new FigureAction(this.editor, figure);
        action.setIcon(figure.getIcon());
        if (action.getIcon() != null) {
            action.setTooltip(figure.getToolCaption());
        } else {
            action.setCaption(figure.getToolCaption());
        }
        return action;
    }

    @Override
    public void openFigure(Figure figure) {
        if (this.handler == null) {
            return;
        }
        Object val = this.handler.open(figure);
        if (val instanceof Opener) {
            Inv.invoke((Opener)((Opener)val));
        } else if (val instanceof InvokerAction) {
            Inv.invokeAction((InvokerAction)((InvokerAction)val));
        } else if (val instanceof Action) {
            ((Action)val).execute();
        } else if (val instanceof String) {
            super.getBinding().fireNavigation((Object)val.toString());
        }
    }

    @Override
    public void figureAdded(Figure figure) {
        if (this.handler != null) {
            this.handler.onAddItem(figure);
        }
    }

    @Override
    public boolean beforeRemoveFigures(List<Figure> figures) {
        if (this.handler != null) {
            try {
                return this.handler.beforeRemove(figures);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public void afterRemoveFigures(List<Figure> deletedItems) {
        if (this.handler != null) {
            this.handler.afterRemove(deletedItems);
        }
    }

    @Override
    public void connectionChanged(Connector c, Figure fromFigure, Figure toFigure) {
        if (this.handler != null) {
            this.handler.connectionChanged(c, fromFigure, toFigure);
        }
    }

    @Override
    public List showMenu(Figure figure) {
        List items;
        ArrayList menus = new ArrayList();
        if (this.handler != null && !(items = this.handler.showMenu(figure)).isEmpty()) {
            menus.addAll(items);
        }
        return menus;
    }

    public boolean isShowToolbars() {
        if (this.handler.isReadonly()) {
            return false;
        }
        if (this.handler != null) {
            return this.handler.showToolbars();
        }
        return true;
    }

    public boolean isShowDrawTools() {
        if (this.handler.isReadonly()) {
            return false;
        }
        if (this.handler != null) {
            return this.handler.showDrawTools();
        }
        return true;
    }

    public boolean isShowEditTools() {
        if (this.handler.isReadonly()) {
            return false;
        }
        if (this.handler != null) {
            return this.handler.showEditTools();
        }
        return true;
    }
}

