/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.components;

import com.rameses.rcp.common.ComponentBean;
import com.rameses.rcp.control.XComponentPanel;
import com.rameses.rcp.control.menu.VMenuBar;
import com.rameses.rcp.draw.components.AttributeMenu;
import com.rameses.rcp.draw.components.AttributeMenuItem;
import com.rameses.rcp.draw.components.AttributePickerModel;
import com.rameses.rcp.draw.components.ColorButton;
import com.rameses.rcp.draw.components.MenuItem;
import com.rameses.rcp.draw.components.OutlineDashMenuItemRenderer;
import com.rameses.rcp.draw.components.OutlineWeightMenuItemRenderer;
import com.rameses.rcp.draw.support.AttributeKeys;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;

@com.rameses.rcp.ui.annotations.ComponentBean(value="com.rameses.rcp.draw.components.AttributePickerComponentModel")
public class AttributePickerComponent
extends XComponentPanel {
    private String handler;
    private VMenuBar menuBar;
    protected AttributePickerModel model;
    protected ComponentBean bean;
    private JPanel panel;

    public AttributePickerComponent() {
        this.initComponents();
    }

    public String getHandler() {
        if (this.handler == null) {
            System.out.println("handler must be specified.");
        }
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    protected void initComponentBean(ComponentBean bean) {
        this.bean = bean;
        this.model = (AttributePickerModel)this.getProperty(this.getHandler());
        bean.setProperty("model", (Object)this.model);
        this.loadMenuItems();
        this.loadColorButtons();
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.setLayout(new BorderLayout());
        this.panel.setPreferredSize(new Dimension(165, 60));
        this.panel.setLayout(new GridLayout(3, 0));
        this.add(this.panel, "Center");
    }

    private void loadMenuItems() {
        this.menuBar = new VMenuBar();
        this.menuBar.setLayout((LayoutManager)new GridLayout(0, 1));
        this.add((Component)this.menuBar, "South");
        String text = "More Colors...";
        if (this.model.getCaption() != null) {
            text = "More " + this.model.getCaption() + "s ...";
        }
        this.menuBar.add((Component)new MenuItem(text, "openColorChooser", this.bean, this.model));
        this.menuBar.add((Component)((Object)this.createOutlineWeightMenuItems()));
        this.menuBar.add((Component)((Object)this.createOutlineDashMenuItems()));
    }

    private AttributeMenu createOutlineWeightMenuItems() {
        AttributeMenu weight = new AttributeMenu("Weight", this.bean, this.model);
        double[] values = new double[]{0.25, 0.5, 0.75, 1.0, 2.0, 3.0, 5.0, 8.0, 10.0};
        for (int i = 0; i < values.length; ++i) {
            String text = String.format("%f pt", values[i]);
            AttributeMenuItem mi = new AttributeMenuItem(text, this.model, AttributeKeys.STROKE_WIDTH, values[i]);
            mi.setRenderer(new OutlineWeightMenuItemRenderer(mi));
            weight.add(mi);
        }
        weight.add(new MenuItem("More Outlines...", "openOutlines", this.bean, this.model));
        return weight;
    }

    private AttributeMenu createOutlineDashMenuItems() {
        double[][] values = new double[][]{{0.0}, {1.0}, {2.0}, {3.0}, {5.0}, {7.0}, {9.0, 4.0, 2.0, 4.0}};
        AttributeMenu dashes = new AttributeMenu("Dashes", this.bean, this.model);
        for (int i = 0; i < values.length; ++i) {
            AttributeMenuItem mi = new AttributeMenuItem(null, this.model, AttributeKeys.STROKE_DASHES, values[i]);
            mi.setRenderer(new OutlineDashMenuItemRenderer(mi));
            dashes.add(mi);
        }
        return dashes;
    }

    private void loadColorButtons() {
        this.panel.add(new ColorButton(this.model, Color.BLACK));
        this.panel.add(new ColorButton(this.model, Color.BLUE));
        this.panel.add(new ColorButton(this.model, Color.CYAN));
        this.panel.add(new ColorButton(this.model, Color.GRAY));
        this.panel.add(new ColorButton(this.model, Color.GREEN));
        this.panel.add(new ColorButton(this.model, Color.LIGHT_GRAY));
        this.panel.add(new ColorButton(this.model, Color.MAGENTA));
        this.panel.add(new ColorButton(this.model, Color.ORANGE));
        this.panel.add(new ColorButton(this.model, Color.PINK));
        this.panel.add(new ColorButton(this.model, Color.RED));
        this.panel.add(new ColorButton(this.model, Color.WHITE));
        this.panel.add(new ColorButton(this.model, Color.YELLOW));
    }
}

