/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.commands;

import com.rameses.rcp.draw.commands.Command;
import com.rameses.rcp.draw.figures.WorkflowStartNode;
import com.rameses.rcp.draw.interfaces.Canvas;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Figure;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ReindexCommand
extends Command {
    public ReindexCommand(Canvas canvas) {
        super("draw_reindex", canvas);
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 640, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.clearIndexes();
        int idx = 0;
        Figure f = this.findStartFigure();
        if (f == null) {
            return;
        }
        this.reindex(f, idx);
        this.getCanvas().refresh();
    }

    private void reindex(Figure f, int idx) {
        if (f.getIndex() != 0 && f.getIndex() < idx) {
            return;
        }
        f.setIndex(++idx);
        for (Connector c : f.getConnectors()) {
            if (c.getStartFigure() != f) continue;
            this.reindex(c.getEndFigure(), idx);
        }
    }

    private Figure findStartFigure() {
        for (Figure f : this.getDrawing().getFigures()) {
            if (!(f instanceof WorkflowStartNode)) continue;
            return f;
        }
        return null;
    }

    private void clearIndexes() {
        for (Figure f : this.getDrawing().getFigures()) {
            if (f instanceof Connector) continue;
            f.setIndex(0);
        }
    }
}

