/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.commands;

import com.rameses.rcp.draw.commands.ArrangeBackwardCommand;
import com.rameses.rcp.draw.commands.ArrangeForwardCommand;
import com.rameses.rcp.draw.commands.ArrangeToBackCommand;
import com.rameses.rcp.draw.commands.ArrangeToFrontCommand;
import com.rameses.rcp.draw.commands.CancelAddFigureCommand;
import com.rameses.rcp.draw.commands.CenterTextCommand;
import com.rameses.rcp.draw.commands.Command;
import com.rameses.rcp.draw.commands.DeleteCommand;
import com.rameses.rcp.draw.commands.MoveEastCommand;
import com.rameses.rcp.draw.commands.MoveNorthCommand;
import com.rameses.rcp.draw.commands.MoveSouthCommand;
import com.rameses.rcp.draw.commands.MoveWestCommand;
import com.rameses.rcp.draw.commands.RedoCommand;
import com.rameses.rcp.draw.commands.ReindexCommand;
import com.rameses.rcp.draw.commands.ShowIndexCommand;
import com.rameses.rcp.draw.commands.UndoCommand;
import com.rameses.rcp.draw.interfaces.Canvas;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class Commands {
    private List<Command> commands = new ArrayList<Command>();
    private Canvas canvas;

    public Commands(Canvas canvas) {
        this.canvas = canvas;
    }

    public void registerCommands() {
        this.buildCommands();
        JComponent comp = (JComponent)((Object)this.canvas);
        for (Command c : this.commands) {
            comp.getInputMap().put(c.getKeyStroke(), c.getName());
            comp.getActionMap().put(c.getName(), c);
        }
    }

    private void buildCommands() {
        this.commands.add(new DeleteCommand(this.canvas));
        this.commands.add(new CancelAddFigureCommand(this.canvas));
        this.commands.add(new ArrangeForwardCommand(this.canvas));
        this.commands.add(new ArrangeToFrontCommand(this.canvas));
        this.commands.add(new ArrangeBackwardCommand(this.canvas));
        this.commands.add(new ArrangeToBackCommand(this.canvas));
        this.commands.add(new MoveNorthCommand(this.canvas));
        this.commands.add(new MoveSouthCommand(this.canvas));
        this.commands.add(new MoveEastCommand(this.canvas));
        this.commands.add(new MoveWestCommand(this.canvas));
        this.commands.add(new ShowIndexCommand(this.canvas));
        this.commands.add(new ReindexCommand(this.canvas));
        this.commands.add(new UndoCommand(this.canvas));
        this.commands.add(new RedoCommand(this.canvas));
        this.commands.add(new CenterTextCommand(this.canvas));
    }
}

