/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw;

import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Drawing;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StdDrawing
implements Drawing {
    private List<Figure> figures = new ArrayList<Figure>();
    private List<Figure> selections = new ArrayList<Figure>();
    private List<Connector> connectors = new ArrayList<Connector>();
    private boolean showHandles = false;

    @Override
    public void draw(Graphics2D g) {
        for (Connector c : this.getConnectors()) {
            c.draw(g);
        }
        for (Figure f : this.getFigures()) {
            f.draw(g);
        }
        for (Figure f : this.getSelections()) {
            f.drawHandles(g);
        }
    }

    @Override
    public void setShowHandles(boolean showHandles) {
        this.showHandles = showHandles;
        for (Figure f : this.getFigures()) {
            f.showHandles(showHandles);
        }
    }

    @Override
    public List<Figure> getFigures() {
        return this.figures;
    }

    @Override
    public Figure addFigure(Figure figure) {
        if (!this.figures.contains(figure)) {
            this.figures.add(figure);
        }
        return figure;
    }

    @Override
    public void removeFigure(Figure figure) {
        if (this.figures.contains(figure)) {
            for (Connector c : figure.getConnectors()) {
                this.removeConnector(c);
            }
            this.figures.remove(figure);
            this.connectors.remove(figure);
        }
    }

    @Override
    public List<Figure> getSelections() {
        return this.selections;
    }

    @Override
    public boolean hasMultipleSelections() {
        return this.selections.size() > 1;
    }

    @Override
    public void clearSelections() {
        for (Figure figure : this.selections) {
            figure.setSelected(false);
        }
        this.selections.clear();
    }

    @Override
    public void clearFigures() {
        this.figures.clear();
        this.clearSelections();
        this.clearConnectors();
    }

    @Override
    public void addSelection(Figure figure) {
        if (figure != null && !this.selections.contains(figure)) {
            figure.setSelected(true);
            this.selections.add(figure);
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.removeSelection(figure);
        } else {
            this.addSelection(figure);
        }
    }

    @Override
    public void removeSelection(Figure figure) {
        if (this.selections.contains(figure)) {
            figure.setSelected(false);
            this.selections.remove(figure);
        }
    }

    @Override
    public Figure figureAt(int x, int y) {
        return this.figureAt(x, y, null);
    }

    @Override
    public Figure figureAt(int x, int y, Figure exclude) {
        if (this.figures.isEmpty()) {
            return null;
        }
        for (int i = this.figures.size() - 1; i >= 0; --i) {
            Figure f = this.figures.get(i);
            if (f == exclude || !f.hitTest(x, y)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure innerFigureAt(int x, int y) {
        if (this.figures.isEmpty()) {
            return null;
        }
        for (int i = this.figures.size() - 1; i >= 0; --i) {
            Figure f = this.figures.get(i);
            Figure inner = f.getInnerText();
            if (inner == null || !inner.hitTest(x, y)) continue;
            this.removeSelection(f);
            return inner;
        }
        return null;
    }

    @Override
    public Figure figureById(String id) {
        if (id != null) {
            for (Figure f : this.getFigures()) {
                if (!f.getId().equalsIgnoreCase(id)) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public Figure figureByName(String name) {
        if (name != null) {
            for (Figure f : this.getFigures()) {
                if (!name.equalsIgnoreCase(f.getName())) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public Handle handleAt(int x, int y) {
        for (Figure f : this.getSelections()) {
            for (Handle h : f.getHandles()) {
                if (!h.locate(x, y)) continue;
                return h;
            }
        }
        return null;
    }

    @Override
    public Connector connectorAt(int x, int y) {
        for (Connector c : this.getConnectors()) {
            if (!((Figure)((Object)c)).hitTest(x, y)) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean isFigureSelected(Figure figure) {
        for (Figure f : this.selections) {
            if (!figure.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Connector> getConnectors() {
        return this.connectors;
    }

    @Override
    public void addConnector(Connector connector) {
        if (connector == null) {
            return;
        }
        if (!this.connectors.contains(connector)) {
            this.connectors.add(connector);
            this.addFigure((Figure)((Object)connector));
        }
    }

    @Override
    public void removeConnector(Connector connector) {
        if (connector == null) {
            return;
        }
        if (this.connectors.contains(connector)) {
            this.connectors.remove(connector);
            this.removeFigure((Figure)((Object)connector));
        }
    }

    @Override
    public String getXml() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public Map getData() {
        ArrayList<Map> figures = new ArrayList<Map>();
        ArrayList<Map> connectors = new ArrayList<Map>();
        for (Figure f : this.getFigures()) {
            if (f instanceof Connector) {
                connectors.add(f.toMap());
                continue;
            }
            figures.add(f.toMap());
        }
        HashMap<String, ArrayList<Map>> data = new HashMap<String, ArrayList<Map>>();
        data.put("figures", figures);
        data.put("connectors", connectors);
        return data;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle r = null;
        for (Figure f : this.getFigures()) {
            if (r == null) {
                r = new Rectangle(f.getBounds());
                continue;
            }
            r.add(f.getDisplayBox());
        }
        return r;
    }

    @Override
    public List<Figure> deleteSelections() {
        ArrayList<Figure> deletedItems = new ArrayList<Figure>(this.getSelections());
        for (Figure f : this.getSelections()) {
            if (f.isSystem()) continue;
            for (Connector c : f.getConnectors()) {
                if (deletedItems.contains(c)) continue;
                deletedItems.add((Figure)((Object)c));
            }
            this.removeFigure(f);
        }
        this.clearSelections();
        return deletedItems;
    }

    protected final void clearConnectors() {
        this.connectors.clear();
    }
}

