/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw;

import com.rameses.rcp.common.DrawModel;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.draw.FigureEvent;
import com.rameses.rcp.draw.FigureListener;
import com.rameses.rcp.draw.commands.MoveDirection;
import com.rameses.rcp.draw.figures.FigureCache;
import com.rameses.rcp.draw.figures.LineConnector;
import com.rameses.rcp.draw.interfaces.Canvas;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Drawing;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.EditorListener;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.support.AttributeKey;
import com.rameses.rcp.draw.tools.SelectionTool;
import com.rameses.rcp.draw.undo.UndoRedoManager;
import com.rameses.rcp.draw.undo.UndoableAttribute;
import com.rameses.rcp.draw.undo.UndoableDelete;
import com.rameses.rcp.draw.undo.UndoableMove;
import com.rameses.rcp.draw.undo.UndoableProperty;
import com.rameses.rcp.draw.utils.DrawUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class DrawingEditor
implements Editor,
FigureListener {
    private Drawing drawing;
    private Canvas canvas;
    private Tool currentTool;
    private boolean readonly = false;
    private List<EditorListener> listeners = new ArrayList<EditorListener>();
    private UndoRedoManager undoRedoManager;

    public DrawingEditor() {
        this(null);
    }

    public DrawingEditor(Drawing drawing) {
        this.drawing = drawing;
        this.undoRedoManager = new UndoRedoManager(this);
    }

    @Override
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
        this.setCurrentTool(this.getCurrentTool());
    }

    @Override
    public void addToDrawing(Figure figure) {
        this.updateShowIndex(figure);
        figure.addFigureListener(this);
        this.getDrawing().addFigure(figure);
        for (Connector c : figure.getConnectors()) {
            ((Figure)((Object)c)).addFigureListener(this);
            this.getDrawing().addConnector(c);
        }
    }

    @Override
    public void addToSelections(Figure figure) {
        figure.addFigureListener(this);
        this.getDrawing().addSelection(figure);
    }

    @Override
    public void addToConnector(Connector connector) {
        connector.addFigureListener(this);
        this.getDrawing().addConnector(connector);
    }

    @Override
    public Image getImage() {
        return this.getImage(true);
    }

    @Override
    public Image getImage(boolean crop) {
        return this.getImage(crop, "PNG");
    }

    @Override
    public Image getImage(boolean crop, String imageType) {
        if (this.getDrawing().getFigures().isEmpty()) {
            return null;
        }
        BufferedImage bi = null;
        try {
            bi = this.getDrawingImage(crop);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageOutputStream image = ImageIO.createImageOutputStream(baos);
            ImageIO.write((RenderedImage)bi, imageType, image);
            return ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return bi;
        }
    }

    @Override
    public Tool getCurrentTool() {
        if (this.currentTool != null) {
            return this.currentTool;
        }
        return this.getDefaultTool();
    }

    @Override
    public void setCurrentTool(Tool currentTool) {
        this.currentTool = currentTool;
        this.getDrawing().clearSelections();
        this.getCanvas().refresh();
        currentTool.setToolCursor();
    }

    @Override
    public void setDefaultTool() {
        this.setCurrentTool(this.getDefaultTool());
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        if (this.canvas != null) {
            this.canvas.setReadonly(readonly);
            this.setCurrentTool(this.getDefaultTool());
        }
    }

    @Override
    public Tool getDefaultTool() {
        return new SelectionTool(this);
    }

    @Override
    public void reset() {
        this.getDrawing().clearSelections();
        this.getCanvas().refresh();
    }

    @Override
    public void deleteSelections() {
        if (this.getDrawing().getSelections().isEmpty()) {
            return;
        }
        boolean delete = this.fireBeforeRemoveFigures(this.getDrawing().getSelections());
        if (delete) {
            List<Figure> deletedItems = this.getDrawing().deleteSelections();
            this.fireAfterRemoveFigures(deletedItems);
            this.getCanvas().refresh();
            this.undoRedoManager.addEdit(new UndoableDelete(this, deletedItems));
        }
    }

    @Override
    public void moveSelections(MoveDirection direction) {
        if (this.getDrawing().getSelections().isEmpty()) {
            return;
        }
        CompoundEdit ce = new CompoundEdit();
        for (Figure f : this.getDrawing().getSelections()) {
            if (f instanceof Connector) continue;
            ce.addEdit(this.createMoveEdit(f, direction.getOffsetX(), direction.getOffsetY()));
            f.moveBy(direction.getOffsetX(), direction.getOffsetY(), null);
        }
        ce.end();
        this.undoRedoManager.addEdit(ce);
        this.getCanvas().refresh();
    }

    @Override
    public void openFigure(Figure figure) {
        for (EditorListener listener : this.listeners) {
            listener.openFigure(figure);
        }
    }

    public List showMenu(Figure figure) {
        ArrayList menus = new ArrayList();
        for (EditorListener listener : this.listeners) {
            List items = listener.showMenu(figure);
            for (Object o : items) {
                if (!(o instanceof Opener)) continue;
                menus.add(o);
            }
        }
        return menus;
    }

    @Override
    public void figureAdded(Figure figure) {
        this.fireFigureAdded(figure);
    }

    protected void fireFigureAdded(Figure figure) {
        for (EditorListener listener : this.listeners) {
            listener.figureAdded(figure);
        }
    }

    protected boolean fireBeforeRemoveFigures(List<Figure> figures) {
        Iterator<EditorListener> iterator = this.listeners.iterator();
        if (iterator.hasNext()) {
            EditorListener listener = iterator.next();
            return listener.beforeRemoveFigures(figures);
        }
        return true;
    }

    protected void fireAfterRemoveFigures(List<Figure> deletedItems) {
        for (EditorListener listener : this.listeners) {
            listener.afterRemoveFigures(deletedItems);
        }
    }

    @Override
    public void connectionChanged(Connector c, Figure fromFigure, Figure toFigure) {
        for (EditorListener listener : this.listeners) {
            listener.connectionChanged(c, fromFigure, toFigure);
        }
    }

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    @Override
    public void addUndoableEdit(UndoableEdit ce) {
        this.undoRedoManager.addEdit(ce);
    }

    @Override
    public UndoRedoManager.UndoAction getUndoAction() {
        return this.undoRedoManager.getUndoAction();
    }

    @Override
    public UndoRedoManager.RedoAction getRedoAction() {
        return this.undoRedoManager.getRedoAction();
    }

    @Override
    public void addListener(EditorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(EditorListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void attributeChanged(AttributeKey key, Object value) {
        if (this.getDrawing().getSelections().isEmpty()) {
            return;
        }
        CompoundEdit ce = new CompoundEdit();
        for (Figure f : this.getDrawing().getSelections()) {
            ce.addEdit(this.createAttributeEdit(f, key, value));
            f.set(key, value);
        }
        ce.end();
        this.undoRedoManager.addEdit(ce);
        this.getCanvas().refresh();
    }

    @Override
    public void loadDrawing(DrawModel handler) {
        this.loadDrawing(handler, handler.fetchData(null));
    }

    @Override
    public void loadDrawing(DrawModel handler, Object drawing) {
        Map data = new HashMap();
        if (drawing instanceof Map) {
            data = (Map)drawing;
        } else if (drawing instanceof String) {
            data = new HashMap();
        }
        this.loadFigures(handler, data);
        this.loadConnectors(handler, data);
        this.undoRedoManager.discardAllEdits();
    }

    private void loadFigures(DrawModel handler, Map data) {
        List figures = (List)data.get("figures");
        if (figures != null) {
            for (Map fprop : figures) {
                Figure figure = this.loadFigure(handler, fprop);
                if (figure == null) continue;
                this.addToDrawing(figure);
            }
        }
    }

    private void loadConnectors(DrawModel handler, Map data) {
        List list = (List)data.get("connectors");
        if (list != null && !list.isEmpty()) {
            for (Map cprop : list) {
                Figure startFigure = this.getDrawing().figureById(cprop.get("startFigureId").toString());
                Figure endFigure = this.getDrawing().figureById(cprop.get("endFigureId").toString());
                if (startFigure == null || endFigure == null) continue;
                this.loadConnector(handler, startFigure, endFigure, cprop);
            }
        }
    }

    private Connector loadConnector(DrawModel handler, Figure startFigure, Figure endFigure, Map cprop) {
        LineConnector connector = (LineConnector)this.loadFigure(handler, cprop);
        if (connector != null) {
            boolean update = connector.getPoints().isEmpty();
            connector.setStartFigure(startFigure, update);
            connector.setEndFigure(endFigure, update);
            this.addToConnector(connector);
        }
        return connector;
    }

    private final Figure loadFigure(DrawModel handler, Map fprop) {
        Map ui = (Map)fprop.get("ui");
        Figure figure = null;
        try {
            Figure prototype = FigureCache.getInstance().getFigure(ui.get("type") + "");
            if (prototype != null) {
                figure = (Figure)prototype.getClass().newInstance();
                if (handler != null) {
                    figure.showHandles(handler.showHandles());
                }
                figure.readAttributes(fprop);
            } else {
                System.out.println("No Figure is associated with the type " + ui.get("type") + ".");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Unable to create Figure for type " + ui.get("type") + ".");
            System.out.println("[ERROR] : " + ex.getMessage());
        }
        return figure;
    }

    private BufferedImage getDrawingImage(boolean crop) {
        Rectangle r = new Rectangle();
        if (this.getCanvas() != null) {
            r = this.getCanvas().getBounds();
        }
        if (r.isEmpty()) {
            r = this.getDrawing().getBounds();
        }
        r.grow(10, 10);
        BufferedImage bi = new BufferedImage(r.x + r.width, r.y + r.height, 2);
        Graphics2D g = bi.createGraphics();
        DrawUtil.setHDRenderingHints(g);
        try {
            for (Figure f : this.getDrawing().getFigures()) {
                f.draw(g);
            }
        }
        catch (Exception ex) {
            bi = null;
            ex.printStackTrace();
        }
        if (bi != null && crop) {
            bi = DrawUtil.cropImage(bi);
        }
        return bi;
    }

    @Override
    public void propertyChanged(FigureEvent e) {
        this.logUndoPropertyChanged(e);
        this.getCanvas().refresh();
    }

    @Override
    public void attributeChanged(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent e) {
    }

    private UndoableEdit createAttributeEdit(Figure figure, AttributeKey key, Object newValue) {
        return new UndoableAttribute(figure, key, figure.get(key), newValue);
    }

    private UndoableEdit createMoveEdit(Figure f, int offsetX, int offsetY) {
        return new UndoableMove(this, f, offsetX, offsetY);
    }

    private void logUndoPropertyChanged(FigureEvent e) {
        UndoableProperty edit = new UndoableProperty(e.getFigure(), e.getPropertyName(), e.getType(), e.getOldValue(), e.getNewValue());
        this.addUndoableEdit(edit);
    }

    private void updateShowIndex(Figure figure) {
        Figure f;
        if (this.getDrawing().getFigures().size() > 1 && (f = this.getDrawing().getFigures().get(0)).isShowIndex()) {
            figure.toggleShowIndex();
        }
    }
}

