/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.util.FontPropertiesManager;
import org.icepdf.ri.util.PropertiesManager;

public final class PDFViewer {
    private URL url;
    private Map props;
    private boolean modal;

    public static final void show(Map param) {
        PDFViewer viewer = new PDFViewer();
        viewer.showImpl(param);
    }

    public static final void show(URL url, Map props) {
        PDFViewer viewer = new PDFViewer();
        viewer.showImpl(url, props, true);
    }

    public static final void show(URL url, Map props, boolean modal) {
        PDFViewer viewer = new PDFViewer();
        viewer.showImpl(url, props, modal);
    }

    private PDFViewer() {
    }

    public PDFViewer(URL url) {
        this(url, null);
    }

    public PDFViewer(URL url, Map props) {
        this(url, props, true);
    }

    public PDFViewer(URL url, Map props, boolean modal) {
        this.url = url;
        this.props = props;
        this.modal = modal;
    }

    public void show() {
        this.showImpl(this.url, this.props, this.modal);
    }

    private void showImpl(URL url, Map props, boolean modal) {
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        if (props instanceof Map) {
            param.putAll(props);
        }
        param.put("url", url);
        param.put("modal", Boolean.valueOf(modal));
        this.showImpl(param);
    }

    private void showImpl(Map param) {
        Number height;
        Number width;
        Object val = this.getObject(param, "url");
        if (val == null) {
            throw new IllegalStateException("url is required in PDFViewer");
        }
        if (!(val instanceof URL)) {
            throw new IllegalStateException("URL object is required in PDFViewer");
        }
        URL url = (URL)val;
        String title = this.getString(param, "title");
        if (title == null) {
            title = "";
        }
        if ((width = this.getNumber(param, "width")) == null) {
            width = 1024;
        }
        if ((height = this.getNumber(param, "height")) == null) {
            height = 700;
        }
        String stropt = this.getString(param, "alwaysOnTop") + "";
        boolean _alwaysOnTop = stropt.toLowerCase().matches("true|1");
        stropt = this.getString(param, "modal") + "";
        boolean _modal = !stropt.toLowerCase().matches("false|0");
        try {
            String strdir = System.getProperty("user.dir", System.getProperty("user.home"));
            File dir = new File(strdir, ".icesoft/icepdf_viewer");
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            System.getProperties().put("swingri.home", dir.getAbsolutePath());
        }
        catch (Throwable strdir) {
            // empty catch block
        }
        SwingController controller = new SwingController();
        controller.setIsEmbeddedComponent(true);
        ResourceBundle bundle_1 = ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        PropertiesManager pm = new PropertiesManager(System.getProperties(), bundle_1);
        ResourceBundle bundle_2 = ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        FontPropertiesManager fpm = new FontPropertiesManager(pm, System.getProperties(), bundle_2);
        pm.set("application.zoom.factor.default", "1.25");
        SwingViewBuilder factory = new SwingViewBuilder(controller, pm);
        MyAnnotationCallback ac = new MyAnnotationCallback(controller.getDocumentViewController());
        controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)ac);
        JPanel viewPanel = factory.buildViewerPanel();
        JToolBar toolbar = this.findToolBar(viewPanel);
        this.applyToolbarSettings(toolbar);
        this.scan(toolbar, 0, 3);
        System.out.println("");
        Window parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        JDialog win = new JDialog(parent == null ? null : parent);
        win.setDefaultCloseOperation(2);
        win.getContentPane().add(viewPanel);
        win.setTitle(title);
        if (_alwaysOnTop) {
            win.setAlwaysOnTop(_alwaysOnTop);
        } else if (_modal) {
            win.setModal(_modal);
        }
        controller.openDocument(url);
        win.addWindowListener((WindowListener)controller);
        win.setSize(width.intValue(), height.intValue());
        win.setVisible(true);
    }

    private Object getObject(Map map, String name) {
        return map == null ? null : map.get(name);
    }

    private String getString(Map map, String name) {
        Object value = map == null ? null : (Object)map.get(name);
        return value == null ? null : value.toString();
    }

    private Number getNumber(Map map, String name) {
        Object value;
        Object v0 = value = map == null ? null : map.get(name);
        if (value instanceof Number) {
            return value;
        }
        return null;
    }

    private JToolBar findToolBar(JPanel panel) {
        if (panel == null) {
            return null;
        }
        Component[] comps = panel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JToolBar)) continue;
            return (JToolBar)comps[i];
        }
        return null;
    }

    private void scan(Component comp, int level, int maxlevel) {
        if (level >= maxlevel) {
            return;
        }
        if (comp == null) {
            return;
        }
        String strpad = this.buildPads(level);
        System.out.println("");
        System.out.print(strpad);
        System.out.print(comp.toString());
        if (comp instanceof Container) {
            Container con = (Container)comp;
            Component[] comps = con.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.scan(comps[i], level + 1, maxlevel);
            }
        }
    }

    private String buildPads(int level) {
        StringBuilder sb1 = new StringBuilder();
        if (level < 0) {
            return sb1.toString();
        }
        StringBuilder sb2 = new StringBuilder();
        if (level == 0) {
            sb2.append("*");
        } else {
            sb2.append("*");
            for (int i = 0; i < level; ++i) {
                sb1.append("   ");
                sb2.append("*");
            }
        }
        sb1.append((CharSequence)sb2);
        return sb1.toString();
    }

    private void applyToolbarSettings(JToolBar toolbar) {
        boolean passed = false;
        Component[] comps = toolbar.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            passed = false;
            if (comps[i] instanceof JToolBar) {
                passed = true;
            } else if (comps[i] instanceof AbstractButton) {
                passed = true;
            }
            if (!passed) continue;
            if (comps[i] instanceof AbstractButton) {
                AbstractButton btn = (AbstractButton)comps[i];
                btn.setRolloverIcon(null);
                btn.setDisabledIcon(null);
                continue;
            }
            if (!(comps[i] instanceof JToolBar)) continue;
            this.applyToolbarSettings((JToolBar)comps[i]);
        }
    }
}

