/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.osiris2.client.OsirisSessionContext;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ControllerProvider;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.util.ValueUtil;
import java.util.List;
import java.util.Stack;

public class UILoaderStack
extends Stack {
    private List loaders;
    private Object peek;
    private boolean reloaded = false;

    public void setLoaders(List loaders) {
        this.loaders = loaders;
        this.reloaded = false;
    }

    @Override
    public boolean empty() {
        if (this.loaders != null && this.loaders.size() > 0) {
            return false;
        }
        return super.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.empty();
    }

    @Override
    public int size() {
        return this.loaders.size();
    }

    public Object push(Object item) {
        return item;
    }

    public Object pop() {
        Object item = this.peek();
        if (item != null && this.loaders.size() > 1) {
            this.loaders.remove(0);
            this.peek = null;
        }
        return item;
    }

    public Object peek() {
        if (!this.loaders.isEmpty()) {
            while (this.loaders.size() > 0 && this.peek == null) {
                OsirisSessionContext sessCtx = (OsirisSessionContext)OsirisContext.getSession();
                if (this.loaders.size() <= 1 && !this.reloaded) {
                    sessCtx.reload();
                    this.reloaded = true;
                }
                Invoker i = (Invoker)this.loaders.get(0);
                String action = i.getAction();
                String target = (String)i.getProperties().get("target");
                ClientContext ctx = ClientContext.getCurrentContext();
                if (!sessCtx.checkPermission(i.getDomain(), i.getRole(), i.getPermission())) {
                    this.loaders.remove(0);
                    continue;
                }
                ControllerProvider cp = ctx.getControllerProvider();
                UIController c = cp.getController(i.getWorkunitid(), null);
                if (i != null) {
                    Object callee = c.getCodeBean();
                    ControlSupport.injectInvoker((Object)callee, callee.getClass(), (Object)i);
                }
                if (target != null && target.matches(".*process")) {
                    try {
                        this.loaders.remove(0);
                        c.init(null, action);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("ERROR IN LOADER " + i.getWorkunitid() + ": " + e.getMessage(), e);
                    }
                }
                UIControllerContext uic = new UIControllerContext(c);
                Object outcome = c.init(null, action);
                if (!ValueUtil.isEmpty((Object)outcome) && outcome instanceof String) {
                    if ("_close".equals(outcome)) {
                        this.loaders.remove(0);
                        continue;
                    }
                    uic.setCurrentView(outcome + "");
                }
                this.peek = uic;
            }
        }
        return this.peek;
    }
}

