/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ControllerProvider;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class StatusbarUtil {
    public static JComponent getStatusbar() {
        SessionContext app = OsirisContext.getSession();
        Object obj = OsirisContext.getEnv().get("statusbar.type");
        if (obj == null) {
            obj = "statusbar";
        }
        List invokers = app.getInvokers(obj.toString());
        StatusPanel panel = new StatusPanel();
        for (Invoker inv : invokers) {
            JComponent viewcomp = (JComponent)StatusbarUtil.getViewComponent(inv);
            int preferredWidth = 0;
            try {
                preferredWidth = Integer.parseInt(inv.getProperties().get("width").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            viewcomp.putClientProperty(StatusConstraint.class, new StatusConstraint(preferredWidth));
            panel.add(viewcomp);
        }
        return panel;
    }

    public static Component getViewComponent(Invoker inv) {
        String out;
        ControllerProvider cp = ClientContext.getCurrentContext().getControllerProvider();
        UIController c = cp.getController(inv.getWorkunitid(), null);
        UIControllerContext uic = new UIControllerContext(c);
        String action = inv.getAction();
        if (action != null && !ValueUtil.isEmpty((Object)(out = (String)c.init(new HashMap(), action)))) {
            uic.setCurrentView(out);
        }
        return new UIControllerPanel(uic);
    }

    private static class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = this.getLayoutSize(parent);
            return new Dimension(100, dim.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                ArrayList<Object[]> list = new ArrayList<Object[]>();
                Component[] comps = parent.getComponents();
                for (int i = comps.length - 1; i >= 0; --i) {
                    int cw;
                    if (!(comps[i] instanceof JComponent)) continue;
                    JComponent jc = (JComponent)comps[i];
                    Dimension dim = jc.getPreferredSize();
                    StatusConstraint cons = (StatusConstraint)jc.getClientProperty(StatusConstraint.class);
                    if (cons == null) continue;
                    int dw = dim.width;
                    if (cons.width > 0) {
                        dw = cons.width;
                    }
                    if ((cw = w - dw) < 0) {
                        cw = 0;
                        dw = w;
                    }
                    if (i - 1 < 0) {
                        cw = 0;
                        dw = w;
                    }
                    list.add(new Object[]{jc, new Rectangle(cw, y, dw, h)});
                    w = cw;
                }
                for (Object[] arr : list) {
                    JComponent jc = (JComponent)arr[0];
                    Rectangle rect = (Rectangle)arr[1];
                    jc.setBounds(rect);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!(comps[i] instanceof JComponent)) continue;
                    JComponent jc = (JComponent)comps[i];
                    Dimension dim = jc.getPreferredSize();
                    StatusConstraint cons = (StatusConstraint)jc.getClientProperty(StatusConstraint.class);
                    if (cons == null) continue;
                    w = cons.width > 0 ? (w += cons.width) : (w += dim.width);
                    h = Math.max(h, dim.height);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }
    }

    private static class StatusConstraint {
        private int width;

        StatusConstraint(int width) {
            this.width = width;
        }
    }

    private static class StatusPanel
    extends JPanel {
        public StatusPanel() {
            this.setLayout(new Layout());
        }
    }
}

