/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.AppContext;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.client.LoaderUtil;
import com.rameses.osiris2.client.MenuUtil;
import com.rameses.osiris2.client.OsirisSecurityProvider;
import com.rameses.osiris2.client.StatusbarUtil;
import com.rameses.osiris2.client.ToolbarUtil;
import com.rameses.platform.interfaces.MainWindow;
import com.rameses.rcp.framework.ClientContext;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuBar;

public class OsirisSessionContext
extends SessionContext {
    private boolean offline = false;
    private Map profile = new HashMap();

    public OsirisSessionContext(AppContext ctx) {
        super(ctx);
        this.setSecurityProvider(new OsirisSecurityProvider());
    }

    public void load() {
        this.reload();
    }

    public void reload() {
        this.invokers.clear();
        this.folderIndex.clear();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow m = ClientContext.getCurrentContext().getPlatform().getMainWindow();
                JMenuBar menuBar = MenuUtil.getMenuBar("menu");
                m.setComponent((JComponent)menuBar, "menubar");
                m.setTitle((String)OsirisSessionContext.super.getEnv().get("app.title"));
                m.setComponent((JComponent)ToolbarUtil.getToolBar(), "toolbar");
                m.setComponent(StatusbarUtil.getStatusbar(), "statusbar");
                LoaderUtil.runLoaderAfter();
            }
        });
    }

    public Map getProfile() {
        return this.profile;
    }

    public void setProfile(Map profile) {
        this.profile = profile;
    }

    public boolean checkInvoker(Invoker inv) {
        if (this.offline) {
            String a = (String)inv.getProperties().get("allowOffline");
            if (a == null) {
                return false;
            }
            try {
                return Boolean.parseBoolean(a);
            }
            catch (Exception ign) {
                return false;
            }
        }
        return true;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }
}

