/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.AppContext;
import com.rameses.osiris2.CodeProvider;
import com.rameses.osiris2.SecurityProvider;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.client.GroovyControllerProvider;
import com.rameses.osiris2.client.OsirisSessionContext;
import java.util.Iterator;
import java.util.Map;

public class OsirisAppContext
extends AppContext {
    private ClassLoader classLoader;
    private CodeProvider codeProvider;

    public OsirisAppContext(ClassLoader loader) {
        this.classLoader = loader;
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.codeProvider = new GroovyControllerProvider(this.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CodeProvider getCodeProvider() {
        return this.codeProvider;
    }

    public void setEnvMap(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            this.env.put(me.getKey(), me.getValue());
        }
    }

    public SessionContext createSession() {
        OsirisSessionContext ctx = new OsirisSessionContext(this);
        SecurityProvider p = (SecurityProvider)this.env.get(SecurityProvider.class);
        if (p != null) {
            ctx.setSecurityProvider(p);
        }
        return ctx;
    }
}

