/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.common.MethodResolver;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.osiris2.client.WorkUnitUIController;
import com.rameses.rcp.annotations.Controller;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.StyleRule;
import com.rameses.util.ExceptionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class MasterListFormController {
    @Controller
    private WorkUnitUIController controller;
    public static String MODE_CREATE = "create";
    public static String MODE_READ = "read";
    public static String MODE_EDIT = "edit";
    private Object entity = new HashMap();
    private EntityUtil entityUtil;
    private String mode = MODE_READ;

    public abstract Object getEntityService();

    private EntityUtil getEntityUtil() {
        if (this.entityUtil == null) {
            this.entityUtil = new EntityUtil(this.getEntityService());
        }
        return this.entityUtil;
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object o) {
        this.entity = o;
    }

    public abstract String getEntityName();

    public abstract String getRole();

    public String getDomain() {
        return this.controller.getWorkunit().getModule().getDomain();
    }

    public String getPageTitle() {
        return this.controller.getWorkunit().getWorkunit().getTitle();
    }

    public void doCreateObject() {
        this.entity = new HashMap();
    }

    public void doEditObject() {
    }

    public List<StyleRule> getStyleRules() {
        ArrayList<StyleRule> styles = new ArrayList<StyleRule>();
        styles.add(new StyleRule("entity.*", "mode=='create'").add("enabled", (Object)true));
        styles.add(new StyleRule("entity.*", "mode=='edit'").add("enabled", (Object)true));
        styles.add(new StyleRule("entity.*", "mode=='read'").add("enabled", (Object)false));
        return styles;
    }

    public Opener getForm() {
        Opener o = new Opener();
        o.setOutcome(MODE_READ);
        return o;
    }

    private void addAction(String name, String caption, List<Action> actions) {
        if (!OsirisContext.getSession().getSecurityProvider().checkPermission(this.getDomain(), this.getRole(), name + this.getEntityName())) {
            return;
        }
        Action a = new Action(name, caption, null);
        actions.add(a);
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.mode.equals(MODE_CREATE)) {
            this.addAction("save", "Save", actions);
            this.addAction("cancel", "Cancel", actions);
        } else if (this.mode.equals(MODE_READ)) {
            this.addAction("create", "New", actions);
            this.addAction("edit", "Edit", actions);
        } else if (this.mode.equals(MODE_EDIT)) {
            this.addAction("save", "Save", actions);
            this.addAction("cancel", "Cancel", actions);
        }
        return actions;
    }

    public Object save() throws Exception {
        Object retval = null;
        if (MsgBox.confirm((Object)"You are about to save this record. Continue?")) {
            if (this.mode.equals(MODE_CREATE)) {
                retval = this.doSaveCreate();
            } else if (this.mode.equals(MODE_EDIT)) {
                retval = this.doSaveUpdate();
            }
            this.mode = MODE_READ;
            if (retval == null) {
                return this.mode;
            }
        }
        return retval;
    }

    public Object doSaveCreate() throws Exception {
        this.entity = this.getEntityUtil().saveCreate(this.getEntity());
        return null;
    }

    public Object doSaveUpdate() throws Exception {
        this.entity = this.getEntityUtil().saveUpdate(this.getEntity());
        return null;
    }

    public String create() {
        this.mode = MODE_CREATE;
        this.doCreateObject();
        return this.mode;
    }

    public String edit() {
        this.mode = MODE_EDIT;
        this.doEditObject();
        return this.mode;
    }

    public String cancel() {
        this.mode = MODE_READ;
        return this.mode;
    }

    public String getMode() {
        return this.mode;
    }

    private class EntityUtil
    implements EntityIntf {
        private Object service;

        public EntityUtil(Object s) {
            this.service = s;
        }

        private Object execute(String name, Object args) throws Exception {
            try {
                MethodResolver mr = MethodResolver.getInstance();
                return mr.invoke(this.service, name, new Object[]{args});
            }
            catch (Exception e) {
                throw ExceptionManager.getOriginal((Exception)e);
            }
        }

        @Override
        public List getList(Object qry) throws Exception {
            return (List)this.execute("getList", qry);
        }

        @Override
        public Object saveCreate(Object data) throws Exception {
            return this.execute("saveCreate", data);
        }

        @Override
        public Object saveUpdate(Object data) throws Exception {
            return this.execute("saveUpdate", data);
        }

        @Override
        public Object remove(Object data) throws Exception {
            return this.execute("remove", data);
        }

        @Override
        public Object open(Object data) throws Exception {
            return this.execute("open", data);
        }
    }

    public static interface EntityIntf {
        public List getList(Object var1) throws Exception;

        public Object saveCreate(Object var1) throws Exception;

        public Object saveUpdate(Object var1) throws Exception;

        public Object remove(Object var1) throws Exception;

        public Object open(Object var1) throws Exception;
    }
}

