/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.framework.OpenerProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InvokerOpenerProvider
implements OpenerProvider {
    public List<Opener> getOpeners(String type, Object context) {
        List invList = InvokerUtil.lookup(type, context);
        ArrayList<Opener> openers = new ArrayList<Opener>();
        for (Invoker inv : invList) {
            Opener o = new Opener();
            o.setName(inv.getWorkunitid());
            o.setCaption(inv.getCaption());
            o.setAction(inv.getAction());
            Map props = inv.getProperties();
            if (props.get("target") != null) {
                o.setTarget(props.get("target") + "");
            }
            if (props.get("outcome") != null) {
                o.setOutcome(props.get("outcome") + "");
            }
            o.getProperties().putAll(props);
            openers.add(o);
        }
        return openers;
    }

    public Opener lookupOpener(String invokerType, Map params) {
        try {
            return InvokerUtil.lookupOpener(invokerType, params);
        }
        catch (Throwable t) {
            System.out.println("[WARN] failed to lookup opener '" + invokerType + "' caused by " + t.getMessage());
            return null;
        }
    }

    public List<Opener> lookupOpeners(String invokerType, Map params) {
        try {
            return InvokerUtil.lookupOpeners(invokerType, params);
        }
        catch (Throwable t) {
            System.out.println("[WARN] failed to lookup openers '" + invokerType + "' caused by " + t.getMessage());
            return new ArrayList<Opener>();
        }
    }
}

