/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.rcp.common.Opener;
import java.util.Map;

public class InvokerOpener
extends Opener {
    private Invoker invoker;

    public InvokerOpener(Invoker invoker, Map params, String caption) {
        this.invoker = invoker;
        this.init(params, caption);
    }

    private void init(Map params, String caption) {
        Map invProps;
        this.setName(this.invoker.getWorkunitid());
        this.setId(this.createInvokerId());
        if (caption == null) {
            caption = this.invoker.getCaption();
        }
        if (caption == null) {
            caption = this.invoker.getWorkunitid();
        }
        this.setCaption(caption);
        this.setAction(this.invoker.getAction());
        String target = this.getPropertyString("target");
        if (target != null) {
            target = target.replaceAll("^([^_])", "_$1");
        }
        this.setTarget(target);
        if (params != null) {
            this.setParams(params);
        }
        if (!(invProps = this.invoker.getProperties()).isEmpty()) {
            this.getProperties().putAll(invProps);
        }
        this.getProperties().put("_INVOKER_", this.invoker);
        this.setLoader(new OpenerLoaderImpl());
        this.setProvider(new ProviderImpl());
    }

    private String createInvokerId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.invoker.getWorkunitid());
        String caption = this.invoker.getCaption();
        String id = this.getPropertyString("id");
        if (id != null && id.trim().length() > 0) {
            sb.append("_" + id);
        } else if (caption != null && caption.trim().length() > 0) {
            sb.append("_" + caption);
        }
        return sb.toString();
    }

    private String getPropertyString(String name) {
        Object ov = this.invoker == null ? null : (Object)this.invoker.getProperties().get(name);
        return ov == null ? null : ov.toString();
    }

    private class ProviderImpl
    implements Opener.Provider {
        InvokerOpener root;

        private ProviderImpl() {
            this.root = InvokerOpener.this;
        }

        public Opener createInstance(Map params, String caption) {
            return new InvokerOpener(this.root.invoker, params, caption);
        }
    }

    private class OpenerLoaderImpl
    implements Opener.OpenerLoader {
        private OpenerLoaderImpl() {
        }

        public void load(Opener o) {
            InvokerUtil.invokeOpener(o);
        }
    }
}

