/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.client.OsirisContext;
import com.rameses.util.TemplateProvider;
import com.rameses.util.TemplateSource;
import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Map;

public class GroovyTemplateProvider
extends TemplateProvider {
    private Map<String, Template> cache = new Hashtable<String, Template>();

    public String[] getExtensions() {
        return new String[]{"gtpl", "htm", "html"};
    }

    public Template getTemplate(String name, TemplateSource provider) {
        try {
            if (!this.cache.containsKey(name)) {
                InputStream is = null;
                try {
                    ClassLoader loader = OsirisContext.getClientContext().getClassLoader();
                    is = provider == null ? loader.getResourceAsStream(name) : provider.getSource(name);
                    SimpleTemplateEngine st = new SimpleTemplateEngine(loader);
                    InputStreamReader rd = new InputStreamReader(is);
                    Template t = st.createTemplate((Reader)rd);
                    this.cache.put(name, t);
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (!this.cache.containsKey(name)) {
                throw new Exception("Name " + name + " not found");
            }
            return this.cache.get(name);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object getResult(String templateName, Object data) {
        return this.getResult(templateName, data, null);
    }

    public Object getResult(String templateName, Object data, TemplateSource source) {
        Map m = null;
        if (data instanceof Map) {
            m = (Map)data;
        }
        Template template = this.getTemplate(templateName, source);
        Writable w = template.make(m);
        return w.toString();
    }

    public void transform(String templateName, Object data, OutputStream out) {
        this.transform(templateName, data, out, null);
    }

    public void transform(String templateName, Object data, OutputStream out, TemplateSource source) {
        ObjectOutputStream oos = null;
        try {
            Object result = this.getResult(templateName, data, source);
            oos = new ObjectOutputStream(out);
            oos.writeObject(result);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    public void clear(String name) {
        if (name != null) {
            this.cache.remove(name);
        } else {
            this.cache.clear();
        }
    }
}

