/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.docking;

import it.businesslogic.ireport.gui.event.TabPaneChangedEvent;
import it.businesslogic.ireport.gui.event.TabPaneChangedListener;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ColorUIResource;

class ExtendedTabbedPane
extends JTabbedPane
implements ChangeListener,
Runnable {
    private final Image closeTabImage = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/docking/tabclose.png")).getImage();
    private final Image closeTabInactiveImage = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/docking/tabcloseinactive.png")).getImage();
    private final Image closeTabActiveImage = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/docking/tabcloseactive.png")).getImage();
    private final Image minimizeTabImage = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/docking/tabminimize.png")).getImage();
    private final Image minimizeTabInactiveImage = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/docking/tabminimizeinactive.png")).getImage();
    private final Image minimizeTabActiveImage = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/docking/tabminimizeactive.png")).getImage();
    private List disabledCloseButtons = new ArrayList();
    private int orientation = 1;
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private int pressedMinimizeButtonIndex = -1;
    private int mouseOverMinimizeButtonIndex = -1;
    private boolean draggedOut = false;
    private boolean draggedOutMinimize = false;
    boolean closingTab = false;
    boolean minimizingTab = false;
    private EventListenerList listenerList = null;

    ExtendedTabbedPane() {
        this.addChangeListener(this);
        CloseButtonListener.install();
        MinimizeButtonListener.install();
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
    }

    private Component sel() {
        Component c = this.getSelectedComponent();
        return c == null ? this : c;
    }

    public int tabForCoordinate(int x, int y) {
        return this.getUI().tabForCoordinate(this, x, y);
    }

    public boolean isClosable(int tabIndex) {
        return !this.disabledCloseButtons.contains(new Integer(tabIndex));
    }

    public void stateChanged(ChangeEvent e) {
        this.reset();
        this.resetMinimized();
    }

    public Component add(Component c) {
        Component result = super.add(c);
        String s = c.getName();
        if (s != null) {
            s = s + " ";
        }
        this.setTitleAt(this.getComponentCount() - 1, s);
        return result;
    }

    public Component addTab(String s, Component c, boolean closeable) {
        Component result = super.add(c);
        if (!closeable) {
            this.disabledCloseButtons.add(new Integer(this.getComponentCount() - 1));
        }
        this.setTitleAt(this.getComponentCount() - 1, s);
        return result;
    }

    public void setTitleAt(int idx, String title) {
        String s = title;
        if (s == null) {
            s = "";
        }
        if ((s = s.trim() + "   ") != null) {
            s = s + "  ";
        }
        if (this.isClosable(idx)) {
            s = s + "   ";
        }
        if (!s.equals(this.getTitleAt(idx))) {
            super.setTitleAt(idx, s);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private void resetMinimized() {
        this.setMouseOverMinimizeButtonIndex(-1);
        this.setPressedMinimizeButtonIndex(-1);
        this.draggedOutMinimize = false;
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null || this.disabledCloseButtons.contains(new Integer(i))) {
            return null;
        }
        b = new Rectangle(b);
        ExtendedTabbedPane.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        return new Rectangle(b.x + b.width - 14, b.y + b.height / 2 - 5, 8, 8);
    }

    private Rectangle getMinimizeButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        b = new Rectangle(b);
        ExtendedTabbedPane.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        return new Rectangle(b.x + b.width - (this.disabledCloseButtons.contains(new Integer(i)) ? 12 : 24), b.y + b.height / 2 - 5, 8, 8);
    }

    private static void checkUIColors() {
        if (UIManager.getColor("Button.shadow") == null) {
            UIManager.put("Button.shadow", new ColorUIResource(153, 153, 153));
        }
        if (UIManager.getColor("Button.darkShadow") == null) {
            UIManager.put("Button.darkShadow", new ColorUIResource(102, 102, 102));
        }
        if (UIManager.getColor("Button.highlight") == null) {
            UIManager.put("Button.highlight", new ColorUIResource(Color.white));
        }
        if (UIManager.getColor("Button.background") == null) {
            UIManager.put("Button.background", new ColorUIResource(204, 204, 204));
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        ExtendedTabbedPane.checkUIColors();
        int selectedIndex = this.getSelectedIndex();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.drawButton(g, this.getMinimizeButtonBoundsAt(i), this.pressedMinimizeButtonIndex, this.minimizeTabInactiveImage, this.minimizeTabImage, this.minimizeTabActiveImage, selectedIndex == i, this.mouseOverMinimizeButtonIndex, i, this.draggedOutMinimize, this.getOrientation() == 0);
            if (this.disabledCloseButtons.contains(new Integer(i))) continue;
            this.drawButton(g, this.getCloseButtonBoundsAt(i), this.pressedCloseButtonIndex, this.closeTabInactiveImage, this.closeTabImage, this.closeTabActiveImage, selectedIndex == i, this.mouseOverCloseButtonIndex, i, this.draggedOut, false);
        }
    }

    protected void drawButton(Graphics g, Rectangle r, int pressedButtonIndex, Image tabInactiveImage, Image tabImage, Image tabActiveImage, boolean selected, int mouseOverButtonIndex, int tabIndex, boolean isDraggedOut, boolean flipImage) {
        if (r == null) {
            return;
        }
        if (tabIndex == pressedButtonIndex && !isDraggedOut) {
            g.setColor(UIManager.getColor("Button.shadow"));
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        int dx1 = flipImage ? r.x + r.width : r.x;
        int dy1 = r.y;
        int dx2 = flipImage ? r.x : r.x + r.width;
        int dy2 = r.y + r.height;
        int sx1 = 0;
        int sy1 = 0;
        int sx2 = r.width;
        int sy2 = r.height;
        if (selected) {
            g.drawImage(tabImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
        } else {
            g.drawImage(tabInactiveImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
        }
        if (tabIndex == mouseOverButtonIndex || tabIndex == pressedButtonIndex && isDraggedOut) {
            g.drawImage(tabActiveImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
        } else if (tabIndex == pressedButtonIndex) {
            g.drawImage(tabImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
        }
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = (JComponent)this.getComponentAt(this.pressedCloseButtonIndex);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, c.getToolTipText());
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = (JComponent)this.getComponentAt(this.mouseOverCloseButtonIndex);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, c.getToolTipText());
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private void setPressedMinimizeButtonIndex(int index) {
        Rectangle r;
        if (this.pressedMinimizeButtonIndex == index) {
            return;
        }
        if (this.pressedMinimizeButtonIndex >= 0 && this.pressedMinimizeButtonIndex < this.getTabCount()) {
            r = this.getMinimizeButtonBoundsAt(this.pressedMinimizeButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = (JComponent)this.getComponentAt(this.pressedMinimizeButtonIndex);
            this.setToolTipTextAt(this.pressedMinimizeButtonIndex, c.getToolTipText());
        }
        this.pressedMinimizeButtonIndex = index;
        if (this.pressedMinimizeButtonIndex >= 0 && this.pressedMinimizeButtonIndex < this.getTabCount()) {
            r = this.getMinimizeButtonBoundsAt(this.pressedMinimizeButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setMouseOverMinimizeButtonIndex(-1);
            this.setToolTipTextAt(this.pressedMinimizeButtonIndex, null);
        }
    }

    private void setMouseOverMinimizeButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverMinimizeButtonIndex == index) {
            return;
        }
        if (this.mouseOverMinimizeButtonIndex >= 0 && this.mouseOverMinimizeButtonIndex < this.getTabCount()) {
            r = this.getMinimizeButtonBoundsAt(this.mouseOverMinimizeButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = (JComponent)this.getComponentAt(this.mouseOverMinimizeButtonIndex);
            this.setToolTipTextAt(this.mouseOverMinimizeButtonIndex, c.getToolTipText());
        }
        this.mouseOverMinimizeButtonIndex = index;
        if (this.mouseOverMinimizeButtonIndex >= 0 && this.mouseOverMinimizeButtonIndex < this.getTabCount()) {
            r = this.getMinimizeButtonBoundsAt(this.mouseOverMinimizeButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setPressedMinimizeButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverMinimizeButtonIndex, null);
        }
    }

    private void fireCloseRequest(Component c) {
        this.fireTabPaneChangedListenerTabPaneChanged(new TabPaneChangedEvent(1, c, this.indexOfComponent(c)));
    }

    private void fireMinimizeRequest(Component c) {
        this.fireTabPaneChangedListenerTabPaneChanged(new TabPaneChangedEvent(0, c, this.indexOfComponent(c)));
    }

    public static void fixGetBoundsAt(Rectangle b) {
        if (b.y < 0) {
            b.y = -b.y;
        }
        if (b.x < 0) {
            b.x = -b.x;
        }
    }

    public static int findTabForCoordinate(JTabbedPane tab, int x, int y) {
        for (int i = 0; i < tab.getTabCount(); ++i) {
            Rectangle b = tab.getBoundsAt(i);
            if (b == null) continue;
            b = new Rectangle(b);
            ExtendedTabbedPane.fixGetBoundsAt(b);
            if (!b.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public void doLayout() {
        if (this.closingTab || this.minimizingTab) {
            SwingUtilities.invokeLater(this);
        } else {
            super.doLayout();
        }
    }

    public void run() {
        this.doLayout();
        this.closingTab = false;
        this.minimizingTab = false;
        this.repaint();
    }

    protected void processMouseEvent(MouseEvent me) {
        try {
            super.processMouseEvent(me);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized void addTabPaneChangedListener(TabPaneChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(TabPaneChangedListener.class, listener);
    }

    public synchronized void removeTabPaneChangedListener(TabPaneChangedListener listener) {
        this.listenerList.remove(TabPaneChangedListener.class, listener);
    }

    private void fireTabPaneChangedListenerTabPaneChanged(TabPaneChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TabPaneChangedListener.class) continue;
            ((TabPaneChangedListener)listeners[i + 1]).tabPaneChanged(event);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    private static class MinimizeButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private MinimizeButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new MinimizeButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent ev) {
            Component c;
            MouseEvent e = (MouseEvent)ev;
            for (c = (Component)e.getSource(); c != null && !(c instanceof ExtendedTabbedPane); c = c.getParent()) {
            }
            if (c == null) {
                return;
            }
            ExtendedTabbedPane tab = (ExtendedTabbedPane)c;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
            if (e.getID() == 500) {
                return;
            }
            int index = ExtendedTabbedPane.findTabForCoordinate(tab, p.x, p.y);
            Rectangle r = null;
            if (index >= 0) {
                r = tab.getMinimizeButtonBoundsAt(index);
            }
            if (r == null) {
                r = new Rectangle(0, 0, 0, 0);
            }
            switch (e.getID()) {
                case 501: {
                    if (!r.contains(p)) break;
                    tab.setPressedMinimizeButtonIndex(index);
                    tab.draggedOutMinimize = false;
                    e.consume();
                    return;
                }
                case 502: {
                    if (r.contains(p) && tab.pressedMinimizeButtonIndex >= 0) {
                        tab.minimizingTab = true;
                        Component tc = tab.getComponentAt(tab.pressedMinimizeButtonIndex);
                        tab.resetMinimized();
                        tab.fireMinimizeRequest(tc);
                        e.consume();
                        return;
                    }
                    tab.resetMinimized();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (r.contains(p)) {
                        tab.setMouseOverMinimizeButtonIndex(index);
                        tab.draggedOutMinimize = false;
                        e.consume();
                        return;
                    }
                    if (tab.mouseOverMinimizeButtonIndex < 0) break;
                    tab.setMouseOverMinimizeButtonIndex(-1);
                    tab.draggedOutMinimize = false;
                    e.consume();
                    break;
                }
                case 506: {
                    if (tab.pressedMinimizeButtonIndex < 0) break;
                    if (tab.draggedOutMinimize != !r.contains(p)) {
                        tab.draggedOutMinimize = !r.contains(p);
                        tab.repaint(r.x, r.y, r.width + 2, r.height + 2);
                    }
                    e.consume();
                    return;
                }
            }
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent ev) {
            Component c;
            MouseEvent e = (MouseEvent)ev;
            for (c = (Component)e.getSource(); c != null && !(c instanceof ExtendedTabbedPane); c = c.getParent()) {
            }
            if (c == null) {
                return;
            }
            ExtendedTabbedPane tab = (ExtendedTabbedPane)c;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
            if (e.getID() == 500) {
                return;
            }
            int index = ExtendedTabbedPane.findTabForCoordinate(tab, p.x, p.y);
            Rectangle r = null;
            if (index >= 0) {
                r = tab.getCloseButtonBoundsAt(index);
            }
            if (r == null) {
                r = new Rectangle(0, 0, 0, 0);
            }
            switch (e.getID()) {
                case 501: {
                    if (!r.contains(p)) break;
                    tab.setPressedCloseButtonIndex(index);
                    tab.draggedOut = false;
                    e.consume();
                    return;
                }
                case 502: {
                    if (r.contains(p) && tab.pressedCloseButtonIndex >= 0) {
                        tab.closingTab = true;
                        Component tc = tab.getComponentAt(tab.pressedCloseButtonIndex);
                        tab.reset();
                        tab.fireCloseRequest(tc);
                        e.consume();
                        return;
                    }
                    tab.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (r.contains(p)) {
                        tab.setMouseOverCloseButtonIndex(index);
                        tab.draggedOut = false;
                        e.consume();
                        return;
                    }
                    if (tab.mouseOverCloseButtonIndex < 0) break;
                    tab.setMouseOverCloseButtonIndex(-1);
                    tab.draggedOut = false;
                    e.consume();
                    break;
                }
                case 506: {
                    if (tab.pressedCloseButtonIndex < 0) break;
                    if (tab.draggedOut != !r.contains(p)) {
                        tab.draggedOut = !r.contains(p);
                        tab.repaint(r.x, r.y, r.width + 2, r.height + 2);
                    }
                    e.consume();
                    return;
                }
            }
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return ExtendedTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return ExtendedTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container aContainer) {
            return ExtendedTabbedPane.this.sel();
        }

        public Component getLastComponent(Container aContainer) {
            return ExtendedTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container aContainer) {
            return ExtendedTabbedPane.this.sel();
        }
    }
}

