/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.report;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class PrinterService
implements Printable {
    public List<String> getPrinters() {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(flavor, pras);
        ArrayList<String> printerList = new ArrayList<String>();
        for (PrintService printerService : printServices) {
            printerList.add(printerService.getName());
        }
        return printerList;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        g.setFont(new Font("Roman", 0, 8));
        g.drawString("Hello world !", 0, 10);
        return 0;
    }

    public void printString(String printerName, String data) {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(flavor, pras);
        PrintService service = this.findPrintService(printerName, printService);
        DocPrintJob job = service.createPrintJob();
        try {
            byte[] bytes = data.getBytes("CP437");
            SimpleDoc doc = new SimpleDoc(bytes, flavor, null);
            job.print(doc, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printBytes(String printerName, byte[] bytes) {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(flavor, pras);
        PrintService service = this.findPrintService(printerName, printService);
        DocPrintJob job = service.createPrintJob();
        try {
            SimpleDoc doc = new SimpleDoc(bytes, flavor, null);
            job.print(doc, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrintService findPrintService(String printerName, PrintService[] services) {
        for (PrintService service : services) {
            if (!service.getName().equalsIgnoreCase(printerName)) continue;
            return service;
        }
        return null;
    }
}

