/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.report;

import com.rameses.osiris2.report.SimpleTableReport;
import java.util.ArrayList;
import java.util.List;

public class CrosstabReport
extends SimpleTableReport {
    private FieldProperty rowGroup;
    private FieldProperty colGroup;
    private FieldProperty measure;
    private String orientation;
    private List<FieldProperty> rowGroups = new ArrayList<FieldProperty>();
    private List<FieldProperty> columnGroups = new ArrayList<FieldProperty>();
    private List<FieldProperty> measureGroups = new ArrayList<FieldProperty>();

    public List<FieldProperty> getRowGroups() {
        return this.rowGroups;
    }

    public FieldProperty addRowGroup(String name) {
        return this.addRowGroup(name, null);
    }

    public FieldProperty addRowGroup(String name, String caption) {
        FieldProperty fp = this.findFieldProperty(this.getRowGroups(), name);
        if (fp == null) {
            fp = new FieldProperty(name);
            this.getRowGroups().add(fp);
        }
        fp.setCaption(caption);
        return fp;
    }

    public List<FieldProperty> getColumnGroups() {
        return this.columnGroups;
    }

    public FieldProperty addColumnGroup(String name) {
        return this.addColumnGroup(name, null);
    }

    public FieldProperty addColumnGroup(String name, String caption) {
        FieldProperty fp = this.findFieldProperty(this.getColumnGroups(), name);
        if (fp == null) {
            fp = new FieldProperty(name);
            this.getColumnGroups().add(fp);
        }
        fp.setCaption(caption);
        return fp;
    }

    public List<FieldProperty> getMeasures() {
        return this.measureGroups;
    }

    public FieldProperty addMeasure(String name) {
        return this.addMeasure(name, null);
    }

    public FieldProperty addMeasure(String name, String caption) {
        FieldProperty fp = this.findFieldProperty(this.getMeasures(), name);
        if (fp == null) {
            fp = new FieldProperty(name);
            this.getMeasures().add(fp);
        }
        fp.setCaption(caption);
        return fp;
    }

    private FieldProperty findFieldProperty(List<FieldProperty> fields, String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < fields.size(); ++i) {
            FieldProperty fp = fields.get(i);
            if (!name.equals(fp.getName())) continue;
            return fp;
        }
        return null;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public final String getPreferredOrientation() {
        String s = this.getOrientation();
        if (s == null) {
            return "Portrait";
        }
        if (s.equalsIgnoreCase("landscape")) {
            return "Landscape";
        }
        return "Portrait";
    }

    public FieldProperty getRowGroup(String name) {
        if (name == null) {
            return null;
        }
        for (FieldProperty fp : this.getRowGroups()) {
            if (!name.equals(fp.getName())) continue;
            return fp;
        }
        return null;
    }

    public FieldProperty getColumnGroup(String name) {
        if (name == null) {
            return null;
        }
        for (FieldProperty fp : this.getColumnGroups()) {
            if (!name.equals(fp.getName())) continue;
            return fp;
        }
        return null;
    }

    public FieldProperty getMeasureGroup(String name) {
        if (name == null) {
            return null;
        }
        for (FieldProperty fp : this.getMeasures()) {
            if (!name.equals(fp.getName())) continue;
            return fp;
        }
        return null;
    }

    public class FieldProperty {
        private String name;
        private String caption;
        private String alignment;
        private String headerAlignment;
        private String pattern;

        public FieldProperty(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public String getAlignment() {
            return this.alignment;
        }

        public void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public String getHeaderAlignment() {
            return this.headerAlignment;
        }

        public void setHeaderAlignment(String headerAlignment) {
            this.headerAlignment = headerAlignment;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

