/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swingx;

import com.rameses.rcp.swingx.TextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerField
extends TextField {
    private NumberDocument document = new NumberDocument();

    public IntegerField() {
        super.setDocument(this.document);
    }

    @Override
    public Object getValue() {
        Number num = this.document.getValue();
        return num == null ? 0 : num.intValue();
    }

    @Override
    public void setValue(Object value) {
        this.document.setValue(value);
    }

    private class NumberDocument
    extends PlainDocument {
        private Number value;

        private Number decode(Object value) {
            Number num = null;
            if (value instanceof Number) {
                num = (Number)value;
            } else {
                try {
                    num = Integer.valueOf(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return num;
        }

        public Number getValue() {
            return this.value;
        }

        public void setValue(Number value) {
            this.value = value;
            try {
                super.remove(0, this.getLength());
                if (value != null) {
                    super.insertString(0, value.intValue() + "", null);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }

        public void setValue(Object value) {
            this.setValue(this.decode(value));
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
            sb.insert(offs, str);
            if (sb.toString().equals("-")) {
                super.insertString(offs, str, a);
                this.value = null;
            } else {
                Number num = this.decode(sb.toString());
                if (num != null) {
                    super.insertString(offs, str, a);
                    this.value = num;
                }
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
            sb.delete(offs, offs + len);
            if (sb.length() == 0) {
                super.remove(offs, len);
                this.value = null;
            } else {
                Number num = this.decode(sb.toString());
                super.remove(offs, len);
                this.value = num;
            }
        }
    }
}

