/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swingx;

import com.rameses.rcp.swingx.ComboItem;
import com.rameses.rcp.swingx.IComponent;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ComboField
extends JComboBox
implements IComponent {
    private ComboItem[] items;
    private Comparator comparator;
    private boolean updateable = true;

    public void setItems(ComboItem[] items) {
        this.items = items == null ? new ComboItem[]{} : items;
        this.setModel(new DefaultComboBoxModel<ComboItem>(this.items));
    }

    @Override
    public Object getValue() {
        if (this.items == null || this.items.length == 0) {
            return null;
        }
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.items.length) {
            return this.items[index].getValue();
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        int index = this.indexOf(value);
        if (index < 0 && this.items != null && this.items.length > 0) {
            index = 0;
        }
        int oldIndex = this.getSelectedIndex();
        this.setSelectedIndex(index);
        if (index == oldIndex && oldIndex >= 0) {
            this.selectedItemChanged();
        }
    }

    private int indexOf(Object value) {
        if (this.items == null || this.items.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.items.length; ++i) {
            int result;
            if (!(this.getComparator() == null ? this.items[i].equals(value) : (result = this.getComparator().compare(this.items[i], value)) == 1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

