/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor.table;

import com.rameses.beaninfo.editor.table.ColumnEditorController;
import com.rameses.beaninfo.editor.table.ColumnEditorModel;
import com.rameses.rcp.common.Column;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class TableComponent
extends JTable {
    private ColumnEditorController controller;

    public ColumnEditorController getController() {
        return this.controller;
    }

    public void setController(ColumnEditorController controller) {
        this.controller = controller;
    }

    public ColumnEditorModel getEditorModel() {
        return (ColumnEditorModel)this.getModel();
    }

    public void changeSelection1(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int oldRowIndex = this.getSelectedRow();
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.putClientProperty("selectionPoint", new Point(columnIndex, rowIndex));
        if (oldRowIndex != rowIndex) {
            this.onrowChanged();
        }
    }

    private void onrowChanged() {
        ColumnEditorModel model = this.getEditorModel();
        Column col = model.getItem(this.getSelectedRow());
        this.refresh(col);
    }

    public void refresh(Column oColumn) {
        try {
            this.controller.setColumn(oColumn);
            this.controller.setEnableComponents(oColumn != null);
            this.controller.refresh();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showError(ex);
        }
    }

    private void showError(Throwable t) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = kfm.getActiveWindow();
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        JOptionPane.showMessageDialog(window, errmsg, "ERROR", 0);
    }
}

