/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor.table;

import com.rameses.beaninfo.editor.table.ButtonExtendedPage;
import com.rameses.beaninfo.editor.table.CheckExtendedPage;
import com.rameses.beaninfo.editor.table.ColumnDataTable;
import com.rameses.beaninfo.editor.table.ColumnEditorController;
import com.rameses.beaninfo.editor.table.ColumnEditorModel;
import com.rameses.beaninfo.editor.table.ComboExtendedPage;
import com.rameses.beaninfo.editor.table.DateExtendedPage;
import com.rameses.beaninfo.editor.table.DecimalExtendedPage;
import com.rameses.beaninfo.editor.table.IExtendedPage;
import com.rameses.beaninfo.editor.table.IconExtendedPage;
import com.rameses.beaninfo.editor.table.IntegerExtendedPage;
import com.rameses.beaninfo.editor.table.LabelExtendedPage;
import com.rameses.beaninfo.editor.table.LookupExtendedPage;
import com.rameses.beaninfo.editor.table.OpenerExtendedPage;
import com.rameses.beaninfo.editor.table.TextExtendedPage;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.swingx.CheckField;
import com.rameses.rcp.swingx.ComboField;
import com.rameses.rcp.swingx.ComboItem;
import com.rameses.rcp.swingx.IntegerField;
import com.rameses.rcp.swingx.TextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

public class ColumnEditorPage2
extends JPanel {
    private PropertyEditor propertyEditor;
    private ColumnEditorController controller;
    private ColumnEditorModel model;
    private JButton btnAdd;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private ComboField cboAlignment;
    private ComboField cboTextcase;
    private ComboField cbotype;
    private CheckField chkEditable;
    private CheckField chkNWE;
    private CheckField chkRequired;
    private CheckField chkResizable;
    private CheckField chkVisible;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JPanel pnlExtended;
    private JPanel pnlInfo;
    private JPanel pnlLeft;
    private JPanel pnlbody;
    private ColumnDataTable tblcolumn;
    private JPanel toolbarpanel;
    private TextField txtEditableWhen;
    private TextField txtExpression;
    private TextField txtVisibleWhen;
    private TextField txtcaption;
    private TextField txtname;
    private IntegerField txtwidth;
    private IntegerField txtwidth3;
    private IntegerField txtwidth4;

    public ColumnEditorPage2() {
        this.initComponents();
        this.model = new ColumnEditorModel();
        this.tblcolumn.setSelectionMode(0);
        this.tblcolumn.setEditorModel(this.model);
        this.controller = new ColumnEditorController(){

            @Override
            protected void onvalueChanged(String name) {
                int row = ColumnEditorPage2.this.tblcolumn.getSelectedRow();
                if (row >= 0) {
                    ColumnEditorPage2.this.model.fireTableRowsUpdated(row, row);
                }
                if (ColumnEditorPage2.this.propertyEditor != null) {
                    ColumnEditorPage2.this.propertyEditor.setValue(ColumnEditorPage2.this.model.getColumns());
                }
            }
        };
        this.tblcolumn.setEditorController(this.controller);
        this.controller.registerComponents(this);
        this.controller.addExtendedPage("text", new TextExtendedPage());
        this.controller.addExtendedPage("integer", new IntegerExtendedPage());
        this.controller.addExtendedPage("checkbox", new CheckExtendedPage());
        this.controller.addExtendedPage("combobox", new ComboExtendedPage());
        this.controller.addExtendedPage("date", new DateExtendedPage());
        this.controller.addExtendedPage("double", new DecimalExtendedPage());
        this.controller.addExtendedPage("decimal", new DecimalExtendedPage());
        this.controller.addExtendedPage("label", new LabelExtendedPage());
        this.controller.addExtendedPage("lookup", new LookupExtendedPage());
        this.controller.addExtendedPage("opener", new OpenerExtendedPage());
        this.controller.addExtendedPage("button", new ButtonExtendedPage());
        this.controller.addExtendedPage("icon", new IconExtendedPage());
        this.controller.setEnableComponents(false);
        this.cboTextcase.setItems(new ComboItem[]{new ComboItem("(Default)", null), new ComboItem("UPPER", TextCase.UPPER), new ComboItem("LOWER", TextCase.LOWER), new ComboItem("NONE", TextCase.NONE)});
        this.cboAlignment.setItems(new ComboItem[]{new ComboItem("(Default)", null), new ComboItem("LEFT"), new ComboItem("CENTER"), new ComboItem("RIGHT")});
        this.cboAlignment.setUpdateable(true);
        this.cboAlignment.setComparator(new Comparator(){

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int compare(Object o1, Object o2) {
                String s2;
                String s1 = o1 + "";
                return s1.equalsIgnoreCase(s2 = o2 + "") ? 1 : 0;
            }
        });
        this.cbotype.setItems(new ComboItem[]{new ComboItem("text"), new ComboItem("integer"), new ComboItem("checkbox"), new ComboItem("combobox"), new ComboItem("date"), new ComboItem("double"), new ComboItem("decimal"), new ComboItem("label"), new ComboItem("lookup"), new ComboItem("opener"), new ComboItem("button"), new ComboItem("icon")});
        this.cbotype.setUpdateable(false);
        this.cbotype.addItemListener(new TypeHandler());
        this.chkEditable.setSelected(false);
        this.chkEditable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColumnEditorPage2.this.txtEditableWhen.setEnabled(e.getStateChange() == 1);
            }
        });
        this.txtEditableWhen.putClientProperty(ColumnEditorController.DependHandler.class, new ColumnEditorController.DependHandler("editable", this.txtEditableWhen));
        this.chkVisible.setSelected(true);
        this.chkVisible.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColumnEditorPage2.this.txtVisibleWhen.setEnabled(e.getStateChange() == 1);
            }
        });
        this.txtVisibleWhen.putClientProperty(ColumnEditorController.DependHandler.class, new ColumnEditorController.DependHandler("visible", this.txtVisibleWhen));
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){
                private boolean enabled = true;

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!this.enabled) {
                        return;
                    }
                    this.enabled = false;
                    ColumnEditorPage2.this.onpropertyChange(evt);
                }
            });
        }
    }

    protected void onpropertyChange(PropertyChangeEvent e) {
        Column[] columns = (Column[])(this.propertyEditor == null ? null : this.propertyEditor.getValue());
        this.model.setColumns(columns);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.pnlLeft = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tblcolumn = new ColumnDataTable();
        this.toolbarpanel = new JPanel();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.pnlbody = new JPanel();
        this.jPanel1 = new JPanel();
        this.pnlInfo = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtname = new TextField();
        this.txtcaption = new TextField();
        this.txtwidth = new IntegerField();
        this.txtwidth3 = new IntegerField();
        this.txtwidth4 = new IntegerField();
        this.chkRequired = new CheckField();
        this.chkResizable = new CheckField();
        this.chkNWE = new CheckField();
        this.chkEditable = new CheckField();
        this.txtEditableWhen = new TextField();
        this.chkVisible = new CheckField();
        this.txtVisibleWhen = new TextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.cboTextcase = new ComboField();
        this.jLabel11 = new JLabel();
        this.cboAlignment = new ComboField();
        this.jLabel12 = new JLabel();
        this.txtExpression = new TextField();
        this.cbotype = new ComboField();
        this.pnlExtended = new JPanel();
        this.setLayout(new BorderLayout());
        this.tblcolumn.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.tblcolumn);
        this.btnAdd.setFont(new Font("Monospaced", 1, 12));
        this.btnAdd.setText("+");
        this.btnAdd.setMargin(new Insets(1, 7, 1, 7));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage2.this.btnAddActionPerformed(evt);
            }
        });
        this.btnRemove.setFont(new Font("Monospaced", 1, 12));
        this.btnRemove.setText("-");
        this.btnRemove.setMargin(new Insets(1, 7, 1, 7));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage2.this.btnRemoveActionPerformed(evt);
            }
        });
        this.btnUp.setFont(new Font("Monospaced", 0, 12));
        this.btnUp.setText("Up");
        this.btnUp.setMargin(new Insets(1, 5, 1, 5));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage2.this.btnUpActionPerformed(evt);
            }
        });
        this.btnDown.setFont(new Font("Monospaced", 0, 12));
        this.btnDown.setText("Down");
        this.btnDown.setMargin(new Insets(1, 5, 1, 5));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage2.this.btnDownActionPerformed(evt);
            }
        });
        GroupLayout toolbarpanelLayout = new GroupLayout((Container)this.toolbarpanel);
        this.toolbarpanel.setLayout((LayoutManager)toolbarpanelLayout);
        toolbarpanelLayout.setHorizontalGroup((GroupLayout.Group)toolbarpanelLayout.createParallelGroup(1).add((GroupLayout.Group)toolbarpanelLayout.createSequentialGroup().add((Component)this.btnAdd).addPreferredGap(0).add((Component)this.btnRemove).addPreferredGap(0, 47, Short.MAX_VALUE).add((Component)this.btnUp, -2, 37, -2).addPreferredGap(0).add((Component)this.btnDown)));
        toolbarpanelLayout.setVerticalGroup((GroupLayout.Group)toolbarpanelLayout.createParallelGroup(1).add((GroupLayout.Group)toolbarpanelLayout.createParallelGroup(3).add((Component)this.btnAdd).add((Component)this.btnRemove).add((Component)this.btnDown).add((Component)this.btnUp)));
        GroupLayout pnlLeftLayout = new GroupLayout((Container)this.pnlLeft);
        this.pnlLeft.setLayout((LayoutManager)pnlLeftLayout);
        pnlLeftLayout.setHorizontalGroup((GroupLayout.Group)pnlLeftLayout.createParallelGroup(1).add((GroupLayout.Group)pnlLeftLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlLeftLayout.createParallelGroup(2, false).add(1, (Component)this.jScrollPane2, 0, 0, Short.MAX_VALUE).add(1, (Component)this.toolbarpanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pnlLeftLayout.setVerticalGroup((GroupLayout.Group)pnlLeftLayout.createParallelGroup(1).add((GroupLayout.Group)pnlLeftLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -2, 461, -2).add(4, 4, 4).add((Component)this.toolbarpanel, -2, -1, -2).addContainerGap(16, Short.MAX_VALUE)));
        this.add((Component)this.pnlLeft, "West");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, " Column Information ", 0, 0, new Font("Tahoma", 1, 11)));
        this.pnlInfo.setLayout(null);
        this.jLabel1.setText("Name:");
        this.pnlInfo.add(this.jLabel1);
        this.jLabel1.setBounds(18, 14, 52, 18);
        this.jLabel2.setText("Caption:");
        this.pnlInfo.add(this.jLabel2);
        this.jLabel2.setBounds(18, 40, 52, 18);
        this.jLabel6.setText("Width:");
        this.pnlInfo.add(this.jLabel6);
        this.jLabel6.setBounds(18, 68, 52, 18);
        this.jLabel7.setText("Min Width:");
        this.pnlInfo.add(this.jLabel7);
        this.jLabel7.setBounds(154, 68, 62, 18);
        this.jLabel8.setText("Max Width:");
        this.pnlInfo.add(this.jLabel8);
        this.jLabel8.setBounds(298, 68, 62, 18);
        this.jLabel3.setText("Handler:");
        this.pnlInfo.add(this.jLabel3);
        this.jLabel3.setBounds(20, 270, 64, 22);
        this.jLabel4.setBorder(BorderFactory.createEtchedBorder());
        this.pnlInfo.add(this.jLabel4);
        this.jLabel4.setBounds(10, 96, 422, 2);
        this.jLabel5.setText("jLabel5");
        this.jLabel5.setBorder(BorderFactory.createEtchedBorder());
        this.pnlInfo.add(this.jLabel5);
        this.jLabel5.setBounds(10, 190, 422, 2);
        this.txtname.setName("name");
        this.pnlInfo.add(this.txtname);
        this.txtname.setBounds(70, 14, 352, 20);
        this.txtcaption.setName("caption");
        this.pnlInfo.add(this.txtcaption);
        this.txtcaption.setBounds(70, 40, 352, 20);
        this.txtwidth.setText("integerField1");
        this.txtwidth.setName("width");
        this.pnlInfo.add(this.txtwidth);
        this.txtwidth.setBounds(70, 68, 62, 20);
        this.txtwidth3.setText("integerField1");
        this.txtwidth3.setName("minWidth");
        this.pnlInfo.add(this.txtwidth3);
        this.txtwidth3.setBounds(216, 68, 62, 20);
        this.txtwidth4.setText("integerField1");
        this.txtwidth4.setName("maxWidth");
        this.pnlInfo.add(this.txtwidth4);
        this.txtwidth4.setBounds(360, 68, 62, 20);
        this.chkRequired.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkRequired.setText("Required");
        this.chkRequired.setMargin(new Insets(0, 0, 0, 0));
        this.chkRequired.setName("required");
        this.pnlInfo.add(this.chkRequired);
        this.chkRequired.setBounds(70, 108, 76, 18);
        this.chkResizable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkResizable.setText("Resizable");
        this.chkResizable.setMargin(new Insets(0, 0, 0, 0));
        this.chkResizable.setName("resizable");
        this.pnlInfo.add(this.chkResizable);
        this.chkResizable.setBounds(154, 108, 76, 18);
        this.chkNWE.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNWE.setText("Null When Empty");
        this.chkNWE.setMargin(new Insets(0, 0, 0, 0));
        this.chkNWE.setName("resizable");
        this.pnlInfo.add(this.chkNWE);
        this.chkNWE.setBounds(236, 108, 186, 18);
        this.chkEditable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkEditable.setText("Visible");
        this.chkEditable.setMargin(new Insets(0, 0, 0, 0));
        this.chkEditable.setName("visible");
        this.pnlInfo.add(this.chkEditable);
        this.chkEditable.setBounds(70, 157, 76, 18);
        this.txtEditableWhen.setName("visibleWhen");
        this.pnlInfo.add(this.txtEditableWhen);
        this.txtEditableWhen.setBounds(154, 157, 268, 20);
        this.chkVisible.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVisible.setText("Editable");
        this.chkVisible.setMargin(new Insets(0, 0, 0, 0));
        this.chkVisible.setName("editable");
        this.pnlInfo.add(this.chkVisible);
        this.chkVisible.setBounds(70, 132, 76, 18);
        this.txtVisibleWhen.setName("editableWhen");
        this.pnlInfo.add(this.txtVisibleWhen);
        this.txtVisibleWhen.setBounds(154, 132, 268, 20);
        this.jLabel9.setText("jLabel5");
        this.jLabel9.setBorder(BorderFactory.createEtchedBorder());
        this.pnlInfo.add(this.jLabel9);
        this.jLabel9.setBounds(10, 260, 422, 2);
        this.jLabel10.setText("Text Case:");
        this.pnlInfo.add(this.jLabel10);
        this.jLabel10.setBounds(20, 200, 62, 22);
        this.cboTextcase.setName("textCase");
        this.pnlInfo.add(this.cboTextcase);
        this.cboTextcase.setBounds(80, 200, 108, 22);
        this.jLabel11.setText("Alignment:");
        this.pnlInfo.add(this.jLabel11);
        this.jLabel11.setBounds(220, 200, 62, 22);
        this.cboAlignment.setName("alignment");
        this.pnlInfo.add(this.cboAlignment);
        this.cboAlignment.setBounds(290, 200, 130, 22);
        this.jLabel12.setText("Expression:");
        this.pnlInfo.add(this.jLabel12);
        this.jLabel12.setBounds(20, 230, 66, 18);
        this.txtExpression.setName("expression");
        this.pnlInfo.add(this.txtExpression);
        this.txtExpression.setBounds(80, 230, 332, 20);
        this.cbotype.setModel(new DefaultComboBoxModel<String>(new String[]{"text", "integer", "checkbox", "combobox", "date", "double", "decimal", "label", "lookup", "opener", "icon"}));
        this.cbotype.setName("typeHandler");
        this.pnlInfo.add(this.cbotype);
        this.cbotype.setBounds(80, 270, 108, 22);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.pnlInfo, -1, 438, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.pnlInfo, -1, 305, Short.MAX_VALUE));
        this.pnlExtended.setBorder(BorderFactory.createTitledBorder(null, " Extended Information ", 0, 0, new Font("Tahoma", 1, 11)));
        this.pnlExtended.setLayout(new BorderLayout());
        GroupLayout pnlbodyLayout = new GroupLayout((Container)this.pnlbody);
        this.pnlbody.setLayout((LayoutManager)pnlbodyLayout);
        pnlbodyLayout.setHorizontalGroup((GroupLayout.Group)pnlbodyLayout.createParallelGroup(1).add((GroupLayout.Group)pnlbodyLayout.createSequentialGroup().add((GroupLayout.Group)pnlbodyLayout.createParallelGroup(2).add(1, (Component)this.pnlExtended, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -2, -1, -2)).add(20, 20, 20)));
        pnlbodyLayout.setVerticalGroup((GroupLayout.Group)pnlbodyLayout.createParallelGroup(1).add((GroupLayout.Group)pnlbodyLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlExtended, -1, 155, Short.MAX_VALUE).addContainerGap()));
        this.add((Component)this.pnlbody, "Center");
    }

    private void btnDownActionPerformed(ActionEvent evt) {
        int index = this.tblcolumn.getSelectedRow();
        if (this.model.moveItemDown(index)) {
            this.tblcolumn.setRowSelectionInterval(index + 1, index + 1);
            this.tblcolumn.grabFocus();
            if (this.propertyEditor != null) {
                this.propertyEditor.setValue(this.model.getColumns());
            }
        }
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        int index = this.tblcolumn.getSelectedRow();
        if (this.model.moveItemUp(index)) {
            this.tblcolumn.setRowSelectionInterval(index - 1, index - 1);
            this.tblcolumn.grabFocus();
            if (this.propertyEditor != null) {
                this.propertyEditor.setValue(this.model.getColumns());
            }
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int selIndex = this.tblcolumn.getSelectedRow();
        if (this.model.removeItem(selIndex)) {
            int rowcount;
            Point selPoint = (Point)this.tblcolumn.getClientProperty("selectionPoint");
            if (selPoint == null) {
                selPoint = new Point();
            }
            if ((rowcount = this.model.getRowCount()) == 0) {
                this.tblcolumn.refresh(null);
            } else if (selIndex >= 0 && selIndex < rowcount) {
                this.tblcolumn.changeSelection(selIndex, selPoint.x, false, false);
            } else if (selIndex >= rowcount && rowcount > 0) {
                this.tblcolumn.changeSelection(rowcount - 1, selPoint.x, false, false);
            }
            if (this.propertyEditor != null) {
                this.propertyEditor.setValue(this.model.getColumns());
            }
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        int row;
        boolean enable;
        this.controller.setColumn(this.model.addRow());
        boolean bl = enable = this.controller.getColumn() != null;
        if (enable && (row = this.model.getRowCount() - 1) >= 0) {
            this.tblcolumn.changeSelection(row, 0, false, false);
        }
        this.controller.setEnableComponents(enable);
        this.controller.refresh();
        this.controller.focusComponent("name");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnEditorPage2.this.controller.focusComponent("name");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void showError(Throwable t) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = kfm.getActiveWindow();
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        JOptionPane.showMessageDialog(window, errmsg, "ERROR", 0);
    }

    private class TypeHandler
    implements ItemListener {
        private TypeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            ColumnEditorPage2.this.pnlExtended.removeAll();
            JComponent page = ColumnEditorPage2.this.controller.getExtendedPage(e.getItem() + "");
            if (page != null) {
                ColumnEditorPage2.this.pnlExtended.add(page);
            }
            ColumnEditorPage2.this.pnlExtended.revalidate();
            ColumnEditorPage2.this.pnlExtended.repaint();
            try {
                if (page != null && ColumnEditorPage2.this.controller.getColumn() != null) {
                    if (page instanceof IExtendedPage) {
                        IExtendedPage xpage = (IExtendedPage)((Object)page);
                        xpage.setTypeHandler(ColumnEditorPage2.this.controller.getColumn().getTypeHandler());
                        ColumnEditorPage2.this.controller.getColumn().setTypeHandler(xpage.getTypeHandler());
                        if (ColumnEditorPage2.this.propertyEditor != null) {
                            ColumnEditorPage2.this.propertyEditor.setValue(ColumnEditorPage2.this.model.getColumns());
                        }
                    }
                    ColumnEditorPage2.this.controller.refresh(page, ColumnEditorPage2.this.controller.getColumn().getTypeHandler());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ColumnEditorPage2.this.showError(ex);
            }
        }
    }
}

