/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor.table;

import com.rameses.beaninfo.editor.table.CheckExtendedPage;
import com.rameses.beaninfo.editor.table.ColumnEditorController;
import com.rameses.beaninfo.editor.table.ColumnEditorModel;
import com.rameses.beaninfo.editor.table.ComboExtendedPage;
import com.rameses.beaninfo.editor.table.DateExtendedPage;
import com.rameses.beaninfo.editor.table.DecimalExtendedPage;
import com.rameses.beaninfo.editor.table.IExtendedPage;
import com.rameses.beaninfo.editor.table.IntegerExtendedPage;
import com.rameses.beaninfo.editor.table.LookupExtendedPage;
import com.rameses.beaninfo.editor.table.OpenerExtendedPage;
import com.rameses.beaninfo.editor.table.TextExtendedPage;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.swingx.CheckField;
import com.rameses.rcp.swingx.ComboField;
import com.rameses.rcp.swingx.ComboItem;
import com.rameses.rcp.swingx.IntegerField;
import com.rameses.rcp.swingx.TextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

public class ColumnEditorPage
extends JPanel {
    private PropertyEditor propertyEditor;
    private ColumnEditorController controller;
    private ColumnEditorModel model;
    private JLabel lblAlignment;
    private ComboField cboAlignment;
    private JLabel lblTextcase;
    private ComboField cboTextcase;
    private JButton btnAdd;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private ComboField cbotype;
    private CheckField chkEditable;
    private CheckField chkNWE;
    private CheckField chkNullWhenEmpty;
    private CheckField chkResizable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JPanel pnlExtended;
    private JPanel pnlLeft;
    private JPanel pnlbody;
    private TableImpl tblcolumn;
    private JPanel toolbarpanel;
    private TextField txtEditableWhen;
    private TextField txtcaption;
    private TextField txtname;
    private IntegerField txtwidth;
    private IntegerField txtwidth3;
    private IntegerField txtwidth4;

    public ColumnEditorPage() {
        this.initComponents();
        this.model = new ColumnEditorModel();
        this.tblcolumn.setModel(this.model);
        this.tblcolumn.setSelectionMode(0);
        this.controller = new ColumnEditorController(){

            @Override
            protected void onvalueChanged(String name) {
                int row = ColumnEditorPage.this.tblcolumn.getSelectedRow();
                if (row >= 0) {
                    ColumnEditorPage.this.model.fireTableRowsUpdated(row, row);
                }
                if (ColumnEditorPage.this.propertyEditor != null) {
                    ColumnEditorPage.this.propertyEditor.setValue(ColumnEditorPage.this.model.getColumns());
                }
            }
        };
        this.lblAlignment = new JLabel("Alignment");
        this.lblAlignment.setBounds(188, 195, 58, 18);
        this.jPanel6.add(this.lblAlignment);
        this.cboAlignment = new ComboField();
        this.cboAlignment.setName("alignment");
        this.cboAlignment.setBounds(244, 195, 176, this.cboAlignment.getPreferredSize().height);
        this.jPanel6.add(this.cboAlignment);
        this.jLabel9.setVisible(false);
        this.txtEditableWhen.setBounds(138, 132, 284, 19);
        this.chkEditable.setBounds(70, 132, 82, 19);
        this.lblTextcase = new JLabel("Text Case:");
        this.lblTextcase.setBounds(70, 158, 68, 20);
        this.jPanel6.add(this.lblTextcase);
        this.cboTextcase = new ComboField();
        this.cboTextcase.setName("textCase");
        this.cboTextcase.setBounds(138, 158, 100, this.cboTextcase.getPreferredSize().height);
        this.cboTextcase.setItems(new ComboItem[]{new ComboItem("(Default)", null), new ComboItem("UPPER", TextCase.UPPER), new ComboItem("LOWER", TextCase.LOWER), new ComboItem("NONE", TextCase.NONE)});
        this.cboAlignment.setUpdateable(true);
        this.jPanel6.add(this.cboTextcase);
        this.controller.registerComponents(this);
        this.controller.addExtendedPage("text", new TextExtendedPage());
        this.controller.addExtendedPage("integer", new IntegerExtendedPage());
        this.controller.addExtendedPage("checkbox", new CheckExtendedPage());
        this.controller.addExtendedPage("combobox", new ComboExtendedPage());
        this.controller.addExtendedPage("date", new DateExtendedPage());
        this.controller.addExtendedPage("double", new DecimalExtendedPage());
        this.controller.addExtendedPage("decimal", new DecimalExtendedPage());
        this.controller.addExtendedPage("lookup", new LookupExtendedPage());
        this.controller.addExtendedPage("opener", new OpenerExtendedPage());
        this.controller.setEnableComponents(false);
        this.cbotype.setItems(new ComboItem[]{new ComboItem("text"), new ComboItem("integer"), new ComboItem("checkbox"), new ComboItem("combobox"), new ComboItem("date"), new ComboItem("double"), new ComboItem("decimal"), new ComboItem("lookup"), new ComboItem("opener")});
        this.cbotype.setUpdateable(false);
        this.cbotype.addItemListener(new TypeHandler());
        this.cboAlignment.setItems(new ComboItem[]{new ComboItem("(Default)", null), new ComboItem("LEFT"), new ComboItem("CENTER"), new ComboItem("RIGHT")});
        this.cboAlignment.setUpdateable(true);
        this.cboAlignment.setComparator(new Comparator(){

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int compare(Object o1, Object o2) {
                String s2;
                String s1 = o1 + "";
                return s1.equalsIgnoreCase(s2 = o2 + "") ? 1 : 0;
            }
        });
        this.chkEditable.setSelected(false);
        this.chkEditable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColumnEditorPage.this.txtEditableWhen.setEnabled(e.getStateChange() == 1);
            }
        });
        this.txtEditableWhen.putClientProperty(ColumnEditorController.DependHandler.class, new ColumnEditorController.DependHandler("editable", this.txtEditableWhen));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ColumnEditorPage.this.tblcolumn.getSelectedRow();
                if (ColumnEditorPage.this.model.moveItemDown(index)) {
                    ColumnEditorPage.this.tblcolumn.setRowSelectionInterval(index + 1, index + 1);
                    ColumnEditorPage.this.tblcolumn.grabFocus();
                    if (ColumnEditorPage.this.propertyEditor != null) {
                        ColumnEditorPage.this.propertyEditor.setValue(ColumnEditorPage.this.model.getColumns());
                    }
                }
            }
        });
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){
                private boolean enabled = true;

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!this.enabled) {
                        return;
                    }
                    this.enabled = false;
                    ColumnEditorPage.this.onpropertyChange(evt);
                }
            });
        }
    }

    protected void onpropertyChange(PropertyChangeEvent e) {
        Column[] columns = (Column[])(this.propertyEditor == null ? null : this.propertyEditor.getValue());
        this.model.setColumns(columns);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.pnlbody = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtname = new TextField();
        this.jLabel2 = new JLabel();
        this.txtcaption = new TextField();
        this.jLabel6 = new JLabel();
        this.txtwidth = new IntegerField();
        this.jLabel7 = new JLabel();
        this.txtwidth3 = new IntegerField();
        this.jLabel8 = new JLabel();
        this.txtwidth4 = new IntegerField();
        this.jLabel3 = new JLabel();
        this.cbotype = new ComboField();
        this.chkNullWhenEmpty = new CheckField();
        this.chkResizable = new CheckField();
        this.chkNWE = new CheckField();
        this.jLabel9 = new JLabel();
        this.txtEditableWhen = new TextField();
        this.chkEditable = new CheckField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.pnlExtended = new JPanel();
        this.pnlLeft = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblcolumn = new TableImpl();
        this.toolbarpanel = new JPanel();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(723, 510));
        this.pnlbody.setBorder(BorderFactory.createEmptyBorder(5, 1, 1, 1));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, " Column Information ", 0, 0, new Font("Tahoma", 1, 11)));
        this.jPanel6.setLayout(null);
        this.jLabel1.setText("Name:");
        this.jPanel6.add(this.jLabel1);
        this.jLabel1.setBounds(18, 14, 52, 18);
        this.txtname.setName("name");
        this.jPanel6.add(this.txtname);
        this.txtname.setBounds(70, 14, 352, 19);
        this.jLabel2.setText("Caption:");
        this.jPanel6.add(this.jLabel2);
        this.jLabel2.setBounds(18, 40, 52, 18);
        this.txtcaption.setName("caption");
        this.jPanel6.add(this.txtcaption);
        this.txtcaption.setBounds(70, 40, 352, 19);
        this.jLabel6.setText("Width:");
        this.jPanel6.add(this.jLabel6);
        this.jLabel6.setBounds(18, 68, 52, 18);
        this.txtwidth.setName("width");
        this.jPanel6.add(this.txtwidth);
        this.txtwidth.setBounds(70, 68, 62, 19);
        this.jLabel7.setText("Min Width:");
        this.jPanel6.add(this.jLabel7);
        this.jLabel7.setBounds(154, 68, 62, 18);
        this.txtwidth3.setName("minWidth");
        this.jPanel6.add(this.txtwidth3);
        this.txtwidth3.setBounds(216, 68, 62, 19);
        this.jLabel8.setText("Max Width:");
        this.jPanel6.add(this.jLabel8);
        this.jLabel8.setBounds(298, 68, 62, 18);
        this.txtwidth4.setName("maxWidth");
        this.jPanel6.add(this.txtwidth4);
        this.txtwidth4.setBounds(360, 68, 62, 19);
        this.jLabel3.setText("Type:");
        this.jPanel6.add(this.jLabel3);
        this.jLabel3.setBounds(18, 196, 50, 18);
        this.cbotype.setModel(new DefaultComboBoxModel<String>(new String[]{"string", "integer", "boolean", "checkbox", "combo", "date", "double", "decimal", "lookup"}));
        this.cbotype.setName("typeHandler");
        this.jPanel6.add(this.cbotype);
        this.cbotype.setBounds(70, 195, 84, 22);
        this.chkNullWhenEmpty.setText("Required");
        this.chkNullWhenEmpty.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNullWhenEmpty.setMargin(new Insets(0, 0, 0, 0));
        this.chkNullWhenEmpty.setName("required");
        this.jPanel6.add(this.chkNullWhenEmpty);
        this.chkNullWhenEmpty.setBounds(70, 108, 82, 18);
        this.chkResizable.setText("Resizable");
        this.chkResizable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkResizable.setMargin(new Insets(0, 0, 0, 0));
        this.chkResizable.setName("resizable");
        this.jPanel6.add(this.chkResizable);
        this.chkResizable.setBounds(154, 108, 82, 18);
        this.chkNWE.setText("Null When Empty");
        this.chkNWE.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNWE.setMargin(new Insets(0, 0, 0, 0));
        this.chkNWE.setName("nullWhenEmpty");
        this.jPanel6.add(this.chkNWE);
        this.chkNWE.setBounds(236, 108, 114, 18);
        this.jLabel9.setText("Expression:");
        this.jPanel6.add(this.jLabel9);
        this.jLabel9.setBounds(87, 152, 68, 14);
        this.txtEditableWhen.setName("editableWhen");
        this.jPanel6.add(this.txtEditableWhen);
        this.txtEditableWhen.setBounds(155, 150, 266, 19);
        this.chkEditable.setText("Editable");
        this.chkEditable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkEditable.setMargin(new Insets(0, 0, 0, 0));
        this.chkEditable.setName("editable");
        this.jPanel6.add(this.chkEditable);
        this.chkEditable.setBounds(70, 132, 82, 15);
        this.jLabel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel6.add(this.jLabel4);
        this.jLabel4.setBounds(10, 96, 422, 2);
        this.jLabel5.setText("jLabel5");
        this.jLabel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel6.add(this.jLabel5);
        this.jLabel5.setBounds(10, 184, 422, 2);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel6, -1, 438, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jPanel6, -1, 222, Short.MAX_VALUE));
        this.pnlExtended.setLayout(new BorderLayout());
        this.pnlExtended.setBorder(BorderFactory.createTitledBorder(null, " Extended Information ", 0, 0, new Font("Tahoma", 1, 11)));
        GroupLayout pnlbodyLayout = new GroupLayout((Container)this.pnlbody);
        this.pnlbody.setLayout((LayoutManager)pnlbodyLayout);
        pnlbodyLayout.setHorizontalGroup((GroupLayout.Group)pnlbodyLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlbodyLayout.createSequentialGroup().add((GroupLayout.Group)pnlbodyLayout.createParallelGroup(2).add((Component)this.pnlExtended, -1, 460, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pnlbodyLayout.setVerticalGroup((GroupLayout.Group)pnlbodyLayout.createParallelGroup(1).add((GroupLayout.Group)pnlbodyLayout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlExtended, -1, 238, Short.MAX_VALUE).addContainerGap()));
        this.add((Component)this.pnlbody, "Center");
        this.tblcolumn.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblcolumn);
        this.btnAdd.setFont(new Font("Monospaced", 1, 12));
        this.btnAdd.setText("+");
        this.btnAdd.setMargin(new Insets(1, 7, 1, 7));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage.this.btnAddActionPerformed(evt);
            }
        });
        this.btnRemove.setFont(new Font("Monospaced", 1, 12));
        this.btnRemove.setText("-");
        this.btnRemove.setMargin(new Insets(1, 7, 1, 7));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage.this.btnRemoveActionPerformed(evt);
            }
        });
        this.btnUp.setFont(new Font("Monospaced", 0, 12));
        this.btnUp.setText("Up");
        this.btnUp.setMargin(new Insets(1, 5, 1, 5));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnEditorPage.this.btnUpActionPerformed(evt);
            }
        });
        this.btnDown.setFont(new Font("Monospaced", 0, 12));
        this.btnDown.setText("Down");
        this.btnDown.setMargin(new Insets(1, 5, 1, 5));
        GroupLayout toolbarpanelLayout = new GroupLayout((Container)this.toolbarpanel);
        this.toolbarpanel.setLayout((LayoutManager)toolbarpanelLayout);
        toolbarpanelLayout.setHorizontalGroup((GroupLayout.Group)toolbarpanelLayout.createParallelGroup(1).add((GroupLayout.Group)toolbarpanelLayout.createSequentialGroup().add((Component)this.btnAdd).addPreferredGap(0).add((Component)this.btnRemove).addPreferredGap(0, 47, Short.MAX_VALUE).add((Component)this.btnUp, -2, 37, -2).addPreferredGap(0).add((Component)this.btnDown)));
        toolbarpanelLayout.setVerticalGroup((GroupLayout.Group)toolbarpanelLayout.createParallelGroup(1).add((GroupLayout.Group)toolbarpanelLayout.createParallelGroup(3).add((Component)this.btnAdd).add((Component)this.btnRemove).add((Component)this.btnDown).add((Component)this.btnUp)));
        GroupLayout pnlLeftLayout = new GroupLayout((Container)this.pnlLeft);
        this.pnlLeft.setLayout((LayoutManager)pnlLeftLayout);
        pnlLeftLayout.setHorizontalGroup((GroupLayout.Group)pnlLeftLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlLeftLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlLeftLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 189, Short.MAX_VALUE).add(1, (Component)this.toolbarpanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pnlLeftLayout.setVerticalGroup((GroupLayout.Group)pnlLeftLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlLeftLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 459, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.toolbarpanel, -2, -1, -2).addContainerGap()));
        this.add((Component)this.pnlLeft, "West");
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        int index = this.tblcolumn.getSelectedRow();
        if (this.model.moveItemUp(index)) {
            this.tblcolumn.setRowSelectionInterval(index - 1, index - 1);
            this.tblcolumn.grabFocus();
            if (this.propertyEditor != null) {
                this.propertyEditor.setValue(this.model.getColumns());
            }
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int selIndex = this.tblcolumn.getSelectedRow();
        if (this.model.removeItem(selIndex)) {
            int rowcount;
            Point selPoint = (Point)this.tblcolumn.getClientProperty("selectionPoint");
            if (selPoint == null) {
                selPoint = new Point();
            }
            if ((rowcount = this.model.getRowCount()) == 0) {
                this.tblcolumn.refresh(null);
            } else if (selIndex >= 0 && selIndex < rowcount) {
                this.tblcolumn.changeSelection(selIndex, selPoint.x, false, false);
            } else if (selIndex >= rowcount && rowcount > 0) {
                this.tblcolumn.changeSelection(rowcount - 1, selPoint.x, false, false);
            }
            if (this.propertyEditor != null) {
                this.propertyEditor.setValue(this.model.getColumns());
            }
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        int row;
        boolean enable;
        this.controller.setColumn(this.model.addRow());
        boolean bl = enable = this.controller.getColumn() != null;
        if (enable && (row = this.model.getRowCount() - 1) >= 0) {
            this.tblcolumn.changeSelection(row, 0, false, false);
        }
        this.controller.setEnableComponents(enable);
        this.controller.refresh();
        this.controller.focusComponent("name");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnEditorPage.this.controller.focusComponent("name");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void showError(Throwable t) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = kfm.getActiveWindow();
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        JOptionPane.showMessageDialog(window, errmsg, "ERROR", 0);
    }

    private class TypeHandler
    implements ItemListener {
        private TypeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            ColumnEditorPage.this.pnlExtended.removeAll();
            JComponent page = ColumnEditorPage.this.controller.getExtendedPage(e.getItem() + "");
            if (page != null) {
                ColumnEditorPage.this.pnlExtended.add(page);
            }
            ColumnEditorPage.this.pnlExtended.revalidate();
            ColumnEditorPage.this.pnlExtended.repaint();
            try {
                if (page != null && ColumnEditorPage.this.controller.getColumn() != null) {
                    if (page instanceof IExtendedPage) {
                        IExtendedPage xpage = (IExtendedPage)((Object)page);
                        xpage.setTypeHandler(ColumnEditorPage.this.controller.getColumn().getTypeHandler());
                        ColumnEditorPage.this.controller.getColumn().setTypeHandler(xpage.getTypeHandler());
                        if (ColumnEditorPage.this.propertyEditor != null) {
                            ColumnEditorPage.this.propertyEditor.setValue(ColumnEditorPage.this.model.getColumns());
                        }
                    }
                    ColumnEditorPage.this.controller.refresh(page, ColumnEditorPage.this.controller.getColumn().getTypeHandler());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ColumnEditorPage.this.showError(ex);
            }
        }
    }

    private class TableImpl
    extends JTable {
        private TableImpl() {
        }

        public void selectRow(int rowIndex) {
            if (rowIndex >= 0 && rowIndex < ColumnEditorPage.this.model.getRowCount()) {
                Point selPoint = (Point)this.getClientProperty("selectionPoint");
                if (selPoint == null) {
                    selPoint = new Point();
                }
                this.changeSelection(rowIndex, selPoint.x, false, false);
            }
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            int oldRowIndex = this.getSelectedRow();
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
            this.putClientProperty("selectionPoint", new Point(columnIndex, rowIndex));
            if (oldRowIndex != rowIndex) {
                this.onrowChanged();
            }
        }

        private void onrowChanged() {
            Column col = ColumnEditorPage.this.model.getItem(this.getSelectedRow());
            this.refresh(col);
        }

        public void refresh(Column col) {
            try {
                ColumnEditorPage.this.controller.setColumn(col);
                ColumnEditorPage.this.controller.setEnableComponents(col != null);
                ColumnEditorPage.this.controller.refresh();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ColumnEditorPage.this.showError(ex);
            }
        }
    }
}

