/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor.table;

import com.rameses.rcp.common.Column;
import com.rameses.rcp.constant.TextCase;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ColumnEditorModel
extends AbstractTableModel {
    private List<Column> rows = new ArrayList<Column>();
    private String[] columns = new String[]{"Column"};

    public Column[] getColumns() {
        return this.rows.toArray(new Column[0]);
    }

    public void setColumns(Column[] columns) {
        this.rows.clear();
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.rows.add(columns[i]);
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.columns[index];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            Column col = this.rows.get(rowIndex);
            if (col.getCaption() != null) {
                return col.getCaption();
            }
            return col.getName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Column getItem(int index) {
        try {
            return this.rows.get(index);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Column addRow() {
        Column col = new Column();
        col.setTextCase(TextCase.NONE);
        int index = this.rows.size();
        this.rows.add(col);
        this.fireTableRowsInserted(index, index);
        return col;
    }

    boolean removeItem(int index) {
        if (index >= 0 && index < this.rows.size()) {
            this.rows.remove(index);
            this.fireTableRowsDeleted(index, index);
            return true;
        }
        return false;
    }

    boolean moveItemUp(int index) {
        if (index - 1 >= 0 && index - 1 < this.getRowCount()) {
            Column source = this.rows.get(index);
            Column target = this.rows.get(index - 1);
            this.rows.set(index - 1, source);
            this.rows.set(index, target);
            this.fireTableRowsUpdated(index - 1, index);
            return true;
        }
        return false;
    }

    boolean moveItemDown(int index) {
        if (index + 1 >= 0 && index + 1 < this.getRowCount()) {
            Column source = this.rows.get(index);
            Column target = this.rows.get(index + 1);
            this.rows.set(index + 1, source);
            this.rows.set(index, target);
            this.fireTableRowsUpdated(index, index + 1);
            return true;
        }
        return false;
    }

    int indexOf(Column c) {
        return this.rows.indexOf(c);
    }
}

