/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor.table;

import com.rameses.beaninfo.editor.table.IExtendedPage;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.swingx.IComponent;
import com.rameses.rcp.swingx.IComponentView;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

public class ColumnEditorController {
    private Map<String, JComponent> extended = new HashMap<String, JComponent>();
    private List<JComponent> components = new ArrayList<JComponent>();
    private Column column;

    void registerComponents(JComponent comp) {
        this.registerFromPage(comp);
    }

    JComponent getExtendedPage(String type) {
        return this.extended.get(type);
    }

    void addExtendedPage(String type, JComponent page) {
        if (type != null && page != null) {
            this.extended.put(type, page);
            this.registerFromPage(page);
        }
    }

    private void registerFromPage(JComponent page) {
        Component[] comps;
        boolean extended = page instanceof IExtendedPage;
        for (Component c : comps = page.getComponents()) {
            if (!(c instanceof JComponent) || c instanceof JTable) continue;
            JComponent jc = (JComponent)c;
            if (extended) {
                jc.putClientProperty("PAGE", page);
            }
            if (jc instanceof JTextComponent) {
                this.register(jc);
                continue;
            }
            if (jc instanceof JComboBox) {
                this.register(jc);
                continue;
            }
            if (jc instanceof JCheckBox) {
                this.register(jc);
                continue;
            }
            if (jc.getComponentCount() <= 0) continue;
            this.registerFromPage(jc);
        }
    }

    private void register(JComponent comp) {
        if (comp.getName() == null || comp.getName().length() == 0) {
            return;
        }
        if (!this.components.contains(comp)) {
            this.components.add(comp);
            if (comp instanceof JTextComponent) {
                comp.setInputVerifier(new InputVerifierImpl());
            } else if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).addItemListener(new CheckItemHandler());
            } else if (comp instanceof JComboBox) {
                ((JComboBox)comp).addItemListener(new ComboItemHandler());
            }
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setEnableComponents(boolean enable) {
        for (JComponent jc : this.components) {
            jc.setEnabled(enable);
        }
    }

    public void refresh() {
        for (JComponent jc : this.components) {
            IComponent icomp;
            String name = jc.getName();
            Object value = this.getValue(this.column, name);
            if (!(jc instanceof IComponent) || (icomp = (IComponent)((Object)jc)).getClientProperty("PAGE") != null) continue;
            icomp.setValue(value);
            this.notifyDepends(jc, name, value);
        }
    }

    void refresh(JComponent page, Object bean) {
        if (page == null) {
            return;
        }
        for (JComponent jc : this.components) {
            JComponent jpage = (JComponent)jc.getClientProperty("PAGE");
            if (jpage != page) continue;
            String name = jc.getName();
            Object value = this.getValue(bean, name);
            if (!(jc instanceof IComponent)) continue;
            ((IComponent)((Object)jc)).setValue(value);
            this.notifyDepends(jc, name, value);
        }
    }

    void notifyDepends(JComponent source, String name, Object value) {
        if (name == null) {
            return;
        }
        for (JComponent jc : this.components) {
            DependHandler handler = (DependHandler)jc.getClientProperty(DependHandler.class);
            if (handler == null || handler.getName() == null || !handler.getName().equals(name)) continue;
            handler.setSource(source);
            handler.valueChanged(name, value);
        }
    }

    void focusComponent(String name) {
        for (JComponent jc : this.components) {
            if (jc.getName() == null || !jc.getName().equals(name)) continue;
            jc.requestFocus();
            jc.grabFocus();
            break;
        }
    }

    private Object getValue(Object source, String name) {
        if (source == null) {
            return null;
        }
        Method m = this.findGetterMethod(source, name);
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(source, new Object[0]);
        }
        catch (Exception ex) {
            System.out.println("[ERROR] getValue: " + ex.getMessage());
            return null;
        }
    }

    private void setValue(Object source, String name, Object value) {
        Class[] classArray;
        if (source == null || name == null) {
            return;
        }
        Method gm = this.findGetterMethod(source, name);
        if (gm == null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Object.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = gm.getReturnType();
        }
        Class[] paramTypes = classArray;
        Method m = this.findSetterMethod(source, name, paramTypes);
        if (m == null) {
            return;
        }
        try {
            Method setter;
            Class valueType;
            Class<?> objClass = source.getClass();
            Method getter = this.toGetterMethod(objClass, name);
            Class clazz = valueType = getter == null ? Object.class : getter.getReturnType();
            if (valueType != Object.class) {
                if (valueType == Boolean.TYPE || valueType.isAssignableFrom(Boolean.class)) {
                    value = this.toBoolean(value);
                } else if (valueType == Integer.TYPE || valueType.isAssignableFrom(Integer.class)) {
                    value = this.toInt(value);
                } else if (valueType == Double.TYPE || valueType.isAssignableFrom(Double.class)) {
                    value = this.toDouble(value);
                }
            }
            if ((setter = this.toSetterMethod(objClass, name)) == null) {
                return;
            }
            setter.invoke(source, value);
            this.onvalueChanged(name);
        }
        catch (Throwable ex) {
            System.out.println("[ERROR] setValue: (" + name + ") " + ex.getMessage());
        }
    }

    private Method toGetterMethod(Class objClass, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            return objClass.getMethod(methodName, new Class[0]);
        }
        catch (Throwable methodName) {
            try {
                String methodName2 = "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                return objClass.getMethod(methodName2, new Class[0]);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private Method toSetterMethod(Class objClass, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            Method getter = this.toGetterMethod(objClass, name);
            Class returnType = getter == null ? Object.class : getter.getReturnType();
            String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            return objClass.getMethod(methodName, returnType);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void onvalueChanged(String name) {
    }

    private boolean toBoolean(Object value) {
        try {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isBoolean(Object value) {
        return "true".equals(value + "") || "false".equals(value + "");
    }

    private int toInt(Object value) {
        try {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private double toDouble(Object value) {
        try {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    private boolean isInteger(Object value) {
        try {
            Integer.parseInt(value.toString());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Method findGetterMethod(Object source, String name) {
        Method[] methods;
        if (name == null || name.length() == 0) {
            return null;
        }
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method m : methods = source.getClass().getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes() != null && m.getParameterTypes().length != 0) continue;
            return m;
        }
        methodName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method m : methods) {
            if (!m.getName().equals(methodName) || m.getParameterTypes() != null && m.getParameterTypes().length != 0) continue;
            return m;
        }
        return null;
    }

    private Method findSetterMethod(Object source, String name, Class[] paramTypes) {
        Method[] methods;
        if (name == null || name.length() == 0) {
            return null;
        }
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method m : methods = source.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            Class<?>[] sourceTypes = m.getParameterTypes();
            if (sourceTypes == null) {
                sourceTypes = new Class[]{};
            }
            if (sourceTypes.length != paramTypes.length) continue;
            for (int i = 0; i < sourceTypes.length; ++i) {
                if (sourceTypes[i] == paramTypes[i]) continue;
            }
            return m;
        }
        return null;
    }

    public static class DependHandler {
        private String name;
        private JComponent editor;
        private JComponent source;

        public DependHandler(String name, JComponent editor) {
            this.name = name;
            this.editor = editor;
        }

        public void setSource(JComponent source) {
            this.source = source;
        }

        public String getName() {
            return this.name;
        }

        public void valueChanged(String name, Object value) {
            if (this.source instanceof JCheckBox) {
                boolean b = "true".equals(value + "");
                this.editor.setEnabled(b);
            }
        }
    }

    private class ComboItemHandler
    implements ItemListener {
        private ComboItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JComponent jcomp = (JComponent)e.getSource();
            if (jcomp instanceof IComponentView) {
                return;
            }
            if (jcomp instanceof IComponent) {
                JComponent jpage = (JComponent)jcomp.getClientProperty("PAGE");
                Column source = jpage == null ? ColumnEditorController.this.column : ColumnEditorController.this.column.getTypeHandler();
                IComponent icomp = (IComponent)((Object)jcomp);
                if (icomp.isUpdateable()) {
                    ColumnEditorController.this.setValue(source, icomp.getName(), icomp.getValue());
                }
            }
        }
    }

    private class CheckItemHandler
    implements ItemListener {
        private CheckItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JComponent jcomp = (JComponent)e.getSource();
            if (jcomp instanceof IComponentView) {
                return;
            }
            if (jcomp instanceof IComponent) {
                JComponent jpage = (JComponent)jcomp.getClientProperty("PAGE");
                Column source = jpage == null ? ColumnEditorController.this.column : ColumnEditorController.this.column.getTypeHandler();
                IComponent icomp = (IComponent)((Object)jcomp);
                if (icomp.isUpdateable()) {
                    ColumnEditorController.this.setValue(source, icomp.getName(), icomp.getValue());
                }
            }
        }
    }

    private class InputVerifierImpl
    extends InputVerifier {
        private InputVerifierImpl() {
        }

        @Override
        public boolean verify(JComponent input) {
            IComponent icomp;
            Column source;
            if (input instanceof IComponentView) {
                return true;
            }
            JComponent jpage = (JComponent)input.getClientProperty("PAGE");
            Object object = source = jpage == null ? ColumnEditorController.this.column : ColumnEditorController.this.column.getTypeHandler();
            if (input instanceof IComponent && (icomp = (IComponent)((Object)input)).isUpdateable()) {
                ColumnEditorController.this.setValue(source, icomp.getName(), icomp.getValue());
            }
            return true;
        }
    }

    private class TextFieldSupport
    extends InputVerifier {
        private JTextComponent editor;
        private Class valueType;

        TextFieldSupport(JTextComponent editor, Class valueType) {
            this.editor = editor;
            this.valueType = valueType;
        }

        @Override
        public boolean verify(JComponent input) {
            Number num;
            Object value = null;
            if (input instanceof JTextComponent) {
                value = ((JTextComponent)input).getText();
            } else if (input instanceof JComboBox) {
                value = ((JComboBox)input).getSelectedItem();
            }
            if (this.valueType.isAssignableFrom(Integer.class)) {
                num = null;
                try {
                    num = Integer.parseInt(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.valueType.isPrimitive() && num == null) {
                    num = 0;
                }
                value = num;
            } else if (this.valueType.isAssignableFrom(Double.class)) {
                num = null;
                try {
                    num = Double.parseDouble(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.valueType.isPrimitive() && num == null) {
                    num = 0.0;
                }
                value = num;
            }
            JComponent jpage = (JComponent)input.getClientProperty("PAGE");
            Column source = jpage == null ? ColumnEditorController.this.column : ColumnEditorController.this.column.getTypeHandler();
            ColumnEditorController.this.setValue(source, input.getName(), value);
            return true;
        }
    }
}

