/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor.table;

import com.rameses.beaninfo.editor.table.ColumnEditorController;
import com.rameses.beaninfo.editor.table.ColumnEditorModel;
import com.rameses.rcp.common.Column;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class ColumnDataTable
extends JTable {
    private ColumnEditorModel model;
    private ColumnEditorController controller;

    public ColumnEditorModel getEditorModel() {
        return this.model;
    }

    public void setEditorModel(ColumnEditorModel model) {
        this.model = model;
        super.setModel(model);
    }

    public ColumnEditorController getEditorController() {
        return this.controller;
    }

    public void setEditorController(ColumnEditorController controller) {
        this.controller = controller;
    }

    public void selectRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.model.getRowCount()) {
            Point selPoint = (Point)this.getClientProperty("selectionPoint");
            if (selPoint == null) {
                selPoint = new Point();
            }
            this.changeSelection(rowIndex, selPoint.x, false, false);
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int oldRowIndex = this.getSelectedRow();
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.putClientProperty("selectionPoint", new Point(columnIndex, rowIndex));
        if (oldRowIndex != rowIndex) {
            this.onrowChanged();
        }
    }

    private void onrowChanged() {
        Column col = this.model.getItem(this.getSelectedRow());
        this.refresh(col);
    }

    public void refresh(Column col) {
        try {
            this.controller.setColumn(col);
            this.controller.setEnableComponents(col != null);
            this.controller.refresh();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showError(ex);
        }
    }

    private void showError(Throwable t) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = kfm.getActiveWindow();
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        JOptionPane.showMessageDialog(window, errmsg, "ERROR", 0);
    }
}

