/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor;

import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FieldTypePropertyEditor
extends PropertyEditorSupport {
    private String[] values = new String[]{"BigDecimal", "BigInteger", "Double", "Float", "Integer", "double", "int"};

    @Override
    public String[] getTags() {
        return this.values;
    }

    @Override
    public String getJavaInitializationString() {
        String text = this.getAsText();
        if (text == null) {
            return null;
        }
        if (this.values[0].equals(text)) {
            return BigDecimal.class.getName() + ".class";
        }
        if (this.values[1].equals(text)) {
            return BigInteger.class.getName() + ".class";
        }
        if (this.values[2].equals(text)) {
            return Double.class.getName() + ".class";
        }
        if (this.values[3].equals(text)) {
            return Float.class.getName() + ".class";
        }
        if (this.values[4].equals(text)) {
            return Integer.class.getName() + ".class";
        }
        if (this.values[5].equals(text)) {
            return "double.class";
        }
        if (this.values[6].equals(text)) {
            return "int.class";
        }
        return null;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (BigDecimal.class.equals(value)) {
            return this.values[0];
        }
        if (BigInteger.class.equals(value)) {
            return this.values[1];
        }
        if (Double.class.equals(value)) {
            return this.values[2];
        }
        if (Float.class.equals(value)) {
            return this.values[3];
        }
        if (Integer.class.equals(value)) {
            return this.values[4];
        }
        if (Double.TYPE.equals(value)) {
            return this.values[5];
        }
        if (Integer.TYPE.equals(value)) {
            return this.values[6];
        }
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.values[0].equals(text)) {
            this.setValue(BigDecimal.class);
        } else if (this.values[1].equals(text)) {
            this.setValue(BigInteger.class);
        } else if (this.values[2].equals(text)) {
            this.setValue(Double.class);
        } else if (this.values[3].equals(text)) {
            this.setValue(Float.class);
        } else if (this.values[4].equals(text)) {
            this.setValue(Integer.class);
        } else if (this.values[5].equals(text)) {
            this.setValue(Double.TYPE);
        } else if (this.values[6].equals(text)) {
            this.setValue(Integer.TYPE);
        }
    }
}

