/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor;

import com.rameses.beaninfo.editor.table.ColumnEditorPage2;
import com.rameses.rcp.common.ButtonColumnHandler;
import com.rameses.rcp.common.CheckBoxColumnHandler;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.ComboBoxColumnHandler;
import com.rameses.rcp.common.DateColumnHandler;
import com.rameses.rcp.common.DecimalColumnHandler;
import com.rameses.rcp.common.DoubleColumnHandler;
import com.rameses.rcp.common.IconColumnHandler;
import com.rameses.rcp.common.IntegerColumnHandler;
import com.rameses.rcp.common.LabelColumnHandler;
import com.rameses.rcp.common.LookupColumnHandler;
import com.rameses.rcp.common.OpenerColumnHandler;
import com.rameses.rcp.common.TextColumnHandler;
import com.rameses.rcp.constant.TextCase;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class ColumnPropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private ColumnEditorPage2 page = new ColumnEditorPage2();
    private Column[] columns;

    public ColumnPropertyEditor() {
        this.page.setPropertyEditor(this);
    }

    @Override
    public Object getValue() {
        return this.columns;
    }

    @Override
    public void setValue(Object value) {
        Column[] oldColumns = (Column[])value;
        if (oldColumns != null) {
            this.columns = new Column[oldColumns.length];
            for (int i = 0; i < oldColumns.length; ++i) {
                this.columns[i] = this.createColumn(oldColumns[i]);
            }
        } else {
            this.columns = null;
        }
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.page;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public String getJavaInitializationString() {
        if (this.columns == null || this.columns.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("new " + Column.class.getName() + "[]{");
        for (int i = 0; i < this.columns.length; ++i) {
            Column c = this.columns[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\n new " + Column.class.getName() + "(new Object[]{");
            sb.append("\n new Object[]{\"name\", " + this.getStringFormat(c.getName()) + "}");
            sb.append("\n, new Object[]{\"caption\", " + this.getStringFormat(c.getCaption()) + "}");
            sb.append("\n, new Object[]{\"width\", " + c.getWidth() + "}");
            sb.append("\n, new Object[]{\"minWidth\", " + c.getMinWidth() + "}");
            sb.append("\n, new Object[]{\"maxWidth\", " + c.getMaxWidth() + "}");
            sb.append("\n, new Object[]{\"required\", " + c.isRequired() + "}");
            sb.append("\n, new Object[]{\"resizable\", " + c.isResizable() + "}");
            sb.append("\n, new Object[]{\"nullWhenEmpty\", " + c.isNullWhenEmpty() + "}");
            sb.append("\n, new Object[]{\"editable\", " + c.isEditable() + "}");
            if (c.isEditable()) {
                sb.append("\n, new Object[]{\"editableWhen\", " + this.getStringFormat(c.getEditableWhen()) + "}");
            }
            sb.append("\n, new Object[]{\"visible\", " + c.isVisible() + "}");
            if (c.isVisible()) {
                sb.append("\n, new Object[]{\"visibleWhen\", " + this.getStringFormat(c.getVisibleWhen()) + "}");
            }
            if (c.getAlignment() != null) {
                sb.append("\n, new Object[]{\"alignment\", " + this.getStringFormat(c.getAlignment()) + "}");
            }
            if (c.getTextCase() != null) {
                sb.append("\n, new Object[]{\"textCase\", " + this.getTextCaseFormat(c.getTextCase()) + "}");
            }
            if (c.getExpression() != null) {
                sb.append("\n, new Object[]{\"expression\", " + this.getStringFormat(c.getExpression()) + "}");
            }
            if (c.getTypeHandler() != null) {
                sb.append("\n, new Object[]{\"typeHandler\", " + this.getInitString(c.getTypeHandler()) + "}");
            }
            sb.append("\n})");
        }
        sb.append("\n}");
        return sb.toString();
    }

    private String getInitString(Column.TypeHandler typeHandler) {
        StringBuffer sb = new StringBuffer();
        if (typeHandler instanceof CheckBoxColumnHandler) {
            CheckBoxColumnHandler chk = (CheckBoxColumnHandler)typeHandler;
            sb.append("new " + chk.getClass().getName() + "(");
            if (chk.getValueType() == Integer.class) {
                sb.append(Integer.class.getName() + ".class, " + chk.getCheckValue() + ", " + chk.getUncheckValue());
            } else if (chk.getValueType() == String.class) {
                sb.append(String.class.getName() + ".class, " + this.convertString(chk.getCheckValue()) + ", " + this.convertString(chk.getUncheckValue()));
            } else {
                sb.append(Boolean.class.getName() + ".class, " + chk.getCheckValue() + ", " + chk.getUncheckValue());
            }
            sb.append(")");
        } else if (typeHandler instanceof ComboBoxColumnHandler) {
            ComboBoxColumnHandler combo = (ComboBoxColumnHandler)typeHandler;
            sb.append("new " + combo.getClass().getName() + "(");
            sb.append(this.convertString(combo.getItems()) + ", " + this.convertString(combo.getItemKey()) + ", " + this.convertString(combo.getExpression()));
            sb.append(")");
        } else if (typeHandler instanceof DateColumnHandler) {
            DateColumnHandler date = (DateColumnHandler)typeHandler;
            sb.append("new " + date.getClass().getName() + "(");
            sb.append(this.convertString(date.getInputFormat()) + ", " + this.convertString(date.getOutputFormat()) + ", " + this.convertString(date.getValueFormat()));
            sb.append(")");
        } else if (typeHandler instanceof DecimalColumnHandler) {
            DecimalColumnHandler dec = (DecimalColumnHandler)typeHandler;
            sb.append("new " + dec.getClass().getName() + "(");
            sb.append(this.convertString(dec.getFormat()));
            sb.append(", " + dec.getMinValue() + ", " + dec.getMaxValue());
            sb.append(", " + dec.isUsePrimitiveValue() + ", " + dec.getScale());
            sb.append(")");
        } else if (typeHandler instanceof DoubleColumnHandler) {
            DoubleColumnHandler num = (DoubleColumnHandler)typeHandler;
            sb.append("new " + num.getClass().getName() + "(");
            sb.append(this.convertString(num.getFormat()) + ", " + num.getMinValue() + ", " + num.getMaxValue());
            sb.append(")");
        } else if (typeHandler instanceof IntegerColumnHandler) {
            IntegerColumnHandler num = (IntegerColumnHandler)typeHandler;
            sb.append("new " + num.getClass().getName() + "(");
            sb.append(this.convertString(num.getFormat()) + ", " + num.getMinValue() + ", " + num.getMaxValue());
            sb.append(")");
        } else if (typeHandler instanceof LabelColumnHandler) {
            LabelColumnHandler lch = (LabelColumnHandler)typeHandler;
            sb.append("new " + lch.getClass().getName() + "()");
        } else if (typeHandler instanceof LookupColumnHandler) {
            LookupColumnHandler lkp = (LookupColumnHandler)typeHandler;
            sb.append("new " + lkp.getClass().getName() + "(");
            sb.append(this.convertString(lkp.getExpression()) + ", " + this.convertString(lkp.getHandler()));
            sb.append(")");
        } else if (typeHandler instanceof OpenerColumnHandler) {
            OpenerColumnHandler handler = (OpenerColumnHandler)typeHandler;
            sb.append("new " + handler.getClass().getName() + "(");
            sb.append(this.convertString(handler.getExpression()) + ", " + this.convertString(handler.getHandler()));
            sb.append(")");
        } else if (typeHandler instanceof ButtonColumnHandler) {
            ButtonColumnHandler handler = (ButtonColumnHandler)typeHandler;
            sb.append("new " + handler.getClass().getName() + "(");
            sb.append(this.convertString(handler.getVisibleWhen())).append(", ");
            sb.append(this.convertString(handler.getAction())).append(", ");
            sb.append(this.convertString(handler.getTag()));
            sb.append(")");
        } else if (typeHandler instanceof IconColumnHandler) {
            IconColumnHandler lch = (IconColumnHandler)typeHandler;
            sb.append("new " + lch.getClass().getName() + "()");
        } else {
            sb.append("new " + TextColumnHandler.class.getName() + "()");
        }
        return sb.toString();
    }

    private String convertString(Object value) {
        if (value == null) {
            return null;
        }
        return "\"" + value + "\"";
    }

    private Column createColumn(Column oldColumn) {
        Column newColumn = new Column(oldColumn.getName(), oldColumn.getCaption(), oldColumn.getWidth(), oldColumn.getMinWidth(), oldColumn.getMaxWidth(), oldColumn.isRequired(), oldColumn.isResizable(), oldColumn.isNullWhenEmpty(), oldColumn.isEditable(), oldColumn.getEditableWhen(), oldColumn.getTypeHandler());
        newColumn.setAlignment(oldColumn.getAlignment());
        newColumn.setTextCase(oldColumn.getTextCase());
        newColumn.setExpression(oldColumn.getExpression());
        newColumn.setVisible(oldColumn.isVisible());
        newColumn.setVisibleWhen(oldColumn.getVisibleWhen());
        return newColumn;
    }

    private String getStringFormat(Object value) {
        return value == null ? null : "\"" + value + "\"";
    }

    private String getTextCaseFormat(TextCase value) {
        return value == null ? null : TextCase.class.getName() + "." + value;
    }
}

