/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class ColorPropertyEditor
extends PropertyEditorSupport {
    private JPanel panel;
    private JPanel colorField;
    private Color color = Color.white;

    public ColorPropertyEditor() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.colorField = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(15, 15);
            }
        };
        this.colorField.setBackground(this.color);
        this.panel.add(this.colorField);
        JButton button = new JButton("Choose");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPropertyEditor.this.color = JColorChooser.showDialog(ColorPropertyEditor.this.panel, "Color Chooser", ColorPropertyEditor.this.color);
            }
        });
        this.panel.add(button);
    }

    @Override
    public void setValue(Object value) {
        this.color = new Color(((Color)value).getRGB());
        this.colorField.setBackground(this.color);
        this.colorField.repaint();
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics g, Rectangle r) {
    }

    @Override
    public String getAsText() {
        return "red";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    static {
        String[] path = PropertyEditorManager.getEditorSearchPath();
        String[] newPath = new String[path.length + 1];
        newPath[0] = "com.rameses.rcp.ui.editors";
        System.arraycopy(path, 0, newPath, 1, path.length);
        PropertyEditorManager.setEditorSearchPath(newPath);
        for (int i = 0; i < newPath.length; ++i) {
            System.err.println(newPath[i]);
        }
        PropertyEditorManager.registerEditor(new Color(10).getClass(), null);
        PropertyEditorManager.registerEditor(new Color(10).getClass(), ColorPropertyEditor.class);
    }
}

