/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo.editor;

import java.beans.PropertyEditorSupport;

public abstract class AbstractEnumPropertyEditor
extends PropertyEditorSupport {
    private Class<? extends Enum> enumClass = this.getEnumClass();

    protected abstract Class<? extends Enum> getEnumClass();

    @Override
    public String[] getTags() {
        Enum[] objs = this.enumClass.getEnumConstants();
        String[] arr = new String[objs.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = objs[i].toString();
        }
        return arr;
    }

    @Override
    public String getAsText() {
        Object o = this.getValue();
        return o != null ? o.toString() : null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(Enum.valueOf(this.enumClass, text));
        }
        catch (Exception ex) {
            this.setValue(null);
        }
    }

    @Override
    public String getJavaInitializationString() {
        try {
            Object o = this.getValue();
            if (o == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.enumClass.getName() + "." + o);
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

