/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.beaninfo;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class AbstractBeanInfo
extends SimpleBeanInfo {
    private Class beanClass = this.getBeanClass();
    private BeanDescriptor beanDescriptor = new BeanDescriptor(this.beanClass);
    private PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[0];

    public AbstractBeanInfo() {
        this.reflectClassProperties();
        this.init(this.beanDescriptor);
    }

    public abstract Class getBeanClass();

    public abstract void init(BeanDescriptor var1);

    public abstract void property(String var1, PropertyDescriptor var2);

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    private void reflectClassProperties() {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        Method[] methods = this.beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            PropertyDescriptor desc;
            String propertyName2;
            Method mm;
            Method m = methods[i];
            if (m.getParameterTypes() == null || m.getParameterTypes().length != 0) continue;
            String name = m.getName();
            if (name.startsWith("is") && name.length() > 2) {
                mm = this.findSetterMethod("set" + name.substring(2), Boolean.TYPE);
                if (mm == null) continue;
                try {
                    propertyName2 = this.formatPropertyName(name.substring(2));
                    desc = new PropertyDescriptor(propertyName2, m, mm);
                    this.property(propertyName2, desc);
                    list.add(desc);
                }
                catch (IntrospectionException propertyName2) {}
                continue;
            }
            if (!name.startsWith("get") || name.length() <= 3 || (mm = this.findSetterMethod("set" + name.substring(3), m.getReturnType())) == null) continue;
            try {
                propertyName2 = this.formatPropertyName(name.substring(3));
                desc = new PropertyDescriptor(propertyName2, m, mm);
                this.property(propertyName2, desc);
                list.add(desc);
                continue;
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        this.propertyDescriptors = list.toArray(new PropertyDescriptor[0]);
    }

    private Method findSetterMethod(String name, Class paramType) {
        try {
            return this.beanClass.getMethod(name, paramType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String formatPropertyName(String propertyName) {
        if (propertyName.length() == 1) {
            return propertyName.toLowerCase();
        }
        return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
    }
}

