/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.WebsocketModel;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationManager;
import com.rameses.util.Base64Cipher;
import com.rameses.util.MessageObject;
import java.net.URI;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;

public class WebsocketClient {
    private static final ExecutorService THREAD_POOL = Executors.newFixedThreadPool(100);
    private static final int MAX_BINARY_MESSAGE_SIZE = 16384;
    private String connectionid;
    private WebsocketModel model;
    private WebsocketConnectionImpl wsconn;
    private DesktopServiceImpl serviceImpl;

    public static Handle open(Map options) {
        return new WebsocketClient(options).openImpl();
    }

    public static Handle open(WebsocketModel model) {
        return new WebsocketClient(model).openImpl();
    }

    private WebsocketClient() {
        this(new WebsocketModel());
    }

    private WebsocketClient(WebsocketModel model) {
        this.model = model == null ? new WebsocketModel() : model;
        this.init();
    }

    private WebsocketClient(Map options) {
        this.model = new WebsocketModelProxy(options);
        this.init();
    }

    private void init() {
        this.connectionid = "rcpws" + new UID();
        this.wsconn = new WebsocketConnectionImpl();
        this.serviceImpl = new DesktopServiceImpl();
    }

    private Handle openImpl() {
        this.wsconn.initialize();
        return new Handle(this);
    }

    public void close() {
        if (this.wsconn == null) {
            throw new RuntimeException("This instance has already been closed. Try opening another websocket client.");
        }
        this.wsconn.close();
        this.wsconn = null;
        this.model = null;
    }

    private class SendMessageProcess
    implements Runnable {
        private Object data;
        private NotificationHandler handler;

        SendMessageProcess(NotificationHandler handler, Object data) {
            this.handler = handler;
            this.data = data;
        }

        public void run() {
            if (this.handler != null && this.data != null) {
                this.handler.onMessage(this.data);
            }
        }
    }

    public static final class Handle {
        private WebsocketClient wsclient;

        Handle(WebsocketClient wsclient) {
            this.wsclient = wsclient;
        }

        public void close() {
            if (this.wsclient != null) {
                this.wsclient.close();
            }
        }
    }

    private class DesktopServiceImpl
    implements ClientContext.DesktopService {
        WebsocketClient root;

        private DesktopServiceImpl() {
            this.root = WebsocketClient.this;
        }

        void register() {
            ClientContext.getCurrentContext().getServices().add((ClientContext.DesktopService)this);
        }

        void unregister() {
            ClientContext.getCurrentContext().getServices().remove((ClientContext.DesktopService)this);
        }

        public void start() {
        }

        public void stop() {
            if (this.root.wsconn != null) {
                this.root.close();
            }
        }
    }

    private class WebsocketConnectionImpl
    implements WebSocket.OnTextMessage,
    WebSocket.OnBinaryMessage {
        WebsocketClient root;
        private WebSocketClientFactory factory;
        private WebSocketClient wsclient;
        private WebSocket.Connection connection;
        private String protocol;
        private boolean has_started;
        private boolean cancelled;

        private WebsocketConnectionImpl() {
            this.root = WebsocketClient.this;
        }

        void initialize() {
            this.initFactory();
            this.root.serviceImpl.register();
            Runnable runnable = new Runnable(){

                public void run() {
                    WebsocketConnectionImpl.this.connect();
                }
            };
            new Thread(runnable).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            this.cancelled = true;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Throwable t) {
                    System.out.println("[WebsocketClient] connection close error caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                finally {
                    this.connection = null;
                }
                try {
                    this.factory.stop();
                }
                catch (Throwable t) {
                    System.out.println("[WebsocketClient] factory stop error caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                finally {
                    this.factory = null;
                    this.wsclient = null;
                }
            }
            if (this.root.model != null) {
                WebsocketModel old = this.root.model;
                this.root.model = null;
                old.onclose();
            }
            if (this.root.serviceImpl != null) {
                DesktopServiceImpl impl = this.root.serviceImpl;
                this.root.serviceImpl = null;
                impl.unregister();
            }
        }

        private void initFactory() {
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("connectionid", WebsocketClient.this.connectionid);
                String encstr = new Base64Cipher().encode(headers);
                this.protocol = this.root.model.getProtocol();
                this.factory = new WebSocketClientFactory();
                this.factory.start();
                this.wsclient = this.factory.newWebSocketClient();
                this.wsclient.setProtocol(this.protocol + ";" + encstr);
                this.wsclient.setMaxBinaryMessageSize(16384);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private void connect() {
            try {
                String host = this.root.model.getHost();
                if (!host.startsWith("ws")) {
                    host = "ws://" + host;
                }
                int maxConnection = this.root.model.getMaxConnection();
                this.wsclient.open(new URI(host), (WebSocket)this, (long)maxConnection, TimeUnit.MILLISECONDS);
                if (!this.has_started) {
                    this.has_started = true;
                    this.invokeOnstart();
                }
            }
            catch (InterruptedException ie) {
                System.out.println("[WebsocketClient] failed to open caused by " + ie.getClass() + ": " + ie.getMessage());
            }
            catch (Exception e) {
                System.out.println("[WebsocketClient] failed to open caused by " + e.getClass() + ": " + e.getMessage());
                try {
                    Thread.sleep(this.root.model.getReconnectDelay());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connect();
            }
        }

        public void onOpen(WebSocket.Connection connection) {
            this.connection = connection;
            connection.setMaxIdleTime(this.root.model.getMaxIdleTime());
        }

        public void onClose(int closeCode, String message) {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
                if (closeCode == 1006) {
                    try {
                        this.factory.stop();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        this.initFactory();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    closeCode = 1000;
                }
                if (closeCode == 1000) {
                    try {
                        if (!this.cancelled) {
                            this.connect();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }

        public void onMessage(String data) {
            this.notify(data);
        }

        public void onMessage(byte[] bytes, int offset, int length) {
            try {
                MessageObject mo = new MessageObject().decrypt(bytes, offset, length);
                if (WebsocketClient.this.connectionid.equals(mo.getConnectionId())) {
                    return;
                }
                Object data = mo.getData();
                if (data != null) {
                    this.notify(data);
                }
            }
            catch (Throwable t) {
                System.out.println("[WebsocketClient, " + this.protocol + "] onMessage error caused by " + t.getClass().getName() + ": " + t.getMessage());
                t.printStackTrace();
            }
        }

        private void notify(Object data) {
            try {
                this.root.model.onmessage(data);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            List list = new ArrayList();
            try {
                list = NotificationManager.getHandlers();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                try {
                    THREAD_POOL.submit(new SendMessageProcess((NotificationHandler)list.get(i), data));
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }

        private void invokeOnstart() {
            try {
                this.root.model.onstart();
            }
            catch (Throwable t) {
                System.out.println("onstart error caused by " + t.getClass().getName() + ": " + t.getMessage());
            }
        }
    }

    private class WebsocketModelProxy
    extends WebsocketModel {
        private Map options;
        private String host;
        private String protocol;
        private Integer maxConnection;
        private Integer reconnectDelay;
        private Integer maxIdleTime;
        private CallbackHandlerProxy onstartHandler;
        private CallbackHandlerProxy onmessageHandler;
        private CallbackHandlerProxy onreadHandler;
        private CallbackHandlerProxy oncloseHandler;

        WebsocketModelProxy(Map options) {
            this.options = options;
            this.host = this.getString(options, "host");
            this.protocol = this.getString(options, "protocol");
            this.maxConnection = this.getInt(options, "maxConnection");
            this.reconnectDelay = this.getInt(options, "reconnectDelay");
            this.maxIdleTime = this.getInt(options, "maxIdleTime");
            Object source = this.get(options, "onmessage");
            if (source != null) {
                this.onmessageHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onread")) != null) {
                this.onreadHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onstart")) != null) {
                this.onstartHandler = new CallbackHandlerProxy(source);
            }
        }

        public String getHost() {
            if (this.host != null && this.host.length() > 0) {
                return this.host;
            }
            return super.getHost();
        }

        public String getProtocol() {
            if (this.protocol != null && this.protocol.length() > 0) {
                return this.protocol;
            }
            return super.getProtocol();
        }

        public int getMaxConnection() {
            if (this.maxConnection != null) {
                return this.maxConnection;
            }
            return super.getMaxConnection();
        }

        public int getReconnectDelay() {
            if (this.reconnectDelay != null) {
                return this.reconnectDelay;
            }
            return super.getReconnectDelay();
        }

        public int getMaxIdleTime() {
            if (this.maxIdleTime != null) {
                return this.maxIdleTime;
            }
            return super.getMaxIdleTime();
        }

        public void onmessage(Object data) {
            if (this.onmessageHandler == null) {
                return;
            }
            this.onmessageHandler.call(data);
        }

        public void onread(Object data) {
            if (this.onreadHandler == null) {
                return;
            }
            this.onreadHandler.call(data);
        }

        public void onclose() {
            if (this.oncloseHandler == null) {
                return;
            }
            this.oncloseHandler.call();
        }

        public void onstart() {
            if (this.onstartHandler == null) {
                return;
            }
            this.onstartHandler.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Boolean getBool(Map map, String name) {
            try {
                return (Boolean)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }
}

