/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.client.notification.GroupNotificationService;
import com.rameses.client.notification.UserNotificationService;
import com.rameses.rcp.annotations.NotificationService;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.DependencyHandler;
import com.rameses.rcp.framework.NotificationProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class NotificationServiceDependencyHandler
implements DependencyHandler {
    public Class getAnnotation() {
        return NotificationService.class;
    }

    public Object getResource(Binding binding) {
        return new RuntimeHandle(binding);
    }

    private String getBeanValueAsString(Object bean, String name) {
        Object value = this.getBeanValue(bean, name);
        return value == null ? null : value.toString();
    }

    private Object getBeanValue(Object bean, String name) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        Class<?> beanClass = bean.getClass();
        Method method = this.findGetMethod(beanClass, "notificationid");
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("failed to get value from method [" + method + "] caused by " + t.getMessage());
            return null;
        }
    }

    private Method findGetMethod(Class clazz, String name) {
        try {
            if (name == null || name.length() <= 3) {
                return null;
            }
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            for (Method method : clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(methodName) || "void".equals(method.getReturnType().toString()) || (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 1) continue;
                return method;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private NotificationProvider getProvider() {
        return ClientContext.getCurrentContext().getNotificationProvider();
    }

    public class RuntimeHandle {
        NotificationServiceDependencyHandler root;
        private Binding binding;

        RuntimeHandle(Binding binding) {
            this.root = NotificationServiceDependencyHandler.this;
            this.binding = binding;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public NotificationProvider getProvider() {
            return this.root.getProvider();
        }

        public void sendMessage(Object data) {
            this.getProvider().sendMessage(data);
        }

        public void removeMessage(Object data) {
            if (data == null) {
                return;
            }
            String type = this.root.getBeanValueAsString(data, "type");
            String objid = this.root.getBeanValueAsString(data, "objid");
            String notificationid = this.root.getBeanValueAsString(data, "notificationid");
            String groupid = this.root.getBeanValueAsString(data, "groupid");
            String recipientid = this.root.getBeanValueAsString(data, "recipientid");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("objid", objid);
            params.put("notificationid", notificationid);
            if (recipientid != null && recipientid.trim().length() > 0) {
                new UserNotificationService().removeMessage(params);
            } else if (groupid != null && groupid.trim().length() > 0) {
                new GroupNotificationService().removeMessage(params);
            }
            this.getProvider().removeMessage(data);
        }
    }
}

