/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.client.notification.GroupNotificationService;
import com.rameses.client.notification.UserNotificationService;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NotificationProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class NotificationService {
    private NotificationService() {
    }

    public static NotificationProvider getProvider() {
        return ClientContext.getCurrentContext().getNotificationProvider();
    }

    public static synchronized void sendMessage(Object data) {
        NotificationService.getProvider().sendMessage(data);
    }

    public static synchronized void removeMessage(Object data) {
        if (data == null) {
            return;
        }
        String objid = NotificationService.getBeanValueAsString(data, "objid");
        String notificationid = NotificationService.getBeanValueAsString(data, "notificationid");
        String recipientid = NotificationService.getBeanValueAsString(data, "recipientid");
        String groupid = NotificationService.getBeanValueAsString(data, "groupid");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objid", objid);
        params.put("notificationid", notificationid);
        if (recipientid != null && recipientid.trim().length() > 0) {
            new UserNotificationService().removeMessage(params);
        } else if (groupid != null && groupid.trim().length() > 0) {
            new GroupNotificationService().removeMessage(params);
        }
        NotificationService.getProvider().removeMessage(data);
    }

    private static String getBeanValueAsString(Object bean, String name) {
        Object value = NotificationService.getBeanValue(bean, name);
        return value == null ? null : value.toString();
    }

    private static Object getBeanValue(Object bean, String name) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        Class<?> beanClass = bean.getClass();
        Method method = NotificationService.findGetMethod(beanClass, "notificationid");
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("failed to get value from method [" + method + "] caused by " + t.getMessage());
            return null;
        }
    }

    private static Method findGetMethod(Class clazz, String name) {
        try {
            if (name == null || name.length() <= 3) {
                return null;
            }
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            for (Method method : clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(methodName) || "void".equals(method.getReturnType().toString()) || (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 1) continue;
                return method;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

