/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationProvider;
import java.util.ArrayList;
import java.util.List;

public final class NotificationProviderImpl
implements NotificationProvider {
    private static Object LOCK = new Object();
    private List<NotificationHandler> handlers = new ArrayList<NotificationHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = LOCK;
        synchronized (object) {
            this.handlers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NotificationHandler handler) {
        Object object = LOCK;
        synchronized (object) {
            if (handler == null) {
                return;
            }
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(NotificationHandler handler) {
        Object object = LOCK;
        synchronized (object) {
            if (handler == null) {
                return false;
            }
            return this.handlers.remove(handler);
        }
    }

    public void sendMessage(Object data) {
        new Thread(new NotifyProcess(this.handlers, data)).start();
    }

    public void removeMessage(Object data) {
        new Thread(new ReadProcess(this.handlers, data)).start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadProcess
    implements Runnable {
        private List<NotificationHandler> handlers;
        private Object data;

        ReadProcess(List<NotificationHandler> handlers, Object data) {
            this.handlers = handlers;
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LOCK;
            synchronized (object) {
                if (this.handlers == null) {
                    return;
                }
                for (int i = 0; i < this.handlers.size(); ++i) {
                    NotificationHandler handler = this.handlers.get(i);
                    if (handler == null) continue;
                    try {
                        handler.onRead(this.data);
                        continue;
                    }
                    catch (Throwable t) {
                        System.out.println("handler error onMessage caused by " + t.getMessage());
                    }
                }
                this.handlers = null;
                this.data = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NotifyProcess
    implements Runnable {
        private List<NotificationHandler> handlers;
        private Object data;

        NotifyProcess(List<NotificationHandler> handlers, Object data) {
            this.handlers = handlers;
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LOCK;
            synchronized (object) {
                if (this.handlers == null) {
                    return;
                }
                for (int i = 0; i < this.handlers.size(); ++i) {
                    NotificationHandler handler = this.handlers.get(i);
                    if (handler == null) continue;
                    try {
                        handler.onMessage(this.data);
                        continue;
                    }
                    catch (Throwable t) {
                        System.out.println("handler error onMessage caused by " + t.getMessage());
                    }
                }
                this.handlers = null;
                this.data = null;
            }
        }
    }
}

