/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.client.notification.GroupNotificationService;
import com.rameses.client.notification.UserNotificationService;
import com.rameses.rcp.annotations.Notification;
import com.rameses.rcp.common.CallbackHandler;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.DependencyHandler;
import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class NotificationDependencyHandler
implements DependencyHandler {
    public Class getAnnotation() {
        return Notification.class;
    }

    public Object getResource(Binding binding) {
        return new RuntimeNotificationHandle(binding);
    }

    private String getBeanValueAsString(Object bean, String name) {
        Object value = this.getBeanValue(bean, name);
        return value == null ? null : value.toString();
    }

    private Object getBeanValue(Object bean, String name) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        Class<?> beanClass = bean.getClass();
        Method method = this.findGetMethod(beanClass, "notificationid");
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("failed to get value from method [" + method + "] caused by " + t.getMessage());
            return null;
        }
    }

    private Method findGetMethod(Class clazz, String name) {
        try {
            if (name == null || name.length() <= 3) {
                return null;
            }
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            for (Method method : clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(methodName) || "void".equals(method.getReturnType().toString()) || (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 1) continue;
                return method;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private NotificationProvider getProvider() {
        return ClientContext.getCurrentContext().getNotificationProvider();
    }

    private class HandlerProxy
    implements NotificationHandler {
        private Map options;
        private CallbackHandlerProxy onmessageHandler;
        private CallbackHandlerProxy onreadHandler;
        private CallbackHandlerProxy oncloseHandler;
        private boolean cancelled;

        HandlerProxy(Map options) {
            this.options = options;
            Object source = this.get(options, "onmessage");
            if (source != null) {
                this.onmessageHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onread")) != null) {
                this.onreadHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseHandler = new CallbackHandlerProxy(source);
            }
        }

        public void onMessage(Object data) {
            if (this.cancelled || this.onmessageHandler == null) {
                return;
            }
            this.onmessageHandler.call(data);
        }

        public void onRead(Object data) {
            if (this.cancelled || this.onreadHandler == null) {
                return;
            }
            this.onreadHandler.call(data);
        }

        public void onClose() {
            if (this.cancelled || this.oncloseHandler == null) {
                return;
            }
            this.oncloseHandler.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Boolean getBool(Map map, String name) {
            try {
                return (Boolean)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }

    public class CloseHandler
    implements CallbackHandler {
        private RuntimeEventHandle event;

        CloseHandler(RuntimeEventHandle event) {
            this.event = event;
        }

        public Object call() {
            this.event.unregister();
            return null;
        }

        public Object call(Object arg) {
            this.event.unregister();
            return null;
        }

        public Object call(Object[] args) {
            this.event.unregister();
            return null;
        }
    }

    public class RuntimeEventHandle {
        NotificationDependencyHandler root;
        private HandlerProxy proxy;

        RuntimeEventHandle(Map options) {
            this.root = NotificationDependencyHandler.this;
            this.proxy = new HandlerProxy(options);
            this.root.getProvider().add((NotificationHandler)this.proxy);
            options.put("close", new CloseHandler(this));
        }

        public void unregister() {
            if (this.proxy == null) {
                return;
            }
            this.proxy.cancelled = true;
            this.root.getProvider().remove((NotificationHandler)this.proxy);
            this.proxy.onClose();
            this.proxy = null;
        }

        public void close() {
            this.unregister();
        }
    }

    public class RuntimeNotificationHandle {
        NotificationDependencyHandler root;
        private Binding binding;

        RuntimeNotificationHandle(Binding binding) {
            this.root = NotificationDependencyHandler.this;
            this.binding = binding;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public NotificationProvider getProvider() {
            return this.root.getProvider();
        }

        public void sendMessage(Object data) {
            this.getProvider().sendMessage(data);
        }

        public void removeMessage(Object data) {
            if (data == null) {
                return;
            }
            String type = this.root.getBeanValueAsString(data, "type");
            String objid = this.root.getBeanValueAsString(data, "objid");
            String notificationid = this.root.getBeanValueAsString(data, "notificationid");
            String groupid = this.root.getBeanValueAsString(data, "groupid");
            String recipientid = this.root.getBeanValueAsString(data, "recipientid");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("objid", objid);
            params.put("notificationid", notificationid);
            if (recipientid != null && recipientid.trim().length() > 0) {
                new UserNotificationService().removeMessage(params);
            } else if (groupid != null && groupid.trim().length() > 0) {
                new GroupNotificationService().removeMessage(params);
            }
            this.getProvider().removeMessage(data);
        }

        public RuntimeEventHandle register(Object callback) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("onmessage", callback);
            return this.register(options);
        }

        public RuntimeEventHandle register(Map options) {
            if (options == null) {
                options = new HashMap();
            }
            return new RuntimeEventHandle(options);
        }
    }
}

