/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.client.notification.DefaultNotificationHandler;
import com.rameses.client.notification.NotificationLoader;
import com.rameses.client.notification.NotificationPopup;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.client.ToolbarUtil;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationManager;
import com.rameses.rcp.framework.NotificationProvider;
import com.rameses.rcp.framework.NotificationRenderer;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.util.OpenerUtil;
import com.rameses.util.ExceptionManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class NotificationButton
extends JButton
implements ActionListener,
ToolbarUtil.CustomAction {
    private ImageIcon defaultIcon;
    private LabelImpl lbl;
    private Map messages;
    private Invoker invoker;
    private UIController controller;
    private static Object LOCK = new Object();
    private NotificationPopup popup;
    private static Object EVENT_LOCK = new Object();

    public NotificationButton() {
        super.addActionListener(this);
        this.setMargin(new Insets(5, 2, 5, 2));
        this.setHorizontalAlignment(2);
        this.defaultIcon = ImageIconSupport.getInstance().getIcon("images/notification-bell.png");
        super.setIcon(this.defaultIcon);
        super.setLayout(new LayoutImpl());
        this.lbl = new LabelImpl();
        this.lbl.setText("");
        this.lbl.setBounds(2, 2, 18, 18);
        this.add(this.lbl);
        this.messages = new LinkedHashMap();
        this.initComponent();
        NotificationManager.addRenderer((NotificationRenderer)new NotificationRendererImpl());
        NotificationProvider np = ClientContext.getCurrentContext().getNotificationProvider();
        if (np != null) {
            np.add((NotificationHandler)new NotificationHandlerImpl());
        }
        Runnable runnable = new Runnable(){

            public void run() {
                NotificationLoader.execute();
                NotificationButton.this.updateCount();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    protected void initComponent() {
    }

    public void addActionListener(ActionListener listener) {
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = this.defaultIcon;
        }
        super.setIcon(icon);
    }

    public void setText(String text) {
        super.setText("");
    }

    private void updateCount() {
        this.lbl.setText(this.messages.size() + "");
        this.revalidate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.showPopup();
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setController(UIController controller) {
        this.controller = controller;
    }

    private String getBeanValueAsString(Object bean, String name) {
        Object value = this.getBeanValue(bean, name);
        return value == null ? null : value.toString();
    }

    private Object getBeanValue(Object bean, String name) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        Class<?> beanClass = bean.getClass();
        Method method = this.findGetMethod(beanClass, "notificationid");
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("failed to get value from method [" + method + "] caused by " + t.getMessage());
            return null;
        }
    }

    private Method findGetMethod(Class clazz, String name) {
        try {
            if (name == null || name.length() <= 3) {
                return null;
            }
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            for (Method method : clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(methodName) || "void".equals(method.getReturnType().toString()) || (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 1) continue;
                return method;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private NotificationPopup getPopup() {
        if (this.popup == null) {
            this.popup = new NotificationPopup(this);
            this.popup.setEventHandler(new EventHandlerImpl());
        }
        return this.popup;
    }

    private void showPopup() {
        Rectangle rect = this.getBounds();
        Point point = this.getLocationOnScreen();
        NotificationPopup popup = this.getPopup();
        popup.setData(this.messages.values());
        popup.pack();
        popup.show(this, 0, rect.height);
    }

    private class NotificationRendererImpl
    implements NotificationRenderer,
    Runnable {
        NotificationButton root;

        private NotificationRendererImpl() {
            this.root = NotificationButton.this;
        }

        public void refresh() {
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            this.root.updateCount();
        }
    }

    private class ShowOpenerProcess
    implements Runnable {
        private Opener opener;

        ShowOpenerProcess(Opener opener) {
            this.opener = opener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = EVENT_LOCK;
            synchronized (object) {
                Object val = this.opener.getProperties().get("has_been_processed");
                if ("true".equals(val + "")) {
                    return;
                }
                this.opener.getProperties().put("has_been_processed", true);
                OpenerUtil.show((Opener)this.opener);
            }
        }
    }

    private class EventHandlerImpl
    implements NotificationPopup.EventHandler {
        NotificationButton root;

        private EventHandlerImpl() {
            this.root = NotificationButton.this;
        }

        public void openItem(Object data) {
            Map datamap;
            Object userobj;
            String filetype = this.root.getBeanValueAsString(data, "filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = "notification-item";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entity", data);
            if (data instanceof Map && (userobj = (datamap = (Map)data).get("data")) instanceof Map) {
                Map userobjmap = (Map)userobj;
                datamap.put("taskid", userobjmap.get("taskid"));
            }
            Opener opener = null;
            try {
                opener = InvokerUtil.lookupOpener((String)(filetype + ":open"), params);
            }
            catch (Exception e) {
                this.root.getPopup().setVisible(false);
                e = ExceptionManager.getOriginal((Exception)e);
                MsgBox.alert((Object)e.getMessage());
                return;
            }
            if (opener == null) {
                return;
            }
            String target = opener.getTarget();
            if (target == null || target.length() == 0) {
                opener.setTarget("window");
            } else if (target.matches("popup|_popup")) {
                opener.setTarget("popup");
                opener.getProperties().put("immediate", true);
            }
            this.root.getPopup().setVisible(false);
            EventQueue.invokeLater(new ShowOpenerProcess(opener));
        }

        public void seeAll() {
            HashMap<String, Map> params = new HashMap<String, Map>();
            params.put("messages", NotificationButton.this.messages);
            Opener opener = null;
            try {
                opener = InvokerUtil.lookupOpener((String)"notification-list:open", params);
            }
            catch (Exception e) {
                this.root.getPopup().setVisible(false);
                e = ExceptionManager.getOriginal((Exception)e);
                MsgBox.alert((Object)e.getMessage());
                return;
            }
            if (opener == null) {
                return;
            }
            opener.setTarget("window");
            opener.getProperties().put("immediate", true);
            this.root.getPopup().setVisible(false);
            EventQueue.invokeLater(new ShowOpenerProcess(opener));
        }
    }

    private class LayoutImpl
    implements LayoutManager,
    LayoutManager2 {
        NotificationButton root;

        private LayoutImpl() {
            this.root = NotificationButton.this;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        private boolean isLabelVisible() {
            if (this.root.lbl == null) {
                return false;
            }
            if (!this.root.lbl.isVisible()) {
                return false;
            }
            String text = this.root.lbl.getText();
            return text != null && text.length() > 0 && !text.equals("0");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Icon icon = this.root.getIcon();
                if (icon != null) {
                    w = icon.getIconWidth();
                    h = icon.getIconHeight();
                }
                if (this.isLabelVisible()) {
                    Dimension dim = this.root.lbl.getPreferredSize();
                    w = Math.max(w / 2 + dim.width, 0);
                    h = Math.max(dim.height + 2, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                if (this.root.lbl == null) {
                    return;
                }
                if (this.isLabelVisible()) {
                    Dimension dim = this.root.lbl.getPreferredSize();
                    int pw = parent.getWidth();
                    int cw = Math.max(dim.width, 12);
                    int px = Math.max(pw - cw, 0);
                    this.root.lbl.setBounds(px, 2, cw, dim.height);
                } else {
                    this.root.lbl.setBounds(0, 0, 0, 0);
                }
            }
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.getLayoutSize(target);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.1f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.1f;
        }

        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }

    private class LabelImpl
    extends JLabel {
        public LabelImpl() {
            this.setOpaque(true);
            this.setBackground(Color.RED);
            this.setForeground(Color.WHITE);
            this.setFont(Font.decode("monospaced-bold-11"));
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.setHorizontalAlignment(0);
        }
    }

    private class NotificationHandlerImpl
    extends DefaultNotificationHandler {
        NotificationButton root;

        private NotificationHandlerImpl() {
            this.root = NotificationButton.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Object data) {
            Object object = LOCK;
            synchronized (object) {
                if (data == null) {
                    return;
                }
                String objid = NotificationButton.this.getBeanValueAsString(data, "notificationid");
                if (objid == null) {
                    return;
                }
                String status = NotificationButton.this.getBeanValueAsString(data, "status");
                if ("REMOVED".equals(status)) {
                    this.remove(objid);
                    return;
                }
                String recipientid = NotificationButton.this.getBeanValueAsString(data, "recipientid");
                if (recipientid == null || recipientid.trim().length() == 0) {
                    return;
                }
                if (this.root.messages.containsKey(objid)) {
                    return;
                }
                this.root.messages.put(objid, data);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        NotificationHandlerImpl.this.root.updateCount();
                        Toolkit.getDefaultToolkit().beep();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRead(Object data) {
            Object object = LOCK;
            synchronized (object) {
                if (data == null) {
                    return;
                }
                String objid = NotificationButton.this.getBeanValueAsString(data, "notificationid");
                if (objid != null) {
                    this.remove(objid);
                }
            }
        }

        private void remove(String objid) {
            if (objid == null) {
                return;
            }
            this.root.messages.remove(objid);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    NotificationHandlerImpl.this.root.updateCount();
                }
            });
        }

        private int indexOf(Object data) {
            if (data == null) {
                return -1;
            }
            String objid = NotificationButton.this.getBeanValueAsString(data, "notificationid");
            for (int i = 0; i < this.root.messages.size(); ++i) {
                Object o = this.root.messages.get(i);
                if (o == null) continue;
                if (o.equals(data)) {
                    return i;
                }
                String sid = NotificationButton.this.getBeanValueAsString(o, "notificationid");
                if (objid == null || !objid.equals(sid)) continue;
                return i;
            }
            return -1;
        }

        private String getString(Map map, String name) {
            Object value = map == null ? null : (Object)map.get(name);
            return value == null ? null : value.toString();
        }
    }
}

