/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.components;

import com.rameses.common.PropertyResolver;
import com.rameses.filemgmt.FileUploadItem;
import com.rameses.filemgmt.FileUploadManager;
import com.rameses.filemgmt.components.FileUploadItemCell;
import com.rameses.rcp.common.FileUploadModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.control.XComponentPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.annotations.ComponentBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

@ComponentBean(value="com.rameses.filemgmt.components.FileUploadPanelModel")
public class FileUploadPanel
extends XComponentPanel {
    private JPanel pnlCanvas;
    private JScrollPane scrollPane;
    private String handler;
    private FileUploadModelProxy proxyHandler;

    public FileUploadPanel() {
        this.initComponents();
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public void afterLoad() {
        Object oval;
        super.afterLoad();
        Object caller = this.getBean();
        Object bean = this.getComponentBean();
        this.proxyHandler = new FileUploadModelProxy();
        PropertyResolver pr = PropertyResolver.getInstance();
        String shandler = this.getHandler();
        if (shandler != null && shandler.trim().length() > 0 && (oval = pr.getProperty(caller, shandler)) instanceof FileUploadModel) {
            this.proxyHandler.source = (FileUploadModel)oval;
        }
        this.proxyHandler.init();
        pr.setProperty(bean, "handler", (Object)this.proxyHandler);
    }

    public void afterRefresh() {
        super.afterRefresh();
        Object caller = this.getBean();
        Object bean = this.getComponentBean();
        PropertyResolver pr = PropertyResolver.getInstance();
    }

    private void initComponents() {
        this.pnlCanvas = new JPanel();
        this.pnlCanvas.setLayout(new CanvasLayoutManager());
        this.pnlCanvas.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlCanvas.setBackground(Color.WHITE);
        this.scrollPane = new JScrollPane(this.pnlCanvas);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setPreferredSize(new Dimension(200, 100));
        this.scrollPane.setFocusable(false);
        this.scrollPane.setBackground(Color.WHITE);
        this.setLayout(new MainLayoutManager());
        this.setOpaque(false);
        this.add(this.scrollPane);
        if (Beans.isDesignTime()) {
            this.pnlCanvas.add(new FileUploadItemCell());
            this.pnlCanvas.add(new FileUploadItemCell());
        }
    }

    private class CanvasLayoutManager
    implements LayoutManager {
        private int cell_spacing = 4;

        private CanvasLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        private Dimension getLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            Insets margin = parent.getInsets();
            Component[] comps = this.getVisibleComponents(parent);
            for (int i = 0; i < comps.length; ++i) {
                Dimension dim = comps[i].getPreferredSize();
                w = Math.max(w, dim.width);
                h += dim.height + (i == 0 ? 0 : this.cell_spacing);
            }
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                Component[] comps = this.getVisibleComponents(parent);
                for (int i = 0; i < comps.length; ++i) {
                    Dimension dim = comps[i].getPreferredSize();
                    comps[i].setBounds(x, y, w, dim.height);
                    y += dim.height + this.cell_spacing;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Component[] getVisibleComponents(Container parent) {
            ArrayList<Component> list = new ArrayList<Component>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                list.add(comps[i]);
            }
            try {
                Component[] componentArray = list.toArray(new Component[0]);
                return componentArray;
            }
            finally {
                list.clear();
            }
        }
    }

    private class MainLayoutManager
    implements LayoutManager {
        private MainLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        private Dimension getLayoutSize(Container parent) {
            Insets margin = parent.getInsets();
            Dimension dim = FileUploadPanel.this.scrollPane.getPreferredSize();
            int w = dim.width + (margin.left + margin.right);
            int h = dim.height + (margin.top + margin.bottom);
            return new Dimension(w, h);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                FileUploadPanel.this.scrollPane.setBounds(x, y, w, h);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Component[] getVisibleComponents(Container parent) {
            ArrayList<Component> list = new ArrayList<Component>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                list.add(comps[i]);
            }
            try {
                Component[] componentArray = list.toArray(new Component[0]);
                return componentArray;
            }
            finally {
                list.clear();
            }
        }
    }

    private class FileTransferHandler
    implements FileUploadManager.FileHandler {
        FileUploadPanel root;
        FileUploadItemCell cell;
        Map props;

        private FileTransferHandler() {
            this.root = FileUploadPanel.this;
        }

        @Override
        public void onTransfer(FileUploadItem item, long filesize, long bytesprocessed) {
            boolean completed;
            if (item == null) {
                return;
            }
            boolean bl = completed = bytesprocessed >= filesize;
            if (this.props != null) {
                this.props.put("completed", completed);
            }
            this.cell.update(filesize, bytesprocessed);
            this.cell.revalidate();
            this.cell.repaint();
            Runnable proc = new Runnable(){

                @Override
                public void run() {
                    FileTransferHandler.this.cell.revalidate();
                    FileTransferHandler.this.cell.repaint();
                }
            };
            SwingUtilities.invokeLater(proc);
        }

        @Override
        public void onCompleted(FileUploadItem item) {
        }
    }

    private class FileItemRemoveHandler
    implements ActionListener {
        FileUploadPanel root;
        FileUploadItemCell cell;
        FileUploadItem item;

        private FileItemRemoveHandler() {
            this.root = FileUploadPanel.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MsgBox.confirm((Object)("You are about to remove " + this.cell.getFileName() + ". Continue?"))) {
                Map conf = (Map)this.cell.getUserObject();
                this.item.recreateConfigFile(conf);
                this.item.markForRemoval();
                this.root.pnlCanvas.remove(this.cell);
                this.root.pnlCanvas.revalidate();
                this.root.pnlCanvas.repaint();
                FileUploadManager.getInstance().schedule(this.item);
                if (this.root.proxyHandler != null) {
                    this.root.proxyHandler.afterRemoveItem();
                }
            }
        }
    }

    private class FileUploadModelProvider
    implements FileUploadModel.Provider {
        FileUploadPanel root;

        private FileUploadModelProvider() {
            this.root = FileUploadPanel.this;
        }

        @Override
        public Binding getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Binding getInnerBinding() {
            return this.root.getInnerBinding();
        }

        @Override
        public void add(FileUploadItem item, String filename, long filesize, Map props) {
            if (item == null) {
                return;
            }
            if (props != null) {
                props.put("completed", false);
            }
            FileTransferHandler fh = new FileTransferHandler();
            FileUploadManager.getInstance().getFileHandlers().add(item, fh);
            FileUploadItemCell cell = new FileUploadItemCell();
            cell.setFileId(item.getName());
            cell.setFileName(filename);
            cell.setFileSize(filesize);
            cell.setUserObject(props);
            fh.props = props;
            fh.cell = cell;
            FileItemRemoveHandler rh = new FileItemRemoveHandler();
            cell.setRemoveHandler(rh);
            rh.cell = cell;
            rh.item = item;
            this.root.pnlCanvas.add(cell);
            this.root.pnlCanvas.revalidate();
            this.root.pnlCanvas.repaint();
        }

        @Override
        public void remove(FileUploadItem item) {
        }

        @Override
        public List<FileUploadItemCell.Info> getItems() {
            ArrayList<FileUploadItemCell.Info> items = new ArrayList<FileUploadItemCell.Info>();
            Component[] comps = this.root.pnlCanvas.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof FileUploadItemCell)) continue;
                FileUploadItemCell cell = (FileUploadItemCell)comps[i];
                items.add(cell.getInfo());
            }
            return items;
        }
    }

    private class FileUploadModelProxy
    extends FileUploadModel {
        FileUploadPanel root;
        FileUploadModelProvider provider;
        FileUploadModel source;

        private FileUploadModelProxy() {
            this.root = FileUploadPanel.this;
        }

        void init() {
            this.provider = new FileUploadModelProvider();
            if (this.source != null) {
                this.source.setProvider(this.provider);
            }
        }

        @Override
        public void afterRemoveItem() {
            if (this.source != null) {
                this.source.afterRemoveItem();
            }
        }
    }
}

