/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.components;

import com.rameses.rcp.support.ImageIconSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FileUploadItemCell
extends JPanel {
    private JLabel lblName;
    private JLabel lblSize;
    private StatusLabel lblStat;
    private JButton cmdRemove;
    private String fileId;
    private String fileName;
    private long fileSize;
    private long value;
    private DecimalFormat decFormat;
    private ActionListener removeHandler;
    private Object userObject;
    private Info info;
    private Color nameColor1;
    private Color nameColor2;

    public FileUploadItemCell() {
        this.initComponents();
    }

    private void initComponents() {
        this.decFormat = new DecimalFormat("#,##0");
        this.lblName = new JLabel();
        this.lblSize = new JLabel();
        this.lblStat = new StatusLabel();
        this.cmdRemove = new JButton();
        this.info = new Info();
        this.nameColor1 = Color.decode("#303030");
        this.nameColor2 = Color.decode("#6787e3");
        this.nameColor2 = Color.BLUE;
        this.lblStat.setPreferredSize(new Dimension(100, 14));
        this.lblSize.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.lblSize.setForeground(Color.decode("#888888"));
        this.lblName.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.lblName.setForeground(this.nameColor1);
        this.cmdRemove.setIcon(this.getIcon("com/rameses/filemgmt/images/x.png"));
        this.cmdRemove.setContentAreaFilled(false);
        this.cmdRemove.setBorderPainted(false);
        this.cmdRemove.setMargin(new Insets(0, 0, 0, 0));
        this.cmdRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadItemCell.this.removeActionImpl(e);
            }
        });
        Font font = this.lblName.getFont();
        if (font != null) {
            font = font.deriveFont(1);
            this.lblName.setFont(font);
        }
        if ((font = this.lblSize.getFont()) != null) {
            font = font.deriveFont(1);
            this.lblSize.setFont(font);
        }
        if (Beans.isDesignTime()) {
            long num = 102400L;
            this.setFileName("Sample Attachment File.png");
            this.setFileSize(num);
            this.setValue((int)(num / 2L));
        }
        this.setBorder(BorderFactory.createLineBorder(Color.decode("#a0a0a0"), 1));
        this.setLayout(new LayoutManagerImpl());
        this.add(this.lblName);
        this.add(this.lblSize);
        this.add(this.lblStat);
        this.add(this.cmdRemove);
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateLabelName();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
        this.updateProgressValue();
        this.updateLabelSize();
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.updateProgressValue();
    }

    public ActionListener getRemoveHandler() {
        return this.removeHandler;
    }

    public void setRemoveHandler(ActionListener removeHandler) {
        this.removeHandler = removeHandler;
    }

    public void update(long fileSize, long progressValue) {
        this.fileSize = fileSize;
        this.value = progressValue;
        this.updateProgressValue();
        this.updateLabelSize();
    }

    public boolean isCompleted() {
        long value2;
        long value1 = this.getValue();
        return value1 >= (value2 = this.getFileSize());
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    Info getInfo() {
        return this.info;
    }

    protected void onRemove() {
    }

    private void removeActionImpl(ActionEvent e) {
        this.onRemove();
        ActionListener al = this.getRemoveHandler();
        if (al != null) {
            al.actionPerformed(e);
        }
    }

    private void updateLabelName() {
        if (this.lblName != null) {
            String text = this.getFileName();
            this.lblName.setText(text == null ? "" : text);
        }
    }

    private void updateLabelSize() {
        if (this.lblSize != null) {
            long num = this.getFileSize();
            if (num <= 0L) {
                this.lblSize.setText("");
            } else if (num < 1024L) {
                this.lblSize.setText("(" + num + "B)");
            } else {
                double value = ((Number)num).doubleValue() / 1024.0;
                String text = "(" + this.decFormat.format(value) + "K)";
                this.lblSize.setText(text);
            }
        }
    }

    private void updateProgressValue() {
        if (this.lblStat != null) {
            this.lblStat.setMaxValue(this.getFileSize());
            this.lblStat.setValue(this.getValue());
            this.lblStat.repaint();
            this.lblStat.setVisible(this.getValue() < this.getFileSize());
        }
        if (this.lblName != null) {
            if (this.isCompleted()) {
                this.lblName.setForeground(this.nameColor2);
            } else {
                this.lblName.setForeground(this.nameColor1);
            }
            this.lblName.repaint();
        }
    }

    private ImageIcon getIcon(String pathname) {
        try {
            return ImageIconSupport.getInstance().getIcon(pathname);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class StatusLabel
    extends JLabel {
        private Color borderColor;
        private Color rateColor;
        private long maxValue;
        private long value;
        private double rate;

        StatusLabel() {
            this.initComponents();
        }

        private void initComponents() {
            this.borderColor = Color.decode("#999999");
            this.rateColor = Color.decode("#6787e3");
            this.setMaxValue(100L);
            this.setValue(50L);
        }

        public long getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(long maxValue) {
            this.maxValue = maxValue;
            this.computeRate();
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
            this.computeRate();
        }

        private void computeRate() {
            long mv = this.getMaxValue();
            if (mv <= 0L) {
                this.rate = 0.0;
                return;
            }
            long v = this.getValue();
            this.rate = v >= mv ? 1.0 : ((Number)v).doubleValue() / ((Number)mv).doubleValue();
        }

        @Override
        public void paint(Graphics g) {
            Double res;
            int pw = Math.max(this.getWidth(), 0);
            int ph = Math.max(this.getHeight(), 0);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, pw, ph);
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, Math.max(pw - 1, 0), Math.max(ph - 1, 0));
            int cw = Math.max(pw - 4, 0);
            if (this.rate > 0.0 && (cw = ((Number)(res = Double.valueOf(((Number)cw).doubleValue() * this.rate))).intValue()) > 0) {
                g2.setColor(this.rateColor);
                g2.fillRect(2, 2, cw - 1, ph - 4);
            }
            g2.dispose();
        }
    }

    private class LayoutManagerImpl
    implements LayoutManager {
        private LayoutManagerImpl() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        private Dimension getLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            Insets margin = parent.getInsets();
            Dimension dim = FileUploadItemCell.this.cmdRemove.getPreferredSize();
            h = Math.max(dim.height, h);
            w += dim.width;
            if (FileUploadItemCell.this.lblStat.isVisible()) {
                dim = FileUploadItemCell.this.lblStat.getPreferredSize();
                h = Math.max(dim.height, h);
                w += dim.width;
            }
            dim = FileUploadItemCell.this.lblSize.getPreferredSize();
            h = Math.max(dim.height, h);
            w += dim.width + 50;
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int ww;
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int cw = pw - margin.right;
                int ch = ph - (margin.top + margin.bottom);
                int cy = margin.top;
                int cx = cw;
                Dimension dim = FileUploadItemCell.this.cmdRemove.getPreferredSize();
                FileUploadItemCell.this.cmdRemove.setBounds(cx -= dim.width, cy, dim.width, dim.height);
                cw -= dim.width;
                if (FileUploadItemCell.this.lblStat.isVisible()) {
                    dim = FileUploadItemCell.this.lblStat.getPreferredSize();
                    int yy = Math.max(ch / 2 - dim.height / 2, margin.top);
                    FileUploadItemCell.this.lblStat.setBounds(cx -= dim.width, yy + 1, dim.width, dim.height);
                    cw -= dim.width;
                }
                if ((ww = this.getWidth(new Component[]{FileUploadItemCell.this.lblName, FileUploadItemCell.this.lblSize})) > cw) {
                    dim = FileUploadItemCell.this.lblSize.getPreferredSize();
                    FileUploadItemCell.this.lblSize.setBounds(cx -= dim.width, cy, dim.width, ch);
                    FileUploadItemCell.this.lblName.setBounds(margin.left, cy, cw -= dim.width, ch);
                } else {
                    cx = margin.left;
                    dim = FileUploadItemCell.this.lblName.getPreferredSize();
                    FileUploadItemCell.this.lblName.setBounds(cx, cy, dim.width, ch);
                    dim = FileUploadItemCell.this.lblSize.getPreferredSize();
                    FileUploadItemCell.this.lblSize.setBounds(cx += dim.width, cy, dim.width, ch);
                }
            }
        }

        private int getWidth(Component[] comps) {
            int w = 0;
            for (int i = 0; i < comps.length; ++i) {
                Dimension dim = comps[i].getPreferredSize();
                w += dim.width;
            }
            return w;
        }
    }

    public class Info {
        FileUploadItemCell root;

        public Info() {
            this.root = FileUploadItemCell.this;
        }

        public boolean isCompleted() {
            return this.root.isCompleted();
        }

        public Object getData() {
            return this.root.getUserObject();
        }
    }
}

