/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import com.rameses.filemgmt.FileDownloadManager;
import com.rameses.filemgmt.FileLocationConf;
import com.rameses.filemgmt.FileLocationProvider;
import com.rameses.filemgmt.FileLocationRegistry;
import com.rameses.filemgmt.FileUploadManager;
import com.rameses.filemgmt.RunProc;
import com.rameses.io.FileLocTypeProvider;
import com.rameses.util.Encoder;
import com.rameses.util.Service;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;

public final class FileManager {
    private static FileManager instance = null;
    private static final Object STATUS_LOCKED = new Object();
    private static final Object LOCTYPE_LOCKED = new Object();
    private Map<String, FileLocTypeProvider> fileLocTypes;
    private String sessionid = Encoder.MD5.encode(new UID().toString());
    private boolean started;
    private boolean enabled = true;
    private boolean enableUpload = true;
    private boolean enableDownoad = true;
    private long fetchLocationInterval = 10000L;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduler;
    private DbProvider dbprovider;
    private FileLocationProvider fileLocProvider;
    private FileLocationConfs fileLocConfs;
    private File tempdir;
    private Helper helper = new Helper();
    private static final Object FILE_LOC_CONF_LOCKED = new Object();
    private FileTypeProvider fileTypeProvider;

    public static synchronized FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    private FileManager() {
        this.fileLocConfs = new FileLocationConfs();
        this.threadPool = Executors.newFixedThreadPool(100);
        this.scheduler = Executors.newScheduledThreadPool(10);
    }

    public boolean isValidSession() {
        return this.helper.isValidSession();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableUpload() {
        return this.isEnabled() ? this.enableUpload : false;
    }

    public void setEnableUpload(boolean enableUpload) {
        this.enableUpload = enableUpload;
    }

    public boolean isEnableDownload() {
        return this.isEnabled() ? this.enableDownoad : false;
    }

    public void setEnableDownload(boolean enableDownoad) {
        this.enableDownoad = enableDownoad;
    }

    public long getFetchLocationInterval() {
        return this.fetchLocationInterval;
    }

    public void setFetchLocationInterval(long fetchLocationInterval) {
        this.fetchLocationInterval = fetchLocationInterval;
    }

    public File getTempDir() {
        return this.getTempDir("filemanager");
    }

    public File getTempDir(String group) {
        return this.helper.getTempDir(group);
    }

    public void setTempDir(File tempdir) {
        this.tempdir = tempdir;
    }

    public Helper getHelper() {
        return this.helper;
    }

    public DbProvider getDbProvider() {
        return this.dbprovider;
    }

    public void setDbProvider(DbProvider dbprovider) {
        this.dbprovider = dbprovider;
    }

    public FileLocationProvider getLocationProvider() {
        return this.fileLocProvider;
    }

    public void setLocationProvider(FileLocationProvider fileLocProvider) {
        this.fileLocProvider = fileLocProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileLocTypeProviders(ClassLoader loader) {
        Object object = LOCTYPE_LOCKED;
        synchronized (object) {
            if (this.fileLocTypes == null) {
                HashMap<String, FileLocTypeProvider> types = new HashMap<String, FileLocTypeProvider>();
                ClassLoader cl = loader != null ? loader : this.getClass().getClassLoader();
                Iterator itr = Service.providers(FileLocTypeProvider.class, (ClassLoader)cl);
                while (itr.hasNext()) {
                    FileLocTypeProvider prov = (FileLocTypeProvider)itr.next();
                    types.put(prov.getName(), prov);
                }
                this.fileLocTypes = types;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLocTypeProvider getLocType(String name) {
        Object object = LOCTYPE_LOCKED;
        synchronized (object) {
            if (this.fileLocTypes == null) {
                return null;
            }
            return this.fileLocTypes.get(name);
        }
    }

    public FileLocationConfs getLocationConfs() {
        return this.fileLocConfs;
    }

    public ImageIcon getFileTypeIcon(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        try {
            URL url = FileManager.class.getResource("images/filetype-" + name.toLowerCase() + ".png");
            return url == null ? null : new ImageIcon(url);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = STATUS_LOCKED;
        synchronized (object) {
            if (!this.isEnabled()) {
                System.out.println("FileManager has been disabled");
                return;
            }
            if (this.started) {
                System.out.println("FileManager has already been started");
                return;
            }
            System.out.println("Starting FileManager...");
            this.helper.createSessionFile();
            this.scheduler.schedule(new SessionCheckProc(), 400L, TimeUnit.MILLISECONDS);
            FileUploadManager.getInstance().start();
            FileDownloadManager.getInstance().start();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = STATUS_LOCKED;
        synchronized (object) {
            if (!this.isEnabled()) {
                System.out.println("FileManager has been disabled");
                return;
            }
            System.out.println("Stopping FileManager...");
            if (!this.started) {
                return;
            }
            this.helper.deleteSessionFile();
            this.fileLocConfs.cancel();
            this.shutdown(this.scheduler.shutdownNow());
            this.shutdown(this.threadPool.shutdownNow());
            this.fileLocConfs.clear();
            FileUploadManager.getInstance().stop();
            FileDownloadManager.getInstance().stop();
            this.started = false;
        }
    }

    private void shutdown(List<Runnable> procs) {
        if (procs == null) {
            return;
        }
        while (!procs.isEmpty()) {
            Runnable r = procs.remove(0);
            if (!(r instanceof RunProc)) continue;
            try {
                ((RunProc)r).cancel();
            }
            catch (Throwable throwable) {}
        }
    }

    public FileLocationConf getDefaultLocation(String connection) {
        Map data = this.getLocationProvider().getDefaultLocation(connection);
        if (data == null || data.isEmpty()) {
            throw new RuntimeException("No active location config available");
        }
        return new FileLocationConf(data);
    }

    public FileLocationConf getLocation(String connection, String locationId) {
        Map data = this.getLocationProvider().getLocation(connection, locationId);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return new FileLocationConf(data);
    }

    public FileTypeProvider getFileTypeProvider() {
        return this.fileTypeProvider;
    }

    public void setFileTypeProvider(FileTypeProvider fileTypeProvider) {
        this.fileTypeProvider = fileTypeProvider;
    }

    public static interface FileTypeProvider {
        public List getTypes();

        public Map getType(String var1);
    }

    public class Helper {
        private final String GROUP_NAME = "filemanager";

        public File getTempDir(String group) {
            File tmpdir = FileManager.this.tempdir;
            if (tmpdir == null) {
                tmpdir = new File(System.getProperty("java.io.tmpdir"));
            }
            StringBuilder cname = new StringBuilder();
            cname.append("rameses");
            if (group != null && group.trim().length() > 0) {
                cname.append("/").append(group);
            }
            File basedir = new File(tmpdir, cname.toString());
            try {
                if (!basedir.exists()) {
                    basedir.mkdir();
                }
                return basedir;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private void createSessionFile() {
            File folder = this.getTempDir("filemanager");
            File[] files = folder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().startsWith("sessionid_")) continue;
                try {
                    files[i].delete();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String sessionid = FileManager.this.sessionid;
            this.createTempFile("sessionid_" + sessionid, sessionid);
        }

        private void deleteSessionFile() {
            File folder = this.getTempDir("filemanager");
            File file = new File(folder, "sessionid_" + FileManager.this.sessionid);
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean isValidSession() {
            File folder = this.getTempDir("filemanager");
            File file = new File(folder, "sessionid_" + FileManager.this.sessionid);
            return file.exists() && !file.isDirectory();
        }

        public void createTempFile(String name, String content) {
            this.createTempFile(this.getTempDir("filemanager"), name, content);
        }

        public void createTempFile(File folder, String name, String content) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(folder, name));
                fos.write((content == null ? "" : content).getBytes());
                fos.flush();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public boolean removeTempFile(String name) {
            return this.removeTempFile(this.getTempDir("filemanager"), name);
        }

        public boolean removeTempFile(File folder, String name) {
            try {
                File tmp = new File(folder, name);
                return tmp.exists() ? tmp.delete() : true;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    public class FileLocationConfs {
        private String defaultName;
        private boolean cancelled;
        private Map<String, FileLocationConf> confs = new HashMap<String, FileLocationConf>();

        FileLocationConfs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(FileLocationConf conf) {
            Object object = FILE_LOC_CONF_LOCKED;
            synchronized (object) {
                String sname;
                if (this.cancelled) {
                    return;
                }
                String string = sname = conf == null ? null : conf.getName();
                if (sname == null) {
                    return;
                }
                this.confs.put(sname, conf);
                if (conf.isDefaulted()) {
                    this.defaultName = sname;
                }
            }
        }

        void clear() {
            this.confs.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Object object = FILE_LOC_CONF_LOCKED;
            synchronized (object) {
                this.cancelled = true;
            }
        }

        public FileLocationConf getDefaultConf() {
            return this.defaultName == null ? null : this.confs.get(this.defaultName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileLocationConf get(String name) {
            Object object = FILE_LOC_CONF_LOCKED;
            synchronized (object) {
                return this.confs.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = FILE_LOC_CONF_LOCKED;
            synchronized (object) {
                return this.confs.isEmpty();
            }
        }
    }

    private class FileLocationConfFetcher
    implements RunProc {
        FileManager root;
        boolean cancelled;
        int index;

        private FileLocationConfFetcher() {
            this.root = FileManager.this;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                FileLocationConfFetcher ff;
                if (!this.root.isEnabled()) {
                    return;
                }
                long interval = 0L;
                FileLocationProvider provider = null;
                try {
                    interval = this.root.getFetchLocationInterval();
                    provider = this.root.getLocationProvider();
                    this.runImpl();
                    if (this.cancelled) {
                        return;
                    }
                    if (provider == null || interval <= 0L) break block9;
                    ff = new FileLocationConfFetcher();
                    ff.index = this.index == 0 ? 1 : this.index;
                }
                catch (Throwable t) {
                    FileLocationConfFetcher ff2;
                    try {
                        System.out.println("[FileLocationConfFetcher] " + t.getMessage());
                        if (this.cancelled) {
                            return;
                        }
                        if (provider == null || interval <= 0L) break block9;
                        ff2 = new FileLocationConfFetcher();
                        ff2.index = this.index == 0 ? 1 : this.index;
                    }
                    catch (Throwable throwable) {
                        if (this.cancelled) {
                            return;
                        }
                        if (provider != null && interval > 0L) {
                            FileLocationConfFetcher ff3 = new FileLocationConfFetcher();
                            ff3.index = this.index == 0 ? 1 : this.index;
                            this.root.scheduler.schedule(ff3, interval, TimeUnit.MILLISECONDS);
                        }
                        throw throwable;
                    }
                    this.root.scheduler.schedule(ff2, interval, TimeUnit.MILLISECONDS);
                }
                this.root.scheduler.schedule(ff, interval, TimeUnit.MILLISECONDS);
            }
        }

        private void runImpl() throws Exception {
            List<Map> list;
            if (this.cancelled) {
                return;
            }
            FileLocationProvider provider = this.root.getLocationProvider();
            List<Map> list2 = list = provider == null ? null : provider.getLocations(null);
            if (list != null) {
                for (Map item : list) {
                    if (this.cancelled) break;
                    FileLocationConf flc = new FileLocationConf(item);
                    this.root.fileLocConfs.add(flc);
                    FileLocTypeProvider loctype = this.root.getLocType(flc.getType());
                    if (!(loctype instanceof FileLocationRegistry)) continue;
                    ((FileLocationRegistry)loctype).register(flc);
                }
            }
        }
    }

    private class SessionCheckProc
    implements RunProc {
        FileManager root;
        private boolean cancelled;

        private SessionCheckProc() {
            this.root = FileManager.this;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            boolean valid = true;
            try {
                if (this.root.isValidSession()) {
                } else {
                    valid = false;
                    this.root.stop();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (valid) {
                    this.schedule();
                }
            }
        }

        void schedule() {
            if (this.cancelled) {
                return;
            }
            this.root.scheduler.schedule(new SessionCheckProc(), 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public static interface DbProvider {
        public Object getService(String var1);

        public Map create(Map var1, String var2);

        public Map save(Map var1, String var2);

        public Map read(Map var1, String var2);

        public Map remove(Map var1, String var2);
    }
}

