/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import com.rameses.filemgmt.FileDownloadHandler;
import com.rameses.filemgmt.FileLocationConf;
import com.rameses.filemgmt.FileLocationRegistry;
import com.rameses.filemgmt.FileManager;
import com.rameses.filemgmt.RunProc;
import com.rameses.io.FileLocTypeProvider;
import com.rameses.io.FileTransferSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class FileDownloadManager {
    private static final Object INIT_LOCKED = new Object();
    private static FileDownloadManager instance = null;
    private static final Object STATUS_LOCKED = new Object();
    private static final Object CACHE_LOCKED = new Object();
    private boolean started;
    private Map<String, String> cache = new HashMap<String, String>();
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduler;
    private FileHandlers fileHandlers = new FileHandlers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileDownloadManager getInstance() {
        Object object = INIT_LOCKED;
        synchronized (object) {
            if (instance == null) {
                instance = new FileDownloadManager();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reset() {
        Object object = INIT_LOCKED;
        synchronized (object) {
            FileDownloadManager o = new FileDownloadManager();
            if (instance != null) {
                instance.stop();
            }
            instance = o;
        }
    }

    private FileDownloadManager() {
        this.threadPool = Executors.newFixedThreadPool(100);
        this.scheduler = Executors.newScheduledThreadPool(10);
    }

    @Deprecated
    public boolean isEnabled() {
        return FileManager.getInstance().isEnableDownload();
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        FileManager.getInstance().setEnableDownload(enabled);
    }

    public File getTempDir() {
        return FileManager.getInstance().getTempDir("filedownload");
    }

    public FileHandlers getFileHandlers() {
        return this.fileHandlers;
    }

    public String getStatus(String fileid) {
        DownloadItem di = new DownloadItem(fileid);
        di.verifyFolder();
        if (di.isModeCompleted()) {
            return "completed";
        }
        if (di.isModeDownload()) {
            return "download";
        }
        if (di.isModeStarted()) {
            return "started";
        }
        return null;
    }

    public File getContentFile(String fileid) {
        DownloadItem di = new DownloadItem(fileid);
        di.verifyFolder();
        File file = di.getContentFile();
        try {
            return file.getCanonicalFile();
        }
        catch (Throwable t) {
            return file;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = STATUS_LOCKED;
        synchronized (object) {
            if (!this.isEnabled()) {
                System.out.println("FileDownloadManager has been disabled");
                return;
            }
            if (this.isStarted()) {
                System.out.println("FileDownloadManager has already been started");
                return;
            }
            System.out.println("Starting FileDownloadManager...");
            new FileScanner().schedule();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = STATUS_LOCKED;
        synchronized (object) {
            if (!this.isEnabled()) {
                System.out.println("FileDownloadManager has been disabled");
                return;
            }
            System.out.println("Stopping FileDownloadManager...");
            if (!this.isStarted()) {
                return;
            }
            this.shutdown(this.scheduler.shutdownNow());
            this.shutdown(this.threadPool.shutdownNow());
            this.started = false;
        }
    }

    public synchronized DownloadItem doBasicdownload(String fileid, String filetype, long filesize, FileLocationConf fileloc, FileDownloadHandler handler, String conn) {
        if (fileid == null || fileid.trim().length() == 0) {
            throw new RuntimeException("fileid parameter is required");
        }
        if (fileloc == null) {
            throw new RuntimeException("filelocid parameter is required");
        }
        DownloadItem di = new DownloadItem(fileid, filetype, filesize);
        di.basicDownloadProcess = new BasicDownloadProcess(di, fileloc, handler);
        di.fileconn = conn;
        this.schedule(di);
        return di;
    }

    public synchronized void download(String fileid, String filetype, String filelocid, long filesize, FileDownloadHandler handler) {
        if (fileid == null || fileid.trim().length() == 0) {
            throw new RuntimeException("fileid parameter is required");
        }
        if (filelocid == null || filelocid.trim().length() == 0) {
            throw new RuntimeException("filelocid parameter is required");
        }
        if (filesize <= 0L) {
            throw new RuntimeException("filesize must be greater than zero");
        }
        this.fileHandlers.register(fileid);
        this.fileHandlers.add(fileid, handler);
        DownloadItem di = new DownloadItem(fileid, filetype, filelocid, filesize).init().start();
        this.schedule(di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(DownloadItem item) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (item == null) {
                return;
            }
            if (item.basicDownloadProcess != null) {
                this.threadPool.submit(item.basicDownloadProcess);
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            String keyname = item.getName();
            if (item.isModeCompleted()) {
                this.cache.remove(keyname);
                this.fileHandlers.unregister(keyname);
                return;
            }
            RunProc proc = item.createProcessHandler();
            if (proc == null) {
                this.cache.remove(keyname);
                this.fileHandlers.unregister(keyname);
            } else if (!this.cache.containsKey(keyname)) {
                this.cache.put(keyname, keyname);
                this.threadPool.submit(proc);
            }
        }
    }

    void detach(DownloadItem item) {
        String keyname;
        String string = keyname = item == null ? null : item.getName();
        if (keyname == null) {
            return;
        }
        this.fileHandlers.unregister(keyname);
        this.cache.remove(keyname);
    }

    private void shutdown(List<Runnable> procs) {
        if (procs == null) {
            return;
        }
        while (!procs.isEmpty()) {
            Runnable r = procs.remove(0);
            if (!(r instanceof RunProc)) continue;
            try {
                ((RunProc)r).cancel();
            }
            catch (Throwable throwable) {}
        }
    }

    private class BasicDownloadProcess
    implements RunProc {
        FileDownloadManager root;
        private DownloadItem item;
        private FileLocationConf fileloc;
        private FileDownloadHandler handler;
        private boolean cancelled;
        private FileTransferSession sess;
        private byte[] bytes;

        BasicDownloadProcess(DownloadItem item, FileLocationConf fileloc, FileDownloadHandler handler) {
            this.root = FileDownloadManager.this;
            this.item = item;
            this.fileloc = fileloc;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            this.cancelled = true;
            try {
                this.sess.cancel();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.sess = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            FileManager fm = FileManager.getInstance();
            String fileid = this.item.getName();
            try {
                FileLocTypeProvider oloctype = fm.getLocType(this.fileloc.getType());
                if (oloctype == null) {
                    throw new Exception("No available file location type provider for " + this.fileloc.getType());
                }
                FileLocTypeProvider loctype = oloctype;
                if (oloctype instanceof FileLocationRegistry) {
                    ((FileLocationRegistry)oloctype).register(this.fileloc);
                }
                String filetype = this.item.getFileType();
                StringBuilder remoteName = new StringBuilder();
                remoteName.append(fileid);
                if (filetype != null && filetype.trim().length() > 0) {
                    remoteName.append(".").append(filetype);
                }
                final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileTransferSession sess = loctype.createDownloadSession();
                sess.setTargetName(remoteName.toString());
                sess.setLocationConfigId(this.fileloc.getName());
                sess.setOutputStream((OutputStream)baos);
                sess.setHandler(new FileTransferSession.Handler(){

                    public void ontransfer(long bytesprocessed) {
                        this.ontransfer(BasicDownloadProcess.this.item.getFileSize(), bytesprocessed);
                    }

                    public void ontransfer(long filesize, long bytesprocessed) {
                        BasicDownloadProcess.this.fireOnTransfer(filesize, bytesprocessed);
                    }

                    public void oncomplete() {
                        BasicDownloadProcess.access$402(BasicDownloadProcess.this, baos.toByteArray());
                        BasicDownloadProcess.this.fireOnComplete();
                    }
                });
                sess.run();
            }
            catch (RescheduleException oloctype) {
                if (this.cancelled) {
                    return;
                }
            }
            catch (Throwable t) {
                System.out.println("[BasicDownloadProcess] (" + fileid + ") error caused by " + t.getMessage());
                t.printStackTrace();
            }
            finally {
                if (this.cancelled) {
                    return;
                }
            }
            this.root.detach(this.item);
        }

        void fireOnTransfer(long filesize, long bytesprocessed) {
            if (this.handler != null) {
                this.handler.onTransfer(this.item.getName(), filesize, bytesprocessed);
            }
        }

        void fireOnComplete() {
            if (this.handler != null) {
                this.handler.onCompleted(this.item.getName());
            }
        }

        static /* synthetic */ byte[] access$402(BasicDownloadProcess x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }

    private class ModeDownloadProcess
    implements RunProc {
        private boolean cancelled;
        private DownloadItem item;
        private FileTransferSession sess;
        FileDownloadManager root;

        ModeDownloadProcess(DownloadItem item) {
            this.root = FileDownloadManager.this;
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            this.cancelled = true;
            try {
                this.sess.cancel();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.sess = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunProc proc;
            if (this.cancelled) {
                return;
            }
            FileManager fm = FileManager.getInstance();
            String fileid = this.item.getName();
            try {
                this.item.open();
                if (fm.getLocationConfs().isEmpty()) {
                    throw new RescheduleException();
                }
                String filelocid = this.item.getFileLocId();
                FileLocationConf conf = fm.getLocation(this.item.fileconn, filelocid);
                if (conf == null) {
                    throw new Exception("" + filelocid + " file location conf does not exist");
                }
                FileLocTypeProvider loctype = fm.getLocType(conf.getType());
                if (loctype == null) {
                    throw new Exception("No available file location type provider for " + conf.getType());
                }
                String filetype = this.item.getFileType();
                StringBuilder remoteName = new StringBuilder();
                remoteName.append(fileid);
                if (filetype != null && filetype.trim().length() > 0) {
                    remoteName.append(".").append(filetype);
                }
                File localFile = new File(this.item.getBaseFolder(), "content");
                FileTransferSession sess = loctype.createDownloadSession();
                sess.setTargetName(remoteName.toString());
                sess.setLocationConfigId(filelocid);
                sess.setFile(localFile);
                sess.setHandler(new FileTransferSession.Handler(){

                    public void ontransfer(long bytesprocessed) {
                        this.ontransfer(ModeDownloadProcess.this.item.getFileSize(), bytesprocessed);
                    }

                    public void ontransfer(long filesize, long bytesprocessed) {
                        ModeDownloadProcess.this.fireOnTransfer(filesize, bytesprocessed);
                    }

                    public void oncomplete() {
                        ModeDownloadProcess.this.fireOnComplete();
                    }
                });
                sess.run();
            }
            catch (RescheduleException filelocid) {
                if (this.cancelled) {
                    return;
                }
            }
            catch (Throwable t) {
                System.out.println("[ModeDownloadProcess] (" + fileid + ") error caused by " + t.getMessage());
            }
            finally {
                if (this.cancelled) {
                    return;
                }
            }
            if ((proc = this.item.createProcessHandler()) == null) {
                this.root.detach(this.item);
            } else {
                this.root.scheduler.schedule(proc, 1000L, TimeUnit.MILLISECONDS);
            }
        }

        void fireOnTransfer(long filesize, long bytesprocessed) {
            this.root.fileHandlers.notifyOnTransfer(this.item.getName(), filesize, bytesprocessed);
        }

        void fireOnComplete() {
            FileManager fm = FileManager.getInstance();
            fm.getHelper().createTempFile(this.item.getBaseFolder(), ".completed", "");
            fm.getHelper().removeTempFile(this.item.getBaseFolder(), ".download");
            fm.getHelper().removeTempFile(this.item.getBaseFolder(), ".started");
            this.root.fileHandlers.notifyOnCompleted(this.item.getName());
            this.root.fileHandlers.unregister(this.item.getName());
        }
    }

    private class ModeStartProcess
    implements RunProc {
        private DownloadItem item;
        private boolean cancelled;
        FileDownloadManager root;

        ModeStartProcess(DownloadItem item) {
            this.root = FileDownloadManager.this;
            this.item = item;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.cancelled) {
                    return;
                }
                FileManager fm = FileManager.getInstance();
                fm.getHelper().createTempFile(this.item.getBaseFolder(), ".download", "");
                fm.getHelper().removeTempFile(this.item.getBaseFolder(), ".started");
            }
            catch (Throwable t) {
                System.out.println("[ModeStartProcess] (" + this.item.getName() + ") error caused by " + t.getMessage());
            }
            finally {
                if (this.cancelled) {
                    return;
                }
            }
            RunProc proc = this.item.createProcessHandler();
            if (proc == null) {
                this.root.detach(this.item);
            } else {
                this.root.threadPool.submit(proc);
            }
        }
    }

    private class RescheduleException
    extends Exception {
        private RescheduleException() {
        }
    }

    private class DataFile {
        private File basedir;
        private File file;
        private Map conf;

        DataFile(File basedir, String name) {
            this.basedir = basedir;
            this.file = new File(basedir, name);
            this.conf = new HashMap();
        }

        void create(Map conf) {
            if (conf != null && !conf.isEmpty()) {
                this.conf.clear();
                this.conf.putAll(conf);
                this.update();
            }
        }

        Map copyData() {
            HashMap data = new HashMap();
            data.putAll(this.conf);
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataFile read() {
            FileInputStream inp = null;
            try {
                if (!this.file.exists()) {
                    DataFile dataFile = null;
                    return dataFile;
                }
                inp = new FileInputStream(this.file);
                Properties props = new Properties();
                props.load(inp);
                this.conf.clear();
                this.conf.putAll(props);
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable throwable) {}
            }
            return this;
        }

        public void update() {
            FileOutputStream fos = null;
            try {
                StringBuilder sb = new StringBuilder();
                Set sets = this.conf.entrySet();
                for (Map.Entry entry : sets) {
                    String skey = entry.getKey() == null ? null : entry.getKey().toString();
                    if (skey == null || skey.trim().length() <= 0) continue;
                    String sval = entry.getValue() == null ? "" : entry.getValue().toString();
                    sb.append(skey).append("=").append(sval).append("\n");
                }
                fos = new FileOutputStream(this.file);
                fos.write(sb.toString().replace('\\', '/').getBytes());
                fos.flush();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public String getProperty(String name) {
            Object value = this.conf.get(name);
            return value == null ? null : value.toString();
        }

        public Number getPropertyAsNumber(String name) {
            try {
                String value = this.getProperty(name);
                return new Long(value);
            }
            catch (Throwable t) {
                return null;
            }
        }

        public void setProperty(String name, Object value) {
            this.conf.put(name, value);
        }
    }

    private class ValidFileFilter
    implements FileFilter {
        FileDownloadManager root;

        private ValidFileFilter() {
            this.root = FileDownloadManager.this;
        }

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            if (file.getName().endsWith("~")) {
                return false;
            }
            if (this.root.cache.containsKey(file.getName())) {
                return false;
            }
            File child = new File(file, ".error");
            if (child.exists()) {
                return false;
            }
            child = new File(file, ".forremoval");
            if (child.exists()) {
                return true;
            }
            child = new File(file, ".completed");
            if (child.exists()) {
                return false;
            }
            child = new File(file, ".conf");
            if (!child.exists()) {
                return false;
            }
            child = new File(file, ".started");
            return child.exists();
        }
    }

    private class FileScanner
    implements RunProc {
        FileDownloadManager root;
        boolean cancelled;

        private FileScanner() {
            this.root = FileDownloadManager.this;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        void schedule() {
            this.root.scheduler.schedule(this, 1000L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.cancelled) {
                    return;
                }
                this.runImpl();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (this.cancelled) {
                    return;
                }
                new FileScanner().schedule();
            }
        }

        private void runImpl() throws Exception {
            File[] files;
            if (FileManager.getInstance().getLocationConfs().isEmpty()) {
                return;
            }
            File tempdir = this.root.getTempDir();
            for (File file : files = tempdir.listFiles(new ValidFileFilter())) {
                if (this.root.cache.containsKey(file.getName())) continue;
                DownloadItem di = new DownloadItem(file.getName()).open();
                this.root.schedule(di);
            }
        }
    }

    public class DownloadItem {
        FileDownloadManager root;
        private String fileid;
        private String filetype;
        private String filelocid;
        private String fileconn;
        private long filesize;
        private File basedir;
        private BasicDownloadProcess basicDownloadProcess;

        DownloadItem(String fileid) {
            this(fileid, null, null, 0L);
        }

        DownloadItem(String fileid, String filetype, long filesize) {
            this(fileid, filetype, null, filesize);
        }

        DownloadItem(String fileid, String filetype, String filelocid, long filesize) {
            this.root = FileDownloadManager.this;
            this.fileid = fileid;
            this.filetype = filetype;
            this.filelocid = filelocid;
            this.filesize = filesize;
        }

        public String getName() {
            return this.fileid;
        }

        public String getFileType() {
            return this.filetype;
        }

        public String getFileLocId() {
            return this.filelocid;
        }

        public long getFileSize() {
            return this.filesize;
        }

        File getBaseFolder() {
            if (this.basedir == null) {
                File tempdir = this.root.getTempDir();
                try {
                    tempdir = tempdir.getCanonicalFile();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.basedir = new File(tempdir, this.fileid);
            }
            return this.basedir;
        }

        File verifyFolder() {
            File dir = this.getBaseFolder();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }

        DownloadItem init() {
            File dir = this.verifyFolder();
            File file = new File(dir, ".completed");
            if (file.exists()) {
                return null;
            }
            file = new File(dir, ".conf");
            if (!file.exists()) {
                DataFile df = new DataFile(dir, ".conf");
                df.setProperty("filelocid", this.filelocid);
                df.setProperty("filetype", this.filetype);
                df.setProperty("filesize", this.filesize);
                df.setProperty("value", 0);
                df.update();
            }
            return this;
        }

        DownloadItem start() {
            File dir = this.getBaseFolder();
            File file = new File(dir, ".completed");
            if (file.exists()) {
                return null;
            }
            FileManager fm = FileManager.getInstance();
            fm.getHelper().createTempFile(dir, ".started", null);
            return this;
        }

        DownloadItem open() {
            File dir = this.getBaseFolder();
            if (dir.exists()) {
                DataFile df = new DataFile(dir, ".conf").read();
                this.filetype = df.getProperty("filetype");
                this.filelocid = df.getProperty("filelocid");
                this.filesize = df.getPropertyAsNumber("filesize").longValue();
            }
            return this;
        }

        boolean isModeCompleted() {
            return new File(this.getBaseFolder(), ".completed").exists();
        }

        boolean isModeDownload() {
            return new File(this.getBaseFolder(), ".download").exists();
        }

        boolean isModeStarted() {
            return new File(this.getBaseFolder(), ".started").exists();
        }

        File getContentFile() {
            return new File(this.getBaseFolder(), "content");
        }

        RunProc createProcessHandler() {
            if (this.isModeCompleted()) {
                return null;
            }
            if (this.isModeDownload()) {
                return new ModeDownloadProcess(this);
            }
            if (this.isModeStarted()) {
                return new ModeStartProcess(this);
            }
            return null;
        }

        public byte[] getContent() {
            if (this.basicDownloadProcess == null) {
                return null;
            }
            return this.basicDownloadProcess.bytes;
        }
    }

    public class FileHandlers {
        private final Object LOCKED = new Object();
        private final Map<String, FileDownloadHandlerProxy> handlers = new HashMap<String, FileDownloadHandlerProxy>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(String name) {
            Object object = this.LOCKED;
            synchronized (object) {
                if (name == null || name.trim().length() == 0) {
                    return;
                }
                if (!this.handlers.containsKey(name)) {
                    this.handlers.put(name, new FileDownloadHandlerProxy());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregister(String name) {
            Object object = this.LOCKED;
            synchronized (object) {
                if (name == null || name.trim().length() == 0) {
                    return;
                }
                FileDownloadHandlerProxy proxy = this.handlers.remove(name);
                if (proxy != null) {
                    proxy.clear();
                }
            }
        }

        public void add(String name, FileDownloadHandler handler) {
            if (name == null || name.trim().length() == 0 || handler == null) {
                return;
            }
            FileDownloadHandlerProxy proxy = this.handlers.get(name);
            if (proxy != null) {
                proxy.add(handler);
            }
        }

        public void remove(String name, FileDownloadHandler handler) {
            if (name == null || name.trim().length() == 0 || handler == null) {
                return;
            }
            FileDownloadHandlerProxy proxy = this.handlers.get(name);
            if (proxy != null) {
                proxy.remove(handler);
            }
        }

        public void notifyOnTransfer(String fileid, long filesize, long bytesprocessed) {
            FileDownloadHandlerProxy proxy = this.handlers.get(fileid);
            if (proxy != null) {
                proxy.onTransfer(fileid, filesize, bytesprocessed);
            }
        }

        public void notifyOnCompleted(String fileid) {
            FileDownloadHandlerProxy proxy = this.handlers.get(fileid);
            if (proxy != null) {
                proxy.onCompleted(fileid);
            }
        }
    }

    private class FileDownloadHandlerProxy
    implements FileDownloadHandler {
        ArrayList<FileDownloadHandler> handlers = new ArrayList();

        private FileDownloadHandlerProxy() {
        }

        void clear() {
            this.handlers.clear();
        }

        void add(FileDownloadHandler handler) {
            if (handler != null && !this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
        }

        void remove(FileDownloadHandler handler) {
            if (handler != null) {
                this.handlers.remove(handler);
            }
        }

        @Override
        public void onTransfer(String fileid, long filesize, long bytesprocessed) {
            FileDownloadHandler[] arr = this.handlers.toArray(new FileDownloadHandler[0]);
            for (int i = 0; i < arr.length; ++i) {
                try {
                    arr[i].onTransfer(fileid, filesize, bytesprocessed);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onCompleted(String fileid) {
            FileDownloadHandler[] arr = this.handlers.toArray(new FileDownloadHandler[0]);
            for (int i = 0; i < arr.length; ++i) {
                try {
                    arr[i].onCompleted(fileid);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

