/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class DBServiceResultSetMetaData
implements ResultSetMetaData {
    private List<Map> metaData;

    public DBServiceResultSetMetaData(List<Map> list) {
        this.metaData = list;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.metaData.size();
    }

    private Map getColumn(int column) {
        return this.metaData.get(column - 1);
    }

    private boolean getBoolValue(int column, String name) {
        return Boolean.valueOf(this.getColumn(column).get(name) + "");
    }

    private int getIntValue(int column, String name) {
        return Integer.valueOf(this.getColumn(column).get(name) + "");
    }

    private String getStringValue(int column, String name) {
        return (String)this.getColumn(column).get(name);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getBoolValue(column, "autoIncrement");
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getBoolValue(column, "caseSensitive");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getBoolValue(column, "searchable");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getBoolValue(column, "currency");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getIntValue(column, "nullable");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getBoolValue(column, "signed");
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getIntValue(column, "columnDisplaySize");
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getStringValue(column, "columnLabel");
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getStringValue(column, "columnName");
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getStringValue(column, "schemaName");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getIntValue(column, "precision");
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getIntValue(column, "scale");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getStringValue(column, "tableName");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getStringValue(column, "catalogName");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getIntValue(column, "columnType");
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getStringValue(column, "columnTypeName");
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getBoolValue(column, "readOnly");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getBoolValue(column, "writable");
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.getBoolValue(column, "definitelyWritable");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getStringValue(column, "columnClassName");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("not supported");
    }
}

