/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service.jdbc;

import com.rameses.service.jdbc.DBService;
import com.rameses.service.jdbc.DBServiceDatabaseMetaData;
import com.rameses.service.jdbc.DBServiceImpl;
import com.rameses.service.jdbc.DBServiceStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class DBServiceConnection
implements Connection {
    private DBService scriptService;
    private DBServiceDatabaseMetaData dbmeta;
    private Map conf;

    public DBServiceConnection(Map conf, String serviceName) {
        this.conf = conf;
        this.scriptService = new DBServiceImpl(conf, serviceName);
    }

    public DBServiceConnection(Map conf) {
        this.conf = conf;
        this.scriptService = new DBServiceImpl(conf, null, null);
    }

    public DBServiceConnection(String host, String cluster, String appContext) {
        this(host, cluster, appContext, null);
    }

    public DBServiceConnection(String host, String cluster, String appContext, String adapterName) {
        this(host, cluster, appContext, adapterName, null);
    }

    public DBServiceConnection(String host, String cluster, String appContext, String adapterName, String serviceName) {
        this.conf = new HashMap();
        this.conf.put("app.cluster", cluster);
        this.conf.put("app.host", host);
        this.conf.put("app.context", appContext);
        this.scriptService = new DBServiceImpl(this.conf, adapterName, serviceName);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DBServiceStatement(null, this.scriptService, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DBServiceStatement(sql, this.scriptService, this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return true;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.dbmeta == null) {
            this.dbmeta = new DBServiceDatabaseMetaData(this, this.conf);
        }
        return this.dbmeta;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLException("Method not supported. setReadOnly");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setSchema(String string) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abort(Executor exctr) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor exctr, int i) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

