/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.workspace;

import com.rameses.platform.interfaces.AppLoader;
import com.rameses.platform.interfaces.MainWindow;
import com.rameses.platform.interfaces.Notifier;
import com.rameses.platform.interfaces.Platform;
import com.rameses.platform.interfaces.SubPlatform;
import com.rameses.platform.interfaces.ViewContext;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.impl.NotifierImpl;
import com.rameses.rcp.workspace.WorkspaceDefaultTpl;
import com.rameses.rcp.workspace.WorkspaceViewContext;
import com.rameses.rcp.workspace.WorkspaceWindow;
import java.net.URLClassLoader;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class Workspace
implements SubPlatform {
    private String workspaceName;
    private String workspaceId = "workspace-" + new UID() + ":";
    private Platform parent;
    private Map conf = new HashMap();
    private WorkspaceWindow mainWindow;
    private Class<? extends JComponent> pageTemplate = WorkspaceDefaultTpl.class;
    private String templateTitle;
    private boolean showMenubar;
    private boolean showToolbar;
    private boolean showStatusbar;
    private Map virtualEnv = new HashMap();
    private boolean loaded;
    private NotifierImpl notifier;

    public static final Workspace create(Map conf) {
        ClientContext ctx = ClientContext.getCurrentContext();
        Workspace ws = new Workspace();
        Platform parent = ctx.getPlatform();
        if (parent instanceof SubPlatform) {
            parent = ((SubPlatform)parent).getParent();
        }
        ws.parent = parent;
        HashMap newEnv = new HashMap(ctx.getAppEnv());
        if (conf != null) {
            ws.conf = conf;
            if (conf.get("env") != null) {
                newEnv.put("CLIENT_ENV", conf.get("env"));
            }
            if (conf.get("permissions") != null) {
                newEnv.put("CLIENT_PERMISSIONS", conf.get("permissions"));
            }
            if (conf.get("loaderType") != null) {
                newEnv.put("LOADER_TYPE", conf.get("loaderType"));
            }
            if (conf.get("showStatusbar") != null) {
                ws.showStatusbar = "true".equals(conf.get("showStatusbar") + "");
            }
            if (conf.get("showMenubar") != null) {
                ws.showMenubar = "true".equals(conf.get("showMenubar") + "");
            }
            if (conf.get("showToolbar") != null) {
                ws.showToolbar = "true".equals(conf.get("showToolbar") + "");
            }
            if (conf.get("titlePrefix") != null) {
                ws.workspaceName = conf.get("titlePrefix").toString();
            }
            if (conf.get("pageTemplate") != null) {
                ws.setTemplate(conf.get("pageTemplate"));
            }
            if (conf.get("templateTitle") != null) {
                ws.templateTitle = conf.get("templateTitle").toString();
            }
            if (conf.get("params") != null) {
                newEnv.put("PROPERTIES", conf.get("params"));
            }
        }
        ws.virtualEnv = newEnv;
        return ws;
    }

    public Workspace() {
        this.mainWindow = new WorkspaceWindow();
    }

    public void show(String title) {
        this.load();
        this.mainWindow.setMenubarVisible(this.showMenubar);
        this.mainWindow.setToolbarVisible(this.showToolbar);
        title = title != null ? title : (this.workspaceName != null ? this.workspaceName : this.workspaceId);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("title", title);
        props.put("id", this.workspaceId);
        this.parent.showWindow(null, new WorkspaceViewContext(title, this), props);
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        try {
            ClientContext ctx = ClientContext.getCurrentContext();
            URLClassLoader moduleCL = (URLClassLoader)ctx.getClassLoader();
            URLClassLoader subLoader = new URLClassLoader(moduleCL.getURLs(), moduleCL.getParent());
            String appLoaderClass = (String)ctx.getAppEnv().get("app.loader");
            AppLoader appLoader = (AppLoader)subLoader.loadClass(appLoaderClass).newInstance();
            appLoader.load(subLoader, this.virtualEnv, this);
            this.loaded = true;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    void setTemplate(Object tpl) {
        try {
            if (tpl != null) {
                if (tpl instanceof String) {
                    this.pageTemplate = this.getClass().getClassLoader().loadClass(tpl.toString());
                } else if (tpl instanceof Class) {
                    this.pageTemplate = (Class)tpl;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Class<? extends JComponent> getTemplate() {
        return this.pageTemplate;
    }

    Map getConf() {
        return this.conf;
    }

    String getTemplateTitle() {
        return this.templateTitle;
    }

    @Override
    public void showStartupWindow(JComponent actionSource, JComponent comp, Map properties) {
        this.mainWindow.setComponent(comp, "content");
    }

    @Override
    public void showWindow(JComponent actionSource, JComponent comp, Map properties) {
        String id = (String)properties.get("id");
        properties.put("id", this.workspaceId + id);
        String title = (String)properties.get("title");
        properties.put("title", (this.workspaceName != null ? this.workspaceName + ":" : "") + (title != null ? title : id));
        if (comp instanceof ViewContext) {
            comp = new WorkspaceViewContext(title, this, (ViewContext)((Object)comp));
        }
        this.parent.showWindow(actionSource, comp, properties);
    }

    @Override
    public void showPopup(JComponent actionSource, JComponent comp, Map properties) {
        String id = (String)properties.get("id");
        properties.put("id", this.workspaceId + id);
        String title = (String)properties.get("title");
        properties.put("title", (this.workspaceName != null ? this.workspaceName + ":" : "") + (title != null ? title : id));
        if (comp instanceof ViewContext) {
            comp = new WorkspaceViewContext(title, this, (ViewContext)((Object)comp));
        }
        this.parent.showPopup(actionSource, comp, properties);
    }

    @Override
    public void showFloatingWindow(JComponent owner, JComponent comp, Map properties) {
        String id = (String)properties.get("id");
        properties.put("id", this.workspaceId + id);
        String title = (String)properties.get("title");
        properties.put("title", (this.workspaceName != null ? this.workspaceName + ":" : "") + (title != null ? title : id));
        if (comp instanceof ViewContext) {
            comp = new WorkspaceViewContext(title, this, (ViewContext)((Object)comp));
        }
        this.parent.showFloatingWindow(owner, comp, properties);
    }

    @Override
    public void showError(JComponent actionSource, Exception e) {
        this.parent.showError(actionSource, e);
    }

    @Override
    public boolean showConfirm(JComponent actionSource, Object message) {
        return this.parent.showConfirm(actionSource, message);
    }

    @Override
    public void showInfo(JComponent actionSource, Object message) {
        this.parent.showInfo(actionSource, message);
    }

    @Override
    public void showAlert(JComponent actionSource, Object message) {
        this.parent.showAlert(actionSource, message);
    }

    @Override
    public Object showInput(JComponent actionSource, Object message) {
        return this.parent.showInput(actionSource, message);
    }

    @Override
    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public Notifier getNotifier() {
        if (this.notifier == null) {
            this.notifier = new NotifierImpl();
        }
        return this.notifier;
    }

    @Override
    public boolean isWindowExists(String id) {
        return this.parent.isWindowExists(this.workspaceId + id);
    }

    @Override
    public void closeWindow(String id) {
        this.parent.closeWindow(this.workspaceId + id);
    }

    @Override
    public void activateWindow(String id) {
        this.parent.activateWindow(this.workspaceId + id);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void logoff() {
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public Platform getParent() {
        return this.parent;
    }

    public String getId() {
        return this.workspaceId;
    }

    public void setId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }
}

