/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ValidatorException;
import com.rameses.rcp.ui.UIControlEvent;
import com.rameses.rcp.ui.UIControlHandler;
import com.rameses.rcp.ui.UIInput;
import com.rameses.util.BreakException;
import com.rameses.util.ExceptionManager;
import com.rameses.util.ValueUtil;
import java.beans.Beans;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

public class UIInputUtil {
    public static UIInputVerifier VERIFIER = new UIInputVerifier();

    public static synchronized void updateBeanValue(UIInput control) {
        UIInputUtil.updateBeanValue(control, true, true);
    }

    public static synchronized void updateBeanValue(UIInput control, boolean addLog, boolean refresh) {
        block4: {
            try {
                UIInputUtil.updateBeanValueImpl(control, addLog, refresh);
            }
            catch (BreakException be) {
                if (control != null) {
                    control.refresh();
                }
            }
            catch (Exception e) {
                Exception src = ExceptionManager.getOriginal((Exception)e);
                if (ExceptionManager.getInstance().handleError(src)) break block4;
                ClientContext.getCurrentContext().getPlatform().showError((JComponent)((Object)control), e);
            }
        }
    }

    private static synchronized void updateBeanValueImpl(UIInput control, boolean addLog, boolean refresh) {
        Support support = (Support)((JComponent)((Object)control)).getClientProperty(Support.class);
        if (support != null) {
            if (control instanceof JComponent) {
                support.setValue(control.getName(), control.getValue(), (JComponent)((Object)control));
            } else {
                support.setValue(control.getName(), control.getValue());
            }
            return;
        }
        Binding binding = control.getBinding();
        if (binding == null) {
            return;
        }
        Object bean = binding.getBean();
        if (bean == null) {
            return;
        }
        EventHelper eventHelper = new EventHelper();
        if (eventHelper.allowCustomUpdate(control)) {
            eventHelper.fireCustomUpdate(control);
            return;
        }
        ClientContext ctx = ClientContext.getCurrentContext();
        PropertyResolver resolver = PropertyResolver.getInstance();
        String name = control.getName();
        if (ValueUtil.isEmpty((Object)name)) {
            return;
        }
        Object inputValue = control.getValue();
        Object beanValue = resolver.getProperty(bean, name);
        boolean forceUpdate = false;
        if (control instanceof JComponent) {
            Object value = ((JComponent)((Object)control)).getClientProperty(JTable.class);
            boolean bl = forceUpdate = value != null;
        }
        if (forceUpdate || !ValueUtil.isEqual((Object)inputValue, (Object)beanValue)) {
            binding.getValidatorSupport().fireFieldValidators(name, inputValue);
            resolver.setProperty(bean, name, inputValue);
            if (addLog) {
                binding.getChangeLog().addEntry(bean, name, beanValue, inputValue);
            }
            UIInputUtil.createHandlerSupport(control).valueChanged(inputValue);
            binding.getValueChangeSupport().notify(name, inputValue);
            if (refresh && control instanceof JTextComponent) {
                JTextComponent jtxt = (JTextComponent)((Object)control);
                int oldCaretPos = jtxt.getCaretPosition();
                try {
                    control.refresh();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                finally {
                    try {
                        jtxt.setCaretPosition(oldCaretPos);
                    }
                    catch (Exception exception) {}
                }
                jtxt.putClientProperty("CaretPosition", oldCaretPos);
            }
            binding.notifyDepends(control);
            eventHelper.fireAfterUpdate(control, inputValue);
        } else if (!(control instanceof JComboBox)) {
            control.refresh();
        }
    }

    public static synchronized HandlerSupport createHandlerSupport(UIInput uic) {
        return new HandlerSupport(uic);
    }

    public static class HandlerSupport {
        private UIInput uic;

        HandlerSupport(UIInput uic) {
            this.uic = uic;
        }

        UIControlHandler getControlHandler() {
            Object o = this.uic.getClientProperty(UIControlHandler.class);
            if (o instanceof UIControlHandler) {
                return (UIControlHandler)o;
            }
            return null;
        }

        public void valueChanged(Object value) {
            UIControlHandler uihandler = this.getControlHandler();
            if (uihandler != null) {
                uihandler.valueChanged(new UIControlEvent(this.uic, value));
            }
        }
    }

    private static class EventHelper {
        private EventHelper() {
        }

        boolean allowCustomUpdate(UIInput ui) {
            Object o = ui.getClientProperty(EventHandler.class);
            if (o instanceof EventHandler) {
                return ((EventHandler)o).allowCustomUpdate();
            }
            return false;
        }

        void fireCustomUpdate(UIInput ui) {
            Object o = ui.getClientProperty(EventHandler.class);
            if (o instanceof EventHandler) {
                ((EventHandler)o).customUpdate();
            }
        }

        void fireAfterUpdate(UIInput ui, Object value) {
            Object o = ui.getClientProperty(EventHandler.class);
            if (o instanceof EventHandler) {
                ((EventHandler)o).afterUpdate(value);
            }
        }
    }

    public static interface EventHandler {
        public boolean allowCustomUpdate();

        public void customUpdate();

        public void afterUpdate(Object var1);
    }

    public static interface Support {
        public Object setValue(String var1, Object var2);

        public Object setValue(String var1, Object var2, JComponent var3);
    }

    public static class UIInputVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            block13: {
                if (Beans.isDesignTime()) {
                    return true;
                }
                UIInput control = null;
                if (input instanceof UIInput) {
                    control = (UIInput)((Object)input);
                } else {
                    Object delegator = input.getClientProperty(UIInput.class);
                    if (delegator instanceof UIInput) {
                        control = (UIInput)delegator;
                    } else {
                        throw new IllegalStateException("UIInputVerifier should be used for UIInput controls only.");
                    }
                }
                if (control.isReadonly() || !input.isEnabled()) {
                    return true;
                }
                if (input instanceof JTextComponent && !((JTextComponent)input).isEditable()) {
                    return true;
                }
                if (input.getParent() == null) {
                    return true;
                }
                try {
                    UIInputUtil.updateBeanValueImpl(control, true, true);
                }
                catch (BreakException be) {
                    if (control != null) {
                        control.refresh();
                    }
                }
                catch (Exception e) {
                    Exception src = ExceptionManager.getOriginal((Exception)e);
                    if (!ExceptionManager.getInstance().handleError(src)) {
                        ClientContext.getCurrentContext().getPlatform().showError((JComponent)((Object)control), e);
                    }
                    if (!(e instanceof ValidatorException)) break block13;
                    return false;
                }
            }
            return true;
        }
    }
}

