/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.common.MethodResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.AsyncAction;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NavigatablePanel;
import com.rameses.rcp.framework.NavigationHandler;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.ui.UICommand;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.BreakException;
import com.rameses.util.BusinessException;
import com.rameses.util.ExceptionManager;
import com.rameses.util.IgnoreException;
import com.rameses.util.ValueUtil;
import java.awt.EventQueue;
import java.beans.Beans;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class UICommandUtil {
    public static Object processAction(UICommand command) {
        if (Beans.isDesignTime()) {
            return null;
        }
        ClientContext ctx = ClientContext.getCurrentContext();
        UICommandSupport uics = new UICommandSupport();
        MethodResolver resolver = uics.getMethodResolver();
        Object callbackErrorHandler = null;
        Binding binding = null;
        try {
            NavigationHandler handler;
            binding = command.getBinding();
            binding.formCommit();
            UICommandUtil.validate(command, binding);
            String target = ValueUtil.isEmpty((Object)command.getTarget()) ? "parent" : command.getTarget();
            NavigatablePanel navPanel = UIControlUtil.getParentPanel((JComponent)((Object)command), target);
            if (!"parent".equals(target)) {
                UIControllerContext rootCon = navPanel.getControllers().peek();
                Binding rootBinding = rootCon.getCurrentView().getBinding();
                UICommandUtil.validate(command, rootBinding);
            }
            XButton btn = (XButton)command;
            ControlSupport.setProperties(binding.getBean(), btn.getParams());
            binding.getActionHandlerSupport().fireBeforeExecute();
            Object outcome = null;
            String action = command.getActionName();
            if (btn.getClientProperty(Action.class.getName()) != null) {
                Action a = (Action)btn.getClientProperty(Action.class.getName());
                outcome = a.execute();
            } else if (action != null) {
                if (!action.startsWith("_")) {
                    Object bb;
                    Object[] actionParams = new Object[]{};
                    Object actionInvoker = btn.getClientProperty("Action.Invoker");
                    if (actionInvoker != null) {
                        actionParams = new Object[]{actionInvoker};
                    }
                    if ((bb = command.getClientProperty("Action.Bean")) == null) {
                        bb = binding.getBean();
                    }
                    outcome = UICommandUtil.hasMethod(bb, action, actionParams) ? resolver.invoke(bb, action, actionParams) : resolver.invoke(bb, action, null, null);
                } else {
                    outcome = action;
                }
                if (command.isUpdate()) {
                    binding.update();
                }
            }
            binding.getActionHandlerSupport().fireAfterExecute();
            if (outcome instanceof PopupMenuOpener) {
                return outcome;
            }
            if (outcome instanceof AsyncAction) {
                return outcome;
            }
            Opener opener = null;
            if (outcome instanceof Opener) {
                opener = (Opener)outcome;
                if ("_close".equals(opener.getOutcome())) {
                    outcome = "_close";
                } else if (opener.isAsync()) {
                    String str = opener.getTarget();
                    if (!"popup".equals(str)) {
                        opener.setTarget("popup");
                    }
                    outcome = "_close";
                    uics.navigate(binding, opener);
                } else {
                    uics.initOpenerParams(binding, opener);
                }
            }
            if ((handler = ctx.getNavigationHandler()) != null) {
                if (opener != null) {
                    callbackErrorHandler = opener.getProperties().get("windowError");
                }
                navPanel = UIControlUtil.getParentPanel((JComponent)((Object)command), "parent");
                if (opener != null && "popupmenu".equals(opener.getTarget())) {
                    handler.navigate(navPanel, command, opener);
                    return null;
                }
                handler.navigate(navPanel, command, outcome);
                Object pmo = command.getClientProperty(PopupMenuOpener.class);
                if (pmo != null) {
                    command.putClientProperty(PopupMenuOpener.class, null);
                    return (PopupMenuOpener)pmo;
                }
                if (opener != null) {
                    Object closeBehindOnStart = opener.getProperties().get("closeBehindOnStart");
                    if ("true".equals(closeBehindOnStart + "")) {
                        binding.fireNavigation("_close");
                    }
                    if ("topwindow".equalsIgnoreCase(opener.getTarget() + "")) {
                        binding.fireNavigation("_close");
                    }
                }
            }
            return null;
        }
        catch (Throwable t) {
            Exception ex = t instanceof Exception ? (Exception)t : new RuntimeException(t);
            Exception e = ExceptionManager.getOriginal((Exception)ex);
            if (e instanceof IgnoreException || e instanceof BreakException) {
                return null;
            }
            if (!ExceptionManager.getInstance().handleError(e)) {
                ctx.getPlatform().showError((JComponent)((Object)command), ex);
            }
            new Thread(new CallbackErrorNotifier(callbackErrorHandler)).start();
            return null;
        }
    }

    public static void processAction(JComponent invoker, Binding binding, Action action) {
        block6: {
            if (Beans.isDesignTime()) {
                return;
            }
            ClientContext ctx = ClientContext.getCurrentContext();
            MethodResolver resolver = MethodResolver.getInstance();
            try {
                Object[] actionParams = new Object[]{};
                Object actionInvoker = action.getProperties().get("Action.Invoker");
                if (actionInvoker != null) {
                    actionParams = new Object[]{actionInvoker};
                }
                Object outcome = null;
                String command = action.getName();
                outcome = UICommandUtil.hasMethod(binding.getBean(), command, actionParams) ? resolver.invoke(binding.getBean(), command, actionParams) : resolver.invoke(binding.getBean(), command, null, null);
                if (outcome != null) {
                    binding.fireNavigation(outcome);
                }
            }
            catch (Throwable t) {
                Exception ex = t instanceof Exception ? (Exception)t : new RuntimeException(t);
                Exception e = ExceptionManager.getOriginal((Exception)ex);
                if (e instanceof IgnoreException || e instanceof BreakException) {
                    return;
                }
                if (ExceptionManager.getInstance().handleError(e)) break block6;
                ctx.getPlatform().showError(invoker, ex);
            }
        }
    }

    public static void processAction(JComponent invoker, Binding binding, Opener anOpener) {
        block5: {
            if (Beans.isDesignTime()) {
                return;
            }
            ClientContext ctx = ClientContext.getCurrentContext();
            try {
                if (anOpener != null) {
                    binding.fireNavigation(anOpener);
                }
            }
            catch (Throwable t) {
                Exception ex = t instanceof Exception ? (Exception)t : new RuntimeException(t);
                Exception e = ExceptionManager.getOriginal((Exception)ex);
                if (e instanceof IgnoreException || e instanceof BreakException) {
                    return;
                }
                if (ExceptionManager.getInstance().handleError(e)) break block5;
                ctx.getPlatform().showError(invoker, ex);
            }
        }
    }

    private static void validate(UICommand command, Binding binding) throws BusinessException {
        if (binding == null) {
            return;
        }
        if (!command.isUpdate() && command.isImmediate()) {
            return;
        }
        binding.validate();
    }

    private static boolean hasMethod(Object bean, String name, Object[] args) {
        if (bean == null || name == null) {
            return false;
        }
        for (Class<?> beanClass = bean.getClass(); beanClass != null; beanClass = beanClass.getSuperclass()) {
            Method[] methods = beanClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int argSize;
                Method m = methods[i];
                if (!m.getName().equals(name)) continue;
                int paramSize = m.getParameterTypes() == null ? 0 : m.getParameterTypes().length;
                int n = argSize = args == null ? 0 : args.length;
                if (paramSize == argSize && paramSize == 0) {
                    return true;
                }
                if (paramSize != argSize || m.getParameterTypes()[0] != Object.class) continue;
                return true;
            }
        }
        return false;
    }

    private static class CallbackErrorNotifier
    implements Runnable {
        private Object callback;

        CallbackErrorNotifier(Object callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallbackErrorNotifier.this.runImpl();
                }
            });
        }

        private void runImpl() {
            try {
                if (this.callback == null) {
                    return;
                }
                if (this.callback instanceof Runnable) {
                    ((Runnable)this.callback).run();
                } else {
                    new CallbackHandlerProxy(this.callback).call();
                }
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }

    private static class UICommandSupport {
        private MethodResolver methodResolver;
        private PropertyResolver propertyResolver;

        private UICommandSupport() {
        }

        private MethodResolver getMethodResolver() {
            if (this.methodResolver == null) {
                this.methodResolver = MethodResolver.getInstance();
            }
            return this.methodResolver;
        }

        private PropertyResolver getPropertyResolver() {
            if (this.propertyResolver == null) {
                this.propertyResolver = PropertyResolver.getInstance();
            }
            return this.propertyResolver;
        }

        private void initOpenerParams(Binding binding, Opener opener) {
            try {
                Object bean = binding.getBean();
                Object paramEntity = null;
                try {
                    paramEntity = this.getPropertyResolver().getProperty(bean, "entity");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                HashMap<String, Object> openerParams = opener.getParams();
                if (openerParams == null) {
                    openerParams = new HashMap<String, Object>();
                }
                try {
                    Map params = (Map)this.getMethodResolver().invoke(bean, "getOpenerParams", new Object[0]);
                    if (params != null) {
                        openerParams.putAll(params);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (paramEntity != null && !openerParams.containsKey("entity")) {
                    openerParams.put("entity", paramEntity);
                }
                opener.setParams(openerParams);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void navigate(final Binding binding, final Opener opener) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    binding.fireNavigation(opener);
                }
            };
            new Thread(runnable).start();
        }
    }
}

